/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.legacy;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.legacy.NodeType;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.IOUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class NodeRelationshipCache
implements MemoryStatsVisitor.Visitable,
AutoCloseable {
    private static final int CHUNK_SIZE = 1000000;
    private static final long EMPTY = -1L;
    private static final long MAX_RELATIONSHIP_ID = 0xFFFFFFFFFFFEL;
    static final int MAX_SMALL_COUNT = 0xFFFFFFE;
    static final long MAX_COUNT = 0x7FFFFFFFFL;
    private static final int ID_SIZE = 6;
    private static final int COUNT_SIZE = 4;
    private static final int ID_AND_COUNT_SIZE = 10;
    private static final int SPARSE_ID_OFFSET = 0;
    private static final int SPARSE_COUNT_OFFSET = 6;
    private static final int DENSE_NODE_CHANGED_MASK = Integer.MIN_VALUE;
    private static final int SPARSE_NODE_CHANGED_MASK = 0x40000000;
    private static final int BIG_COUNT_MASK = 0x20000000;
    private static final int EXPLICITLY_DENSE_MASK = 0x10000000;
    private static final int COUNT_FLAGS_MASKS = -268435456;
    private static final int COUNT_MASK = 0xFFFFFFF;
    private static final int TYPE_SIZE = 3;
    public static final int GROUP_ENTRY_SIZE = 9 + 10 * Direction.values().length;
    private ByteArray array;
    private byte[] chunkChangedArray;
    private final int denseNodeThreshold;
    private final MemoryTracker memoryTracker;
    private final RelGroupCache relGroupCache;
    private long highNodeId;
    private volatile boolean forward = true;
    private final int chunkSize;
    private final NumberArrayFactory arrayFactory;
    private final LongArray bigCounts;
    private final AtomicInteger bigCountsCursor = new AtomicInteger();
    private long numberOfDenseNodes;
    public static final GroupVisitor NO_GROUP_VISITOR = (nodeId, typeId, out, in, loop) -> -1L;

    public NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold, MemoryTracker memoryTracker) {
        this(arrayFactory, denseNodeThreshold, 1000000, memoryTracker);
    }

    NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold, int chunkSize, MemoryTracker memoryTracker) {
        this.arrayFactory = arrayFactory;
        this.chunkSize = chunkSize;
        this.denseNodeThreshold = denseNodeThreshold;
        this.memoryTracker = memoryTracker;
        this.bigCounts = arrayFactory.newDynamicLongArray(1000, 0L, memoryTracker);
        this.relGroupCache = new RelGroupCache(arrayFactory, chunkSize, memoryTracker);
    }

    public long incrementCount(long nodeId) {
        return this.incrementCount(this.array, nodeId, 6);
    }

    @VisibleForTesting
    public void setCount(long nodeId, long count, int typeId, Direction direction) {
        if (this.isDense(nodeId)) {
            long relGroupId = this.getRelationshipId(nodeId);
            this.relGroupCache.setCount(relGroupId, typeId, direction, count);
        } else {
            this.setCount(this.array, nodeId, 6, count);
        }
    }

    private void setCount(ByteArray array, long index, int offset, long count) {
        NodeRelationshipCache.assertValidCount(index, count);
        int rawCount = array.getInt(index, offset);
        if (count > 0xFFFFFFEL) {
            int slot;
            if (rawCount == -1 || !NodeRelationshipCache.isBigCount(rawCount)) {
                slot = this.bigCountsCursor.getAndIncrement();
                array.setInt(index, offset, rawCount & 0xF0000000 | 0x20000000 | slot);
            } else {
                slot = NodeRelationshipCache.countValue(rawCount);
            }
            this.bigCounts.set(slot, count);
        } else {
            array.setInt(index, offset, rawCount & 0xF0000000 | Math.toIntExact(count));
        }
    }

    private static void assertValidCount(long nodeId, long count) {
        if (count > 0x7FFFFFFFFL) {
            throw new IllegalStateException("Tried to increment count of node id " + nodeId + " to " + count + ", which is too big in one single import");
        }
    }

    private static boolean isBigCount(int storedCount) {
        return (storedCount & 0x20000000) != 0;
    }

    public void setNodeCount(long nodeCount) {
        if (nodeCount - 1L > 0x7FFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("Invalid number of nodes %d. Max is %d", nodeCount, 0x7FFFFFFFFFL));
        }
        this.highNodeId = nodeCount;
        this.array = this.arrayFactory.newByteArray(this.highNodeId, new byte[10], this.memoryTracker);
        this.chunkChangedArray = new byte[this.chunkOf(nodeCount) + 1];
    }

    private long getCount(ByteArray array, long index, int offset) {
        int rawCount = array.getInt(index, offset);
        int count = NodeRelationshipCache.countValue(rawCount);
        if (NodeRelationshipCache.isBigCount(rawCount)) {
            return this.bigCounts.get(count);
        }
        return count;
    }

    private static int countValue(int rawCount) {
        return rawCount & 0xFFFFFFF;
    }

    private long incrementCount(ByteArray array, long index, int offset) {
        long count = this.getCount(array, index, offset) + 1L;
        this.setCount(array, index, offset, count);
        return count;
    }

    public boolean isDense(long nodeId) {
        if ((long)this.denseNodeThreshold == -1L) {
            return false;
        }
        boolean explicitlyDense = (this.array.getInt(nodeId, 6) & 0x10000000) != 0;
        return explicitlyDense || this.getCount(this.array, nodeId, 6) >= (long)this.denseNodeThreshold;
    }

    public void markAsExplicitlyDense(long nodeId) {
        int bits = this.array.getInt(nodeId, 6);
        this.array.setInt(nodeId, 6, bits | 0x10000000);
    }

    public long getAndPutRelationship(long nodeId, int typeId, Direction direction, long firstRelId, boolean incrementCount) {
        if (firstRelId > 0xFFFFFFFFFFFEL) {
            throw new IllegalArgumentException("Illegal relationship id, max is 281474976710654");
        }
        long existingId = this.getRelationshipId(nodeId);
        boolean dense = this.isDense(nodeId);
        boolean wasChanged = this.markAsChanged(nodeId, NodeRelationshipCache.changeMask(dense));
        this.markChunkAsChanged(nodeId, dense);
        if (dense) {
            if (existingId == -1L) {
                existingId = this.relGroupCache.allocate(typeId);
                this.setRelationshipId(nodeId, existingId);
            }
            return this.relGroupCache.getAndPutRelationship(existingId, typeId, direction, firstRelId, incrementCount);
        }
        this.setRelationshipId(nodeId, firstRelId);
        return wasChanged ? -1L : existingId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void markChunkAsChanged(long nodeId, boolean dense) {
        int chunk;
        byte mask = NodeRelationshipCache.chunkChangeMask(dense);
        if (this.chunkHasChange(nodeId, mask) || (this.chunkChangedArray[chunk = this.chunkOf(nodeId)] & mask) != 0) return;
        byte[] byArray = this.chunkChangedArray;
        synchronized (this.chunkChangedArray) {
            int n = chunk;
            this.chunkChangedArray[n] = (byte)(this.chunkChangedArray[n] | mask);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    long calculateNumberOfDenseNodes() {
        long count = 0L;
        for (long i = 0L; i < this.highNodeId; ++i) {
            if (!this.isDense(i)) continue;
            ++count;
        }
        return count;
    }

    private int chunkOf(long nodeId) {
        return Math.toIntExact(nodeId / (long)this.chunkSize);
    }

    private static byte chunkChangeMask(boolean dense) {
        return (byte)(1 << (dense ? 1 : 0));
    }

    private boolean markAsChanged(long nodeId, int mask) {
        boolean changeBitWasFlipped;
        int bits = this.array.getInt(nodeId, 6);
        boolean changeBitIsSet = (bits & mask) != 0;
        boolean bl = changeBitWasFlipped = changeBitIsSet != this.forward;
        if (changeBitWasFlipped) {
            this.array.setInt(nodeId, 6, bits ^= mask);
        }
        return changeBitWasFlipped;
    }

    private boolean nodeIsChanged(long nodeId, long mask) {
        int bits = this.array.getInt(nodeId, 6);
        if (bits == -1) {
            return false;
        }
        boolean changeBitIsSet = ((long)bits & mask) != 0L;
        return changeBitIsSet == this.forward;
    }

    private void setRelationshipId(long nodeId, long firstRelId) {
        this.array.set6ByteLong(nodeId, 0, firstRelId + 1L);
    }

    private long getRelationshipId(long nodeId) {
        return NodeRelationshipCache.toUnsigned6Byte(this.array.get6ByteLong(nodeId, 0)) - 1L;
    }

    private static long toUnsigned6Byte(long raw) {
        return raw & 0xFFFFFFFFFFFFL;
    }

    public long getFirstRel(long nodeId, GroupVisitor visitor) {
        long id = this.getRelationshipId(nodeId);
        if (id != -1L && this.isDense(nodeId)) {
            return this.relGroupCache.visitGroup(nodeId, id, visitor);
        }
        return id;
    }

    public void setForwardScan(boolean forward, boolean denseNodes) {
        if (this.forward == forward) {
            return;
        }
        if (denseNodes) {
            if (forward) {
                this.visitChangedNodes(nodeId -> this.setRelationshipId(nodeId, -1L), 1);
                this.clearChangedChunks(true);
                this.relGroupCache.clear();
            } else {
                this.relGroupCache.clearRelationshipIds();
            }
        }
        this.forward = forward;
    }

    public long getCount(long nodeId, int typeId, Direction direction, boolean resetCountAfterRead) {
        boolean dense = this.isDense(nodeId);
        if (dense) {
            long id = this.getRelationshipId(nodeId);
            return id == -1L ? 0L : this.relGroupCache.getAndResetCount(id, typeId, direction, resetCountAfterRead);
        }
        return this.getCount(this.array, nodeId, 6);
    }

    public String toString() {
        return this.array.toString();
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.array, this.bigCounts, this.relGroupCache});
    }

    public long highNodeId() {
        return this.highNodeId;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        NodeRelationshipCache.nullSafeMemoryStatsVisitor(this.array, visitor);
        this.relGroupCache.acceptMemoryStatsVisitor(visitor);
    }

    static void nullSafeMemoryStatsVisitor(MemoryStatsVisitor.Visitable visitable, MemoryStatsVisitor visitor) {
        if (visitable != null) {
            visitable.acceptMemoryStatsVisitor(visitor);
        }
    }

    private static int changeMask(boolean dense) {
        return dense ? Integer.MIN_VALUE : 0x40000000;
    }

    public void visitChangedNodes(NodeChangeVisitor visitor, int nodeTypes) {
        this.visitChangedNodes(visitor, nodeTypes, 0L, this.highNodeId);
    }

    public void visitChangedNodes(NodeChangeVisitor visitor, int nodeTypes, long from, long to) {
        long denseMask = NodeRelationshipCache.changeMask(true);
        long sparseMask = NodeRelationshipCache.changeMask(false);
        byte denseChunkMask = NodeRelationshipCache.chunkChangeMask(true);
        byte sparseChunkMask = NodeRelationshipCache.chunkChangeMask(false);
        long nodeId = from;
        while (nodeId < to) {
            boolean nodeHasChanged;
            boolean chunkHasChanged;
            boolean bl = chunkHasChanged = NodeType.isDense(nodeTypes) && this.chunkHasChange(nodeId, denseChunkMask) || NodeType.isSparse(nodeTypes) && this.chunkHasChange(nodeId, sparseChunkMask);
            if (!chunkHasChanged) {
                nodeId = ((long)this.chunkOf(nodeId) + 1L) * (long)this.chunkSize;
                continue;
            }
            boolean bl2 = nodeHasChanged = NodeType.isDense(nodeTypes) && this.nodeIsChanged(nodeId, denseMask) || NodeType.isSparse(nodeTypes) && this.nodeIsChanged(nodeId, sparseMask);
            if (nodeHasChanged && NodeType.matchesDense(nodeTypes, this.isDense(nodeId))) {
                visitor.change(nodeId);
            }
            ++nodeId;
        }
    }

    private void clearChangedChunks(boolean denseNodes) {
        byte chunkMask = NodeRelationshipCache.chunkChangeMask(denseNodes);
        int i = 0;
        while (i < this.chunkChangedArray.length) {
            int n = i++;
            this.chunkChangedArray[n] = (byte)(this.chunkChangedArray[n] & ~chunkMask);
        }
    }

    private boolean chunkHasChange(long nodeId, byte chunkMask) {
        int chunkId = this.chunkOf(nodeId);
        return (this.chunkChangedArray[chunkId] & chunkMask) != 0;
    }

    public long calculateMaxMemoryUsage(long numberOfRelationships) {
        return NodeRelationshipCache.calculateMaxMemoryUsage(this.numberOfDenseNodes, numberOfRelationships);
    }

    public static long calculateMaxMemoryUsage(long numberOfDenseNodes, long numberOfRelationships) {
        long maxDenseNodesForThisType = Long.min(numberOfDenseNodes, numberOfRelationships * 2L);
        return maxDenseNodesForThisType * (long)GROUP_ENTRY_SIZE;
    }

    public void countingCompleted() {
        this.numberOfDenseNodes = this.calculateNumberOfDenseNodes();
    }

    public long getNumberOfDenseNodes() {
        return this.numberOfDenseNodes;
    }

    public static MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
        return visitor -> visitor.offHeapUsage(10L * numberOfNodes);
    }

    private class RelGroupCache
    implements AutoCloseable,
    MemoryStatsVisitor.Visitable {
        private static final int TYPE_OFFSET = 0;
        private static final int NEXT_OFFSET = 3;
        private static final int BASE_IDS_OFFSET = 9;
        private final byte[] DEFAULT_VALUE = new byte[GROUP_ENTRY_SIZE];
        private final ByteArray relGroupCacheArray;
        private final AtomicLong nextFreeId = new AtomicLong(0L);

        RelGroupCache(NumberArrayFactory arrayFactory, long chunkSize, MemoryTracker memoryTracker) {
            assert (chunkSize > 0L);
            this.relGroupCacheArray = arrayFactory.newDynamicByteArray((int)chunkSize, this.DEFAULT_VALUE, memoryTracker);
        }

        private void clearIndex(ByteArray array, long relGroupId) {
            array.setElement(relGroupId, this.DEFAULT_VALUE);
        }

        long getAndResetCount(long relGroupIndex, int typeId, Direction direction, boolean resetCountAfterRead) {
            long index = relGroupIndex;
            while (index != -1L) {
                if (this.getTypeId(this.relGroupCacheArray, index) == typeId) {
                    int offset = this.countOffset(direction);
                    long count = NodeRelationshipCache.this.getCount(this.relGroupCacheArray, index, offset);
                    if (resetCountAfterRead) {
                        NodeRelationshipCache.this.setCount(this.relGroupCacheArray, index, offset, 0L);
                    }
                    return count;
                }
                index = this.getNext(this.relGroupCacheArray, index);
            }
            return 0L;
        }

        void setCount(long relGroupIndex, int typeId, Direction direction, long count) {
            long index = relGroupIndex;
            while (index != -1L) {
                if (this.getTypeId(this.relGroupCacheArray, index) == typeId) {
                    NodeRelationshipCache.this.setCount(this.relGroupCacheArray, index, this.countOffset(direction), count);
                    break;
                }
                index = this.getNext(this.relGroupCacheArray, index);
            }
        }

        long getNext(ByteArray array, long index) {
            return NodeRelationshipCache.toUnsigned6Byte(array.get6ByteLong(index, 3)) - 1L;
        }

        int getTypeId(ByteArray array, long index) {
            return array.get3ByteInt(index, 0) & 0xFFFFFF;
        }

        private long nextFreeId() {
            return this.nextFreeId.getAndIncrement();
        }

        private long visitGroup(long nodeId, long relGroupIndex, GroupVisitor visitor) {
            long currentIndex = relGroupIndex;
            long first = -1L;
            while (currentIndex != -1L) {
                long nextId;
                long out = NodeRelationshipCache.toUnsigned6Byte(this.relGroupCacheArray.get6ByteLong(currentIndex, this.idOffset(Direction.OUTGOING))) - 1L;
                long in = NodeRelationshipCache.toUnsigned6Byte(this.relGroupCacheArray.get6ByteLong(currentIndex, this.idOffset(Direction.INCOMING))) - 1L;
                long loop = NodeRelationshipCache.toUnsigned6Byte(this.relGroupCacheArray.get6ByteLong(currentIndex, this.idOffset(Direction.BOTH))) - 1L;
                int typeId = this.getTypeId(this.relGroupCacheArray, currentIndex);
                long next = this.getNext(this.relGroupCacheArray, currentIndex);
                long l = nextId = out == -1L && in == -1L && loop == -1L ? -1L : visitor.visit(nodeId, typeId, out, in, loop);
                if (first == -1L) {
                    first = nextId;
                }
                currentIndex = next;
            }
            return first;
        }

        private int idOffset(Direction direction) {
            return 9 + direction.ordinal() * 10;
        }

        private int countOffset(Direction direction) {
            return this.idOffset(direction) + 6;
        }

        long allocate(int typeId) {
            long index = this.nextFreeId();
            this.clearIndex(this.relGroupCacheArray, index);
            this.relGroupCacheArray.set3ByteInt(index, 0, Numbers.safeCheck3ByteInt((int)typeId));
            return index;
        }

        private long getAndPutRelationship(long relGroupIndex, int typeId, Direction direction, long relId, boolean incrementCount) {
            long index = relGroupIndex;
            index = this.findOrAllocateIndex(index, typeId);
            int directionOffset = this.idOffset(direction);
            long previousId = NodeRelationshipCache.toUnsigned6Byte(this.relGroupCacheArray.get6ByteLong(index, directionOffset)) - 1L;
            this.relGroupCacheArray.set6ByteLong(index, directionOffset, relId + 1L);
            if (incrementCount) {
                NodeRelationshipCache.this.incrementCount(this.relGroupCacheArray, index, this.countOffset(direction));
            }
            return previousId;
        }

        private void clearRelationshipIds(ByteArray array, long index) {
            array.set6ByteLong(index, this.idOffset(Direction.OUTGOING), 0L);
            array.set6ByteLong(index, this.idOffset(Direction.INCOMING), 0L);
            array.set6ByteLong(index, this.idOffset(Direction.BOTH), 0L);
        }

        private long findOrAllocateIndex(long index, int typeId) {
            long lastIndex = index;
            while (index != -1L) {
                lastIndex = index;
                int candidateTypeId = this.getTypeId(this.relGroupCacheArray, index);
                if (candidateTypeId == typeId) {
                    return index;
                }
                index = this.getNext(this.relGroupCacheArray, index);
            }
            long newIndex = this.allocate(typeId);
            this.relGroupCacheArray.set6ByteLong(lastIndex, 3, newIndex + 1L);
            return newIndex;
        }

        @Override
        public void close() {
            if (this.relGroupCacheArray != null) {
                this.relGroupCacheArray.close();
            }
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
            NodeRelationshipCache.nullSafeMemoryStatsVisitor(this.relGroupCacheArray, visitor);
        }

        public void clear() {
            this.nextFreeId.set(0L);
        }

        public void clearRelationshipIds() {
            long highId = this.nextFreeId.get();
            for (long i = 0L; i < highId; ++i) {
                this.clearRelationshipIds(this.relGroupCacheArray, i);
            }
        }
    }

    public static interface GroupVisitor {
        public long visit(long var1, int var3, long var4, long var6, long var8);
    }

    @FunctionalInterface
    public static interface NodeChangeVisitor {
        public void change(long var1);
    }
}

