/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.legacy;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.BitBuffer;

public class NodeLabelsCache
implements MemoryStatsVisitor.Visitable,
AutoCloseable {
    private final LongArray cache;
    private final LongArray spillOver;
    private final AtomicLong spillOverIndex = new AtomicLong();
    private final int bitsPerLabel;
    private final int worstCaseLongsNeeded;
    private final Client putClient;

    public NodeLabelsCache(NumberArrayFactory cacheFactory, long highNodeId, int highLabelId, MemoryTracker memoryTracker) {
        this(cacheFactory, highNodeId, highLabelId, 2000000, memoryTracker);
    }

    public NodeLabelsCache(NumberArrayFactory cacheFactory, long highNodeId, int highLabelId, int spillOverChunkSize, MemoryTracker memoryTracker) {
        this.cache = cacheFactory.newLongArray(highNodeId, 0L, memoryTracker);
        this.spillOver = cacheFactory.newDynamicLongArray(spillOverChunkSize, 0L, memoryTracker);
        this.bitsPerLabel = Math.max(32 - Integer.numberOfLeadingZeros(highLabelId), 1);
        this.worstCaseLongsNeeded = (this.bitsPerLabel * (highLabelId + 1) - 1) / 64 + 1;
        this.putClient = new Client(this.worstCaseLongsNeeded);
    }

    public Client newClient() {
        return new Client(this.worstCaseLongsNeeded);
    }

    public void put(long nodeId, int[] labelIds) {
        this.put(this.putClient, nodeId, labelIds);
    }

    public void put(Client putClient, long nodeId, int[] labelIds) {
        putClient.labelBits.clear(true);
        putClient.labelBits.put(labelIds.length, this.bitsPerLabel);
        for (int labelId : labelIds) {
            putClient.labelBits.put(labelId, this.bitsPerLabel);
        }
        int longsInUse = putClient.labelBits.longsInUse();
        assert (longsInUse > 0) : "Uhm";
        if (longsInUse == 1) {
            this.cache.set(nodeId, putClient.labelScratch[0]);
        } else {
            putClient.fieldBits.clear(true);
            putClient.fieldBits.put(labelIds.length, this.bitsPerLabel);
            long spillOverIndex = this.spillOverIndex.getAndAdd(longsInUse);
            putClient.fieldBits.put(spillOverIndex, 64 - this.bitsPerLabel);
            this.cache.set(nodeId, putClient.fieldBits.getLongs()[0]);
            for (int i = 0; i < longsInUse; ++i) {
                this.spillOver.set(spillOverIndex++, putClient.labelScratch[i]);
            }
        }
    }

    public int[] get(Client client, long nodeId) {
        client.fieldBits.clear(false);
        client.fieldScratch[0] = this.cache.get(nodeId);
        if (client.fieldScratch[0] == 0L) {
            client.target[0] = -1;
            return client.target;
        }
        int length = client.fieldBits.getInt(this.bitsPerLabel);
        int longsInUse = (this.bitsPerLabel * (length + 1) - 1) / 64 + 1;
        client.target = NodeLabelsCache.ensureCapacity(client.target, length);
        if (longsInUse == 1) {
            this.decode(client.fieldBits, length, client.target);
        } else {
            long spillOverIndex = client.fieldBits.getLong(64 - this.bitsPerLabel);
            client.labelBits.clear(false);
            for (int i = 0; i < longsInUse; ++i) {
                client.labelScratch[i] = this.spillOver.get(spillOverIndex + (long)i);
            }
            client.labelBits.getInt(this.bitsPerLabel);
            this.decode(client.labelBits, length, client.target);
        }
        return client.target;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
        this.spillOver.acceptMemoryStatsVisitor(visitor);
    }

    private void decode(BitBuffer bits, int length, int[] target) {
        for (int i = 0; i < length; ++i) {
            target[i] = bits.getInt(this.bitsPerLabel);
        }
        if (target.length > length) {
            target[length] = -1;
        }
    }

    private static int[] ensureCapacity(int[] target, int capacity) {
        return capacity > target.length ? new int[capacity] : target;
    }

    @Override
    public void close() {
        this.cache.close();
        this.spillOver.close();
    }

    public static class Client {
        private final long[] labelScratch;
        private final BitBuffer labelBits;
        private final long[] fieldScratch = new long[1];
        private final BitBuffer fieldBits = BitBuffer.bitsFromLongs((long[])this.fieldScratch);
        private int[] target = new int[20];

        public Client(int worstCaseLongsNeeded) {
            this.labelScratch = new long[worstCaseLongsNeeded];
            this.labelBits = BitBuffer.bitsFromLongs((long[])this.labelScratch);
        }
    }
}

