/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class InputEntity
implements InputEntityVisitor {
    public static final String[] NO_LABELS = ArrayUtils.EMPTY_STRING_ARRAY;
    public static final int NULL_ID = -1;
    private final InputEntityVisitor delegate;
    public boolean hasPropertyId;
    public long propertyId;
    public boolean hasIntPropertyKeyIds;
    public final List<Property> properties = FastList.newList();
    public final List<String> removedProperties = new ArrayList<String>();
    public final MutableIntList intRemovedProperties = IntLists.mutable.empty();
    public ByteBuffer encodedProperties;
    public boolean propertiesOffloaded;
    public boolean hasLongId;
    public long longId;
    public Object objectId;
    public Group idGroup;
    public final List<String> labels = new ArrayList<String>();
    public final List<String> removedLabels = new ArrayList<String>();
    public final MutableIntList intLabels = IntLists.mutable.empty();
    public final MutableIntList intRemovedLabels = IntLists.mutable.empty();
    public boolean hasLabelField;
    public long labelField;
    public boolean hasLongStartId;
    public long longStartId;
    public Object objectStartId;
    public Group startIdGroup;
    public boolean hasLongEndId;
    public long longEndId;
    public Object objectEndId;
    public Group endIdGroup;
    public boolean hasIntType;
    public int intType;
    public String stringType;
    public ApplicationMode applicationMode;
    private boolean end;

    public InputEntity(InputEntityVisitor delegate) {
        this.delegate = delegate;
        this.reset();
    }

    public InputEntity() {
        this(NULL);
    }

    public boolean propertyId(long nextProp) {
        this.checkClear();
        this.hasPropertyId = true;
        this.propertyId = nextProp;
        return this.delegate.propertyId(nextProp);
    }

    public boolean properties(ByteBuffer properties, boolean offloaded) {
        this.checkClear();
        this.encodedProperties = properties;
        this.propertiesOffloaded = offloaded;
        return this.delegate.properties(properties, offloaded);
    }

    public boolean property(String key, Object value, boolean identifier) {
        assert (value != Values.NO_VALUE);
        this.checkClear();
        this.properties.add(new Property(key, value, identifier));
        return this.delegate.property(key, value, identifier);
    }

    public boolean property(int propertyKeyId, Object value, boolean identifier) {
        assert (value != Values.NO_VALUE);
        this.checkClear();
        this.hasIntPropertyKeyIds = true;
        this.properties.add(new Property(propertyKeyId, value, identifier));
        return this.delegate.property(propertyKeyId, value, identifier);
    }

    public boolean removedProperties(String[] keys) {
        this.checkClear();
        Collections.addAll(this.removedProperties, keys);
        return this.delegate.removedProperties(keys);
    }

    public boolean removedProperties(int[] keys) {
        this.checkClear();
        this.intRemovedProperties.addAll(keys);
        return this.delegate.removedProperties(keys);
    }

    public boolean id(long id) {
        this.checkClear();
        this.hasLongId = true;
        this.longId = id;
        return this.delegate.id(id);
    }

    public boolean id(Object id, Group group) {
        this.checkClear();
        this.objectId = id;
        this.idGroup = group;
        return this.delegate.id(id, group);
    }

    public boolean id(Object id, Group group, IdSequence idSequence) {
        this.checkClear();
        this.objectId = id;
        this.idGroup = group;
        return this.delegate.id(id, group, idSequence);
    }

    public boolean labels(String[] labels) {
        this.checkClear();
        Collections.addAll(this.labels, labels);
        return this.delegate.labels(labels);
    }

    public boolean labels(int[] labels) {
        this.checkClear();
        this.intLabels.addAll(labels);
        return this.delegate.labels(labels);
    }

    public boolean removedLabels(String[] labels) {
        this.checkClear();
        Collections.addAll(this.removedLabels, labels);
        return this.delegate.removedLabels(labels);
    }

    public boolean removedLabels(int[] labels) {
        this.checkClear();
        this.intRemovedLabels.addAll(labels);
        return this.delegate.removedLabels(labels);
    }

    public boolean labelField(long labelField) {
        this.checkClear();
        this.hasLabelField = true;
        this.labelField = labelField;
        return this.delegate.labelField(labelField);
    }

    public boolean startId(long id) {
        this.checkClear();
        this.hasLongStartId = true;
        this.longStartId = id;
        return this.delegate.startId(id);
    }

    public boolean startId(Object id, Group group) {
        this.checkClear();
        this.objectStartId = id;
        this.startIdGroup = group;
        return this.delegate.startId(id, group);
    }

    public boolean endId(long id) {
        this.checkClear();
        this.hasLongEndId = true;
        this.longEndId = id;
        return this.delegate.endId(id);
    }

    public boolean endId(Object id, Group group) {
        this.checkClear();
        this.objectEndId = id;
        this.endIdGroup = group;
        return this.delegate.endId(id, group);
    }

    public boolean type(int type) {
        this.checkClear();
        this.hasIntType = true;
        this.intType = type;
        return this.delegate.type(type);
    }

    public boolean type(String type) {
        this.checkClear();
        this.stringType = type;
        return this.delegate.type(type);
    }

    public boolean applicationMode(ApplicationMode mode) {
        this.checkClear();
        this.applicationMode = mode;
        return this.delegate.applicationMode(mode);
    }

    public ApplicationMode applicationMode() {
        return this.applicationMode != null ? this.applicationMode : ApplicationMode.CREATE;
    }

    public void endOfEntity() throws IOException {
        this.end = true;
        this.delegate.endOfEntity();
    }

    public boolean isComplete() {
        return this.end;
    }

    public String[] labels() {
        return this.labels.toArray(new String[0]);
    }

    public Map<String, Object> propertiesAsMap() {
        Preconditions.checkState((!this.hasIntPropertyKeyIds ? 1 : 0) != 0, (String)"This instance doesn't have String keys");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Property p : this.properties) {
            map.put((String)p.key, p.value);
        }
        return map;
    }

    public Map<String, Value> propertiesAsValueMap() {
        Preconditions.checkState((!this.hasIntPropertyKeyIds ? 1 : 0) != 0, (String)"This instance doesn't have String keys");
        HashMap<String, Value> map = new HashMap<String, Value>();
        for (Property p : this.properties) {
            map.put((String)p.key, p.asValue());
        }
        return map;
    }

    public Property getProperty(String key) {
        for (Property p : this.properties) {
            if (!p.key.equals(key)) continue;
            return p;
        }
        return null;
    }

    public Object id() {
        return this.hasLongId ? Long.valueOf(this.longId) : this.objectId;
    }

    public Object endId() {
        return this.hasLongEndId ? Long.valueOf(this.longEndId) : this.objectEndId;
    }

    public Object startId() {
        return this.hasLongStartId ? Long.valueOf(this.longStartId) : this.objectStartId;
    }

    public Object type() {
        return this.stringType != null ? this.stringType : Integer.valueOf(this.intType);
    }

    public long longStartId(IdMapper.Getter idLookup) {
        return this.extractNodeId(this.hasLongStartId, this.longStartId, this.objectStartId, this.startIdGroup, idLookup);
    }

    public long longEndId(IdMapper.Getter idLookup) {
        return this.extractNodeId(this.hasLongEndId, this.longEndId, this.objectEndId, this.endIdGroup, idLookup);
    }

    private long extractNodeId(boolean hasLongId, long longId, Object objectId, Group idGroup, IdMapper.Getter idLookup) {
        if (hasLongId) {
            return longId;
        }
        if (objectId != null) {
            return idLookup.get(objectId, idGroup);
        }
        return -1L;
    }

    private void checkClear() {
        if (this.end) {
            this.reset();
        }
    }

    public void reset() {
        this.end = false;
        this.hasPropertyId = false;
        this.propertyId = -1L;
        this.hasIntPropertyKeyIds = false;
        this.properties.clear();
        this.removedProperties.clear();
        this.intRemovedProperties.clear();
        this.encodedProperties = null;
        this.propertiesOffloaded = false;
        this.hasLongId = false;
        this.longId = -1L;
        this.objectId = null;
        this.idGroup = null;
        this.labels.clear();
        this.removedLabels.clear();
        this.hasLabelField = false;
        this.labelField = -1L;
        this.hasLongStartId = false;
        this.longStartId = -1L;
        this.objectStartId = null;
        this.startIdGroup = null;
        this.hasLongEndId = false;
        this.longEndId = -1L;
        this.objectEndId = null;
        this.endIdGroup = null;
        this.hasIntType = false;
        this.intType = -1;
        this.stringType = null;
        this.applicationMode = null;
        this.intLabels.clear();
        this.intRemovedLabels.clear();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void replayOnto(InputEntityVisitor visitor) throws IOException {
        if (this.applicationMode != null) {
            visitor.applicationMode(this.applicationMode);
        }
        if (this.hasPropertyId) {
            visitor.propertyId(this.propertyId);
        } else if (!this.properties.isEmpty()) {
            for (Property p : this.properties) {
                if (this.hasIntPropertyKeyIds) {
                    visitor.property(((Integer)p.key).intValue(), p.value, p.identifier);
                    continue;
                }
                visitor.property((String)p.key, p.value, p.identifier);
            }
        }
        if (!this.removedProperties.isEmpty()) {
            visitor.removedProperties(this.removedProperties.toArray(new String[0]));
        }
        if (!this.intRemovedProperties.isEmpty()) {
            visitor.removedProperties(this.intRemovedProperties.toArray());
        }
        if (this.hasLongId) {
            visitor.id(this.longId);
        } else if (this.objectId != null) {
            visitor.id(this.objectId, this.idGroup);
        }
        if (this.hasLabelField) {
            visitor.labelField(this.labelField);
        } else {
            if (!this.labels.isEmpty()) {
                visitor.labels(this.labels.toArray(new String[0]));
            }
            if (!this.removedLabels.isEmpty()) {
                visitor.removedLabels(this.removedLabels.toArray(new String[0]));
            }
            if (!this.intLabels.isEmpty()) {
                visitor.labels(this.intLabels.toArray());
            }
            if (!this.intRemovedLabels.isEmpty()) {
                visitor.removedLabels(this.intRemovedLabels.toArray());
            }
        }
        if (this.hasLongStartId) {
            visitor.startId(this.longStartId);
        } else if (this.objectStartId != null) {
            visitor.startId(this.objectStartId, this.startIdGroup);
        }
        if (this.hasLongEndId) {
            visitor.endId(this.longEndId);
        } else if (this.objectEndId != null) {
            visitor.endId(this.objectEndId, this.endIdGroup);
        }
        if (this.hasIntType) {
            visitor.type(this.intType);
        } else if (this.stringType != null) {
            visitor.type(this.stringType);
        }
        visitor.endOfEntity();
    }

    public void updateWithDataFrom(InputEntity increment) {
        for (Property property : increment.properties) {
            this.properties.stream().filter(p -> p.key.equals(property.key)).findFirst().ifPresent(this.properties::remove);
            this.properties.add(property);
        }
        for (String key : increment.removedProperties) {
            this.properties.stream().filter(p -> p.key.equals(key)).findFirst().ifPresent(this.properties::remove);
        }
        increment.labels.stream().filter(l -> !this.labels.contains(l)).forEach(this.labels::add);
        increment.removedLabels.forEach(this.labels::remove);
    }

    public record Property(Object key, Object value, boolean identifier) {
        public Value asValue() {
            Value v;
            Object object = this.value;
            return object instanceof Value ? (v = (Value)object) : Values.of((Object)this.value);
        }
    }
}

