/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.Arrays;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.idmapping.string.AbstractTracker;

public class BigIdTracker
extends AbstractTracker<ByteArray> {
    static final int SIZE = 5;
    static final int ID_BITS = 39;
    static final byte[] DEFAULT_VALUE = new byte[5];
    public static final long ID_MASK = 0x7FFFFFFFFFL;

    public BigIdTracker(ByteArray array) {
        super(array);
    }

    @Override
    public long get(long index) {
        long value = ((ByteArray)this.array).get5ByteLong(index, 0) & 0x7FFFFFFFFFL;
        return value == 0x7FFFFFFFFFL ? -1L : value;
    }

    @Override
    public void set(long index, long value) {
        long isDuplicate = ((ByteArray)this.array).get5ByteLong(index, 0) & 0xFFFFFF8000000000L;
        ((ByteArray)this.array).set5ByteLong(index, 0, isDuplicate | value);
    }

    @Override
    public void markAsDuplicate(long index) {
        ((ByteArray)this.array).set5ByteLong(index, 0, ((ByteArray)this.array).get5ByteLong(index, 0) & 0x7FFFFFFFFFL);
    }

    @Override
    public boolean isMarkedAsDuplicate(long index) {
        long isDuplicate = ((ByteArray)this.array).get5ByteLong(index, 0) & 0xFFFFFF8000000000L;
        return isDuplicate == 0L;
    }

    static {
        Arrays.fill(DEFAULT_VALUE, (byte)-1);
    }
}

