/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumnType;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetDataReader;
import org.neo4j.internal.batchimport.input.parquet.ParquetInputChunk;
import org.neo4j.internal.batchimport.input.parquet.ParquetLogicalColumnType;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;

class ParquetDataInputChunk
implements ParquetInputChunk {
    private ParquetData parquetDataFile;
    private Groups groups;
    private Supplier<ZoneId> defaultTimezoneSupplier;
    private String arrayDelimiter;
    private IdType idType;
    private Iterator<List<Object>> iterator;
    private Collection<String> filteredLabelsOrTypes;
    private final Map<Object, Collection<String>> labelCache = new HashMap<Object, Collection<String>>();

    ParquetDataInputChunk() {
    }

    @Override
    public boolean readWith(ParquetDataReader reader) {
        try {
            this.iterator = reader.next();
            if (this.iterator == null) {
                return false;
            }
            this.parquetDataFile = reader.getParquetDataFile();
            this.groups = reader.getGroups();
            this.defaultTimezoneSupplier = reader.getDefaultTimezoneSupplier();
            this.arrayDelimiter = reader.getArrayDelimiter();
            this.idType = reader.getIdType();
            this.filteredLabelsOrTypes = this.filterEmptyLabelsAndTrim(this.parquetDataFile.labelsOrType());
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
    }

    public boolean next(InputEntityVisitor entityToHydrate) throws IOException {
        if (this.iterator == null || !this.iterator.hasNext()) {
            return false;
        }
        List<ParquetColumn> columns = this.parquetDataFile.columns();
        List<Object> readData = this.iterator.next();
        ArrayList<String> labels = new ArrayList<String>(this.filteredLabelsOrTypes);
        StringBuilder idValue = new StringBuilder();
        String type = this.filteredLabelsOrTypes.isEmpty() ? "" : this.filteredLabelsOrTypes.iterator().next();
        boolean isRelationshipEntity = false;
        for (int i = 0; i < readData.size(); ++i) {
            String typeColumnData;
            ParquetColumn parquetColumn = columns.get(i);
            Object readDatum = readData.get(i);
            if (readDatum == null || this.isEmptyString(readDatum) || parquetColumn.isIgnoredColumn()) continue;
            if (parquetColumn.isIdColumn()) {
                boolean isActualIdColumn;
                if (this.idType == IdType.STRING && (parquetColumn.columnIdType() == IdType.STRING || parquetColumn.columnIdType() == null)) {
                    idValue.append(this.resolveIdByType(readDatum, null));
                } else if (this.idType == IdType.INTEGER || parquetColumn.columnIdType() == IdType.INTEGER) {
                    entityToHydrate.id(this.resolveIdByType(readDatum, parquetColumn.columnIdType()), this.groups.get(this.parquetDataFile.groupName()));
                } else {
                    entityToHydrate.id(((Long)this.resolveIdByType(readDatum, parquetColumn.columnIdType())).longValue());
                }
                boolean bl = isActualIdColumn = this.idType == IdType.ACTUAL && parquetColumn.isIdColumn();
                if (!isActualIdColumn && parquetColumn.hasPropertyName()) {
                    entityToHydrate.property(parquetColumn.propertyName(), this.convertType(readDatum, parquetColumn), true);
                }
            }
            if (parquetColumn.isLabelColumn()) {
                labels.addAll(this.readLabelsFromEntry(readDatum));
            }
            if (parquetColumn.hasPropertyName() && parquetColumn.logicalColumnType() == ParquetLogicalColumnType.PROPERTY) {
                if (readDatum instanceof Map) {
                    Map rawDataMap;
                    Map dataMap = rawDataMap = (Map)readDatum;
                    for (Map.Entry entry : dataMap.entrySet()) {
                        entityToHydrate.property((String)entry.getKey(), this.convertType(entry.getValue(), parquetColumn), parquetColumn.isIdentifier());
                    }
                } else {
                    entityToHydrate.property(parquetColumn.propertyName(), this.convertType(readDatum, parquetColumn), parquetColumn.isIdentifier());
                }
            }
            if (parquetColumn.isStartId()) {
                entityToHydrate.startId(this.resolveIdByType(readDatum, null), this.groups.get(this.parquetDataFile.relationshipStartIdGroupName()));
                isRelationshipEntity = true;
            }
            if (parquetColumn.isEndId()) {
                entityToHydrate.endId(this.resolveIdByType(readDatum, null), this.groups.get(this.parquetDataFile.relationshipEndIdGroupName()));
                isRelationshipEntity = true;
            }
            if (!parquetColumn.isType() || !(readDatum instanceof String) || (typeColumnData = (String)readDatum).isBlank()) continue;
            type = typeColumnData;
        }
        if (!isRelationshipEntity && !labels.isEmpty()) {
            entityToHydrate.labels(labels.toArray(new String[0]));
        }
        if (isRelationshipEntity && type != null && !type.isBlank()) {
            entityToHydrate.type(type);
        }
        if (this.idType == IdType.STRING && !idValue.isEmpty()) {
            entityToHydrate.id((Object)idValue.toString(), this.groups.get(this.parquetDataFile.groupName()));
        }
        entityToHydrate.endOfEntity();
        return true;
    }

    private Object convertType(Object object, ParquetColumn parquetColumn) {
        try {
            if (parquetColumn.isRaw()) {
                return object;
            }
            if (parquetColumn.isArray()) {
                String[] parts = object.toString().split(this.arrayDelimiter);
                Object[] values = new Object[parts.length];
                ParquetColumn nonArrayType = parquetColumn.withoutArray();
                for (int i = 0; i < parts.length; ++i) {
                    values[i] = this.convertType(parts[i], nonArrayType);
                }
                return values;
            }
            return switch (parquetColumn.columnType()) {
                case ParquetColumnType.POINT -> {
                    if (parquetColumn.hasConfiguration()) {
                        yield PointValue.parse((CharSequence)object.toString(), (CSVHeaderInformation)PointValue.parseHeaderInformation((CharSequence)parquetColumn.rawConfiguration()));
                    }
                    yield PointValue.parse((CharSequence)object.toString());
                }
                case ParquetColumnType.DATE -> DateValue.parse((CharSequence)object.toString());
                case ParquetColumnType.TIME -> TimeValue.parse((CharSequence)object.toString(), parquetColumn.getTimezone(this.defaultTimezoneSupplier), null);
                case ParquetColumnType.DATE_TIME -> DateTimeValue.parse((CharSequence)object.toString(), parquetColumn.getTimezone(this.defaultTimezoneSupplier), null);
                case ParquetColumnType.LOCAL_TIME -> LocalTimeValue.parse((CharSequence)object.toString());
                case ParquetColumnType.LOCAL_DATE_TIME -> LocalDateTimeValue.parse((CharSequence)object.toString());
                case ParquetColumnType.DURATION -> DurationValue.parse((CharSequence)object.toString());
                case ParquetColumnType.INT -> Integer.valueOf(object.toString());
                case ParquetColumnType.SHORT -> Short.valueOf(object.toString());
                case ParquetColumnType.STRING -> object.toString();
                case ParquetColumnType.LONG -> Long.valueOf(object.toString());
                case ParquetColumnType.BYTE -> Byte.parseByte(object.toString());
                case ParquetColumnType.DOUBLE -> Double.parseDouble(object.toString());
                case ParquetColumnType.FLOAT -> Float.valueOf(Float.parseFloat(object.toString()));
                default -> object;
            };
        }
        catch (RuntimeException e) {
            throw new InputException("could not convert %s to %s".formatted(new Object[]{object.toString(), parquetColumn.columnType()}), e);
        }
    }

    private boolean isEmptyString(Object object) {
        String stringValue;
        return object instanceof String && (stringValue = (String)object).isEmpty();
    }

    private Object resolveIdByType(Object id, IdType columnIdType) {
        if (id instanceof String) {
            String stringId = (String)id;
            return stringId;
        }
        if (id instanceof Long) {
            Long longId = (Long)id;
            return longId;
        }
        if (id instanceof Integer) {
            Integer intId = (Integer)id;
            if (columnIdType == IdType.INTEGER) {
                return intId;
            }
            return intId.longValue();
        }
        throw new IllegalArgumentException("Cannot convert id of type " + String.valueOf(id.getClass()));
    }

    private Collection<String> filterEmptyLabelsAndTrim(Collection<String> labels) {
        return labels.stream().filter(s -> !s.isEmpty()).map(String::trim).collect(Collectors.toSet());
    }

    private Collection<String> readLabelsFromEntry(Object readDatum) {
        return this.labelCache.computeIfAbsent(readDatum, read -> this.filterEmptyLabelsAndTrim(Arrays.asList(read.toString().split(this.arrayDelimiter))));
    }
}

