/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.string.CollisionValues;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.string.UTF8;

public class StringCollisionValues
implements CollisionValues {
    private final ByteArray cache;
    private final AtomicLong offset = new AtomicLong();

    public StringCollisionValues(NumberArrayFactory factory, long numberOfCollisions, MemoryTracker memoryTracker) {
        int chunkSize = Math.max((int)numberOfCollisions, 8192);
        this.cache = factory.newDynamicByteArray(chunkSize, new byte[1], memoryTracker);
    }

    @Override
    public long add(Object id) {
        long startOffset;
        String string = (String)id;
        byte[] bytes = UTF8.encode((String)string);
        int length = bytes.length;
        if (length > 65535) {
            throw new IllegalArgumentException(string);
        }
        long offset = startOffset = this.offset.getAndAdd(2 + length);
        this.cache.setByte(offset++, 0, (byte)length);
        this.cache.setByte(offset++, 0, (byte)(length >>> 8));
        this.cache.set(offset, bytes);
        return startOffset;
    }

    @Override
    public Object get(long offset) {
        int length = this.cache.getByte(offset++, 0) & 0xFF;
        byte[] bytes = new byte[length |= (this.cache.getByte(offset++, 0) & 0xFF) << 8];
        this.cache.get(offset, bytes);
        return UTF8.decode((byte[])bytes);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

