/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.batchimport.cache.idmapping.IndexIdMapper;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.PlainDatabaseLayout;
import org.neo4j.io.locker.Locker;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;
import org.neo4j.values.ElementIdMapper;

public class IncrementalBatchImportUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable acquireTargetDatabaseLock(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) throws IOException {
        Locker locker = new Locker(fileSystem, databaseLayout.databaseLockFile());
        boolean success = false;
        try {
            locker.checkLock();
            success = true;
        }
        finally {
            if (!success) {
                locker.close();
            }
        }
        return locker;
    }

    public static void copyStoreFiles(FileSystemAbstraction fileSystem, PlainDatabaseLayout fromLayout, DatabaseLayout toLayout, DatabaseFile ... databaseFiles) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (DatabaseFile databaseFile : databaseFiles) {
            paths.add(fromLayout.file(databaseFile));
            fromLayout.idFile(databaseFile).ifPresent(paths::add);
        }
        IncrementalBatchImportUtil.copyStoreFiles(fileSystem, toLayout, paths.toArray(new Path[0]));
    }

    public static void copyStoreFiles(FileSystemAbstraction fileSystem, DatabaseLayout into, Path ... paths) throws IOException {
        for (Path path : paths) {
            fileSystem.copyFile(path, into.file(path.getFileName().toString()));
        }
    }

    public static Map<String, Long> copyIndexFilesFromTargetDatabase(FileSystemAbstraction fileSystem, IndexProvidersAccess indexProvidersAccess, DatabaseLayout databaseLayout, PageCache pageCache, DatabaseLayout incrementalDatabaseLayout, Map<String, SchemaDescriptor> schemaDescriptors, SchemaCache schemaCache, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, CursorContextFactory contextFactory, MemoryTracker memoryTracker) throws IOException {
        IndexProviderMap targetIndexProviders = indexProvidersAccess.access(pageCache, databaseLayout, DatabaseReadOnlyChecker.readOnly(), memoryTracker);
        IndexProviderMap incrementalIndexProviders = indexProvidersAccess.access(pageCache, incrementalDatabaseLayout, DatabaseReadOnlyChecker.readOnly(), memoryTracker);
        Map<String, IndexDescriptor> idMapperIndexes = IncrementalBatchImportUtil.findIdMapperIndexes(schemaDescriptors, schemaCache, tokenNameLookup, openOptions, contextFactory, targetIndexProviders);
        MutableLongSet copiedIndexIds = LongSets.mutable.empty();
        for (Map.Entry<String, IndexDescriptor> entry : idMapperIndexes.entrySet()) {
            IndexDescriptor descriptor = entry.getValue();
            IncrementalBatchImportUtil.assertOwningConstraintExists(schemaCache, descriptor, tokenNameLookup);
            if (!copiedIndexIds.add(descriptor.getId())) continue;
            IncrementalBatchImportUtil.copyIndex(fileSystem, targetIndexProviders, incrementalIndexProviders, descriptor);
            copiedIndexIds.add(descriptor.getId());
        }
        for (ConstraintDescriptor constraint : schemaCache.constraints()) {
            long indexId;
            if (!constraint.enforcesUniqueness() || !copiedIndexIds.add(indexId = constraint.asIndexBackedConstraint().ownedIndexId())) continue;
            IncrementalBatchImportUtil.copyIndex(fileSystem, targetIndexProviders, incrementalIndexProviders, schemaCache.getIndex(indexId));
        }
        return idMapperIndexes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexDescriptor)e.getValue()).getId()));
    }

    public static Map<String, IndexDescriptor> findIdMapperIndexes(Map<String, SchemaDescriptor> schemaDescriptors, SchemaCache schemaCache, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, CursorContextFactory contextFactory, IndexProviderMap targetIndexProviders) {
        HashMap<String, IndexDescriptor> idMapperIndexes = new HashMap<String, IndexDescriptor>();
        for (Map.Entry<String, SchemaDescriptor> entry : schemaDescriptors.entrySet()) {
            IndexDescriptor descriptor = IncrementalBatchImportUtil.findLikelyIndex(schemaCache, entry.getValue(), tokenNameLookup);
            if (idMapperIndexes.put(entry.getKey(), descriptor) != null) continue;
            IndexProvider targetIndexProvider = targetIndexProviders.lookup(descriptor.getIndexProvider());
            IncrementalBatchImportUtil.assertIndexIsOnline(targetIndexProvider, descriptor, openOptions, tokenNameLookup, contextFactory);
        }
        return idMapperIndexes;
    }

    private static IndexDescriptor findLikelyIndex(SchemaCache schemaCache, SchemaDescriptor schemaDescriptor, TokenNameLookup tokenNameLookup) {
        List matches = Iterators.asList((Iterator)schemaCache.indexesForSchema(schemaDescriptor));
        IndexDescriptor descriptor = (IndexDescriptor)Iterators.firstOrNull((Iterator)Iterators.filter(IndexDescriptor::isUnique, matches.iterator()));
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = (IndexDescriptor)Iterators.firstOrNull(matches.iterator());
        Preconditions.checkState((descriptor != null ? 1 : 0) != 0, (String)"Couldn't find a matching index for %s", (Object[])new Object[]{schemaDescriptor.userDescription(tokenNameLookup)});
        return descriptor;
    }

    private static void assertOwningConstraintExists(SchemaCache schemaCache, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        OptionalLong owningConstraintId = descriptor.getOwningConstraintId();
        if (owningConstraintId.isPresent()) {
            long constraintId = owningConstraintId.getAsLong();
            Preconditions.checkState((boolean)schemaCache.hasConstraintRule(Long.valueOf(constraintId)), (String)"Couldn't find a uniqueness constraint for %s", (Object[])new Object[]{descriptor.userDescription(tokenNameLookup)});
        }
    }

    private static void assertIndexIsOnline(IndexProvider indexProvider, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions, TokenNameLookup tokenNameLookup, CursorContextFactory contextFactory) {
        try (CursorContext cursorContext = contextFactory.create("Check index online");){
            InternalIndexState state = indexProvider.getInitialState(descriptor, cursorContext, openOptions);
            Preconditions.checkState((state == InternalIndexState.ONLINE ? 1 : 0) != 0, (String)"Index %s to use for ID mapping is not online, but %s", (Object[])new Object[]{descriptor.userDescription(tokenNameLookup), state});
        }
    }

    public static void copyIndex(FileSystemAbstraction fileSystem, IndexProviderMap fromIndexProviders, IndexProviderMap toIndexProviders, IndexDescriptor indexDescriptor) throws IOException {
        Path from = fromIndexProviders.lookup(indexDescriptor.getIndexProvider()).directoryStructure().directoryForIndex(indexDescriptor.getId());
        Path to = toIndexProviders.lookup(indexDescriptor.getIndexProvider()).directoryStructure().directoryForIndex(indexDescriptor.getId());
        fileSystem.deleteRecursively(to);
        fileSystem.mkdirs(to.getParent());
        fileSystem.copyRecursively(from, to);
    }

    public static void moveIndex(FileSystemAbstraction fileSystem, IndexProviderMap fromIndexProviders, IndexProviderMap toIndexProviders, IndexDescriptor indexDescriptor) throws IOException {
        Path from = fromIndexProviders.lookup(indexDescriptor.getIndexProvider()).directoryStructure().directoryForIndex(indexDescriptor.getId());
        Path to = toIndexProviders.lookup(indexDescriptor.getIndexProvider()).directoryStructure().directoryForIndex(indexDescriptor.getId());
        fileSystem.deleteRecursively(to);
        fileSystem.mkdirs(to.getParent());
        fileSystem.renameFile(from, to, new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
    }

    public static DatabaseLayout findPreparedIncrementalDatabaseLayout(DatabaseLayout databaseLayout) {
        String name = databaseLayout.getNeo4jLayout().databaseLayouts().stream().map(DatabaseLayout::getDatabaseName).filter(databaseName -> databaseName.matches(String.format("^%s-incremental-\\d+$", databaseLayout.getDatabaseName()))).max(Comparator.comparingLong(IncrementalBatchImportUtil::timeStampOf)).orElseThrow(() -> new RuntimeException("No prepared incremental import location to " + databaseLayout.getDatabaseName() + " found"));
        return DatabaseLayout.of((Neo4jLayout)databaseLayout.getNeo4jLayout(), (String)name);
    }

    private static long timeStampOf(String incrementalDatabaseName) {
        int startIndex = -1;
        int stringLength = incrementalDatabaseName.length();
        int i = stringLength - 1;
        while (i >= 0 && Character.isDigit(incrementalDatabaseName.charAt(i))) {
            startIndex = i--;
        }
        Preconditions.checkState((startIndex != -1 ? 1 : 0) != 0, (String)("Invalid incremental database folder " + incrementalDatabaseName));
        return Long.parseLong(incrementalDatabaseName.substring(startIndex));
    }

    public static IndexIdMapper buildIndexIdMapper(Input input, Configuration config, PageCacheTracer pageCacheTracer, PopulationWorkJobScheduler workScheduler, IndexProviderMap indexProviders, SchemaCache schemaCache, Map<String, Long> idMapperIndexes, TokenHolders tokenHolders, ImmutableSet<OpenOption> openOptions, IndexProviderMap tempNewNodesIndexProviders, IndexStatisticsStore indexStatisticsStore, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        HashMap<String, IndexAccessor> accessors = new HashMap<String, IndexAccessor>();
        HashMap<String, IndexDescriptor> indexDescriptors = new HashMap<String, IndexDescriptor>();
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        for (Map.Entry<String, Long> entry : idMapperIndexes.entrySet()) {
            IndexDescriptor indexDescriptor = schemaCache.getIndex(entry.getValue().longValue());
            schemaCache.removeSchemaRule((SchemaRule)indexDescriptor);
            IndexAccessor accessor = indexProviders.lookup(indexDescriptor.getIndexProvider()).getOnlineAccessor(indexDescriptor, indexSamplingConfig, SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, ElementIdMapper.PLACEHOLDER, openOptions, indexingBehaviour);
            accessors.put(entry.getKey(), accessor);
            indexDescriptors.put(entry.getKey(), indexDescriptor);
        }
        Map inputSchema = input.referencedNodeSchema(tokenHolders);
        Preconditions.checkState((boolean)inputSchema.equals(IncrementalBatchImportUtil.asSchemaDescriptors(indexDescriptors)), (String)"Referenced node schema from 'prepare':%s differs from that in 'build':%s.", (Object[])new Object[]{indexDescriptors, inputSchema});
        return new IndexIdMapper(accessors, tempNewNodesIndexProviders, (TokenNameLookup)tokenHolders, indexDescriptors, workScheduler, openOptions, config, pageCacheTracer, indexStatisticsStore, input.groups(), indexingBehaviour);
    }

    public static void mergeIndexes(LongSet affectedIndexes, SchemaCache targetSchemaCache, TokenHolders targetTokenHolders, IndexProviderMap targetIndexProviders, TokenHolders incrementalTokenHolders, IndexProviderMap incrementalIndexProviders, ImmutableSet<OpenOption> openOptions, LongToLongFunction entityIdConverter, ProgressListener progress, List<Closeable> toCloseBeforePageCacheClose, StorageEngineIndexingBehaviour indexingBehaviour, FileSystemAbstraction fileSystem, Config dbConfig, CursorContextFactory contextFactory, Configuration config, JobScheduler jobScheduler) throws IOException {
        LongIterator indexIds = affectedIndexes.longIterator();
        while (indexIds.hasNext()) {
            long indexId = indexIds.next();
            IndexDescriptor index = targetSchemaCache.getIndex(indexId);
            if (index.isUnique()) {
                progress.add(IncrementalBatchImportUtil.estimateIndexSize(targetSchemaCache.getIndex(indexId), incrementalIndexProviders, incrementalTokenHolders, openOptions, indexingBehaviour, dbConfig, contextFactory));
                IncrementalBatchImportUtil.moveIndex(fileSystem, incrementalIndexProviders, targetIndexProviders, index);
            } else {
                try (IndexAccessor incrementalIndex = incrementalIndexProviders.lookup(index.getIndexProvider()).getOnlineAccessor(index, new IndexSamplingConfig(Config.defaults()), (TokenNameLookup)incrementalTokenHolders, ElementIdMapper.PLACEHOLDER, openOptions, indexingBehaviour);){
                    IndexAccessor targetIndex = targetIndexProviders.lookup(index.getIndexProvider()).getOnlineAccessor(index, new IndexSamplingConfig(Config.defaults()), (TokenNameLookup)targetTokenHolders, ElementIdMapper.PLACEHOLDER, openOptions, indexingBehaviour);
                    try {
                        targetIndex.insertFrom(incrementalIndex, entityIdConverter, false, IndexEntryConflictHandler.THROW, null, config.maxNumberOfWorkerThreads(), jobScheduler, progress);
                        toCloseBeforePageCacheClose.add(() -> {
                            try (IndexAccessor indexAccessor = targetIndex;){
                                targetIndex.force(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
                            }
                        });
                    }
                    catch (IndexEntryConflictException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            progress.mark('-');
        }
    }

    public static long estimateIndexSize(IndexDescriptor indexDescriptor, IndexProviderMap indexProviders, TokenHolders tokenHolders, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour, Config dbConfig, CursorContextFactory contextFactory) throws IOException {
        try (IndexAccessor incrementalIndex = indexProviders.lookup(indexDescriptor.getIndexProvider()).getOnlineAccessor(indexDescriptor, new IndexSamplingConfig(dbConfig), (TokenNameLookup)tokenHolders, ElementIdMapper.PLACEHOLDER, openOptions, indexingBehaviour);){
            long l;
            block12: {
                CursorContext context = contextFactory.create("estimate index size");
                try {
                    l = incrementalIndex.estimateNumberOfEntries(context);
                    if (context == null) break block12;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                context.close();
            }
            return l;
        }
    }

    private static Map<String, SchemaDescriptor> asSchemaDescriptors(Map<String, IndexDescriptor> indexDescriptors) {
        return indexDescriptors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexDescriptor)e.getValue()).schema()));
    }

    public static enum ImportState {
        PREPARE_STARTED("prepare.started"),
        PREPARE_COMPLETED("prepare.completed"),
        BUILD_STARTED("build.started"),
        BUILD_COMPLETED("build.completed"),
        MERGE_STARTED("merge.started"),
        MERGE_COMPLETED("merge.completed");

        public static final ImportState[] VALUES;
        public final String info;

        private ImportState(String info) {
            this.info = info;
        }

        static {
            VALUES = ImportState.values();
        }
    }
}

