/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import blue.strategic.parquet.ParquetReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.cloud.storage.io.ReadableChannel;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.HeaderException;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.parquet.DuplicatedColumnException;
import org.neo4j.internal.batchimport.input.parquet.EntityType;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetGroupInputIterator;
import org.neo4j.internal.batchimport.input.parquet.ParquetLogicalColumnType;
import org.neo4j.internal.batchimport.input.parquet.ParquetMonitor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;

public class ParquetInput
implements Input {
    private static final Supplier<ZoneId> defaultTimezoneSupplier = () -> ZoneOffset.UTC;
    private final List<ParquetData> nodeDatas;
    private final List<ParquetData> relationshipDatas;
    private final List<SchemaCommand> schemaCommands;
    private final IdType idType;
    private final Groups groups;
    private final ParquetMonitor monitor;
    private final Map<Set<String>, List<Path[]>> nodeFiles;
    private final Map<String, List<Path[]>> relationshipFiles;
    private final Map<Path, List<ParquetColumn>> verifiedColumns;
    private final String arrayDelimiter;

    public ParquetInput(Map<Set<String>, List<Path[]>> nodeFiles, Map<String, List<Path[]>> relationshipFiles, IdType idType, Character arrayDelimiter, Groups groups, ParquetMonitor monitor) {
        this(nodeFiles, relationshipFiles, Collections.emptyList(), idType, arrayDelimiter, groups, monitor);
    }

    public ParquetInput(Map<Set<String>, List<Path[]>> nodeFiles, Map<String, List<Path[]>> relationshipFiles, List<SchemaCommand> schemaCommands, IdType idType, Character arrayDelimiter, Groups groups, ParquetMonitor monitor) {
        this.idType = idType;
        this.groups = groups;
        this.monitor = monitor;
        this.arrayDelimiter = arrayDelimiter.toString();
        this.nodeFiles = nodeFiles;
        this.relationshipFiles = relationshipFiles;
        this.schemaCommands = schemaCommands;
        this.verifiedColumns = this.verifyColumns(nodeFiles, relationshipFiles);
        this.nodeDatas = nodeFiles.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(p -> Map.entry((Set)e.getKey(), p))).flatMap(e -> Arrays.stream((Path[])e.getValue()).map(p -> Map.entry((Set)e.getKey(), p))).map(e -> new ParquetData((Set)e.getKey(), (Path)e.getValue(), this.verifiedColumns.get(e.getValue()), defaultTimezoneSupplier)).toList();
        this.relationshipDatas = relationshipFiles.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(p -> Map.entry((String)e.getKey(), p))).flatMap(e -> Arrays.stream((Path[])e.getValue()).map(p -> Map.entry((String)e.getKey(), p))).map(e -> new ParquetData(Set.of((String)e.getKey()), (Path)e.getValue(), this.verifiedColumns.get(e.getValue()), defaultTimezoneSupplier)).toList();
    }

    public InputIterable nodes(Collector badCollector) {
        return () -> new ParquetGroupInputIterator(this.nodeDatas, this.groups, this.idType, this.arrayDelimiter);
    }

    public InputIterable relationships(Collector badCollector) {
        return () -> new ParquetGroupInputIterator(this.relationshipDatas, this.groups, this.idType, this.arrayDelimiter);
    }

    public IdType idType() {
        return this.idType;
    }

    public ReadableGroups groups() {
        return this.groups;
    }

    public List<SchemaCommand> schemaCommands() {
        return this.schemaCommands;
    }

    private Map<Path, List<ParquetColumn>> verifyColumns(Map<Set<String>, List<Path[]>> labelsAndNodeFiles, Map<String, List<Path[]>> typeAndRelationshipFiles) {
        HashMap<Path, List<ParquetColumn>> columnInfo = new HashMap<Path, List<ParquetColumn>>();
        try {
            List columns;
            for (Map.Entry<Set<String>, List<Path[]>> entry : labelsAndNodeFiles.entrySet()) {
                boolean hasLabelColumn = !entry.getKey().isEmpty() && entry.getKey().stream().anyMatch(label -> !label.isBlank());
                List nodeFiles = entry.getValue().stream().flatMap(Arrays::stream).toList();
                for (Path nodeFile : nodeFiles) {
                    ParquetMetadata metadata = null;
                    try {
                        metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(nodeFile));
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Could not read parquet file %s".formatted(nodeFile.toAbsolutePath()), e);
                    }
                    ArrayList<ParquetColumn> currentColumnInfo = new ArrayList<ParquetColumn>();
                    HashSet<String> propertyNames = new HashSet<String>();
                    String previousGroupName = null;
                    columns = metadata.getFileMetaData().getSchema().getColumns();
                    HashSet<String> mapColumns = new HashSet<String>();
                    HashSet<String> structColumns = new HashSet<String>();
                    String fileName = nodeFile.getFileName().toString();
                    for (ColumnDescriptor columnDescriptor : columns) {
                        String[] namePath = columnDescriptor.getPath();
                        String columnName = namePath[0];
                        if (columnName.isBlank()) {
                            throw new InputException("column name must not be blank");
                        }
                        try {
                            String firstPropertyNamePart;
                            String propertyName;
                            ParquetColumn parquetColumn = ParquetColumn.from(columnName, EntityType.NODE);
                            if (parquetColumn.isIgnoredColumn()) continue;
                            String string = propertyName = parquetColumn.propertyName() != null ? parquetColumn.propertyName() : parquetColumn.logicalColumnType().name();
                            if (parquetColumn.isIdColumn() && parquetColumn.groupName() != null) {
                                if (previousGroupName != null && !previousGroupName.equals(parquetColumn.groupName())) {
                                    throw new IllegalStateException("There are multiple :ID columns, but they are referring to different groups");
                                }
                                previousGroupName = parquetColumn.groupName();
                            }
                            if (propertyNames.contains(propertyName) && parquetColumn.isIdColumn()) {
                                throw new DuplicatedColumnException("Cannot store composite IDs as properties, only individual part. Property %s / File: %s".formatted(propertyName, fileName));
                            }
                            String string2 = firstPropertyNamePart = propertyName.contains(".") ? propertyName.split("\\.")[0] : propertyName;
                            if ((propertyNames.contains(propertyName) || propertyNames.contains(firstPropertyNamePart)) && !mapColumns.contains(propertyName) && !structColumns.contains(propertyName)) {
                                throw new DuplicatedColumnException("Duplicated header property %s found in file %s.".formatted(propertyName, fileName));
                            }
                            propertyNames.add(propertyName);
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.ID) {
                                this.groups.getOrCreate(parquetColumn.groupName());
                            }
                            if (parquetColumn.columnType().needsConversion()) {
                                this.monitor.typeNormalized(fileName, propertyName, parquetColumn.columnType().name(), parquetColumn.columnType().convertedType().name());
                            }
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.LABEL) {
                                hasLabelColumn = true;
                            }
                            if (!mapColumns.contains(propertyName)) {
                                currentColumnInfo.add(parquetColumn);
                            }
                            if (namePath.length > 1 && "key_value".equals(namePath[1])) {
                                mapColumns.add(propertyName);
                                continue;
                            }
                            if (namePath.length <= 1) continue;
                            structColumns.add(propertyName);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InputException("Column name " + columnName + " is used as a special type but is unknown. Allowed types are " + ParquetColumn.getReservedColumns(EntityType.NODE));
                        }
                    }
                    if (!hasLabelColumn) {
                        this.monitor.noNodeLabelsSpecified(fileName);
                    }
                    columnInfo.put(nodeFile, currentColumnInfo);
                }
            }
            for (Map.Entry<Object, List<Path[]>> entry : typeAndRelationshipFiles.entrySet()) {
                List relationshipFileList = entry.getValue().stream().flatMap(Arrays::stream).toList();
                HashSet<String> mapColumns = new HashSet<String>();
                HashSet<String> structColumns = new HashSet<String>();
                for (Path relationshipFile : relationshipFileList) {
                    ParquetMetadata metadata = null;
                    try {
                        metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(relationshipFile));
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Could not read parquet file %s".formatted(relationshipFile.toAbsolutePath()), e);
                    }
                    ArrayList<ParquetColumn> currentColumnInfo = new ArrayList<ParquetColumn>();
                    HashSet<String> propertyNames = new HashSet<String>();
                    columns = metadata.getFileMetaData().getSchema().getColumns();
                    boolean hasTypeColumn = entry.getKey() != null && !((String)entry.getKey()).isBlank();
                    String fileName = relationshipFile.getFileName().toString();
                    for (ColumnDescriptor columnDescriptor : columns) {
                        String[] namePath = columnDescriptor.getPath();
                        String columnName = namePath[0];
                        try {
                            String propertyName;
                            ParquetColumn parquetColumn = ParquetColumn.from(columnName, EntityType.RELATIONSHIP);
                            if (parquetColumn.isIgnoredColumn()) continue;
                            String string = propertyName = parquetColumn.propertyName() != null ? parquetColumn.propertyName() : parquetColumn.logicalColumnType().name();
                            if (propertyNames.contains(propertyName) && !mapColumns.contains(propertyName) && !structColumns.contains(propertyName)) {
                                throw new DuplicatedColumnException("Duplicated header property %s found in file %s.".formatted(propertyName, fileName));
                            }
                            propertyNames.add(propertyName);
                            if (parquetColumn.columnType().needsConversion()) {
                                this.monitor.typeNormalized(fileName, propertyName, parquetColumn.columnType().name(), parquetColumn.columnType().convertedType().name());
                            }
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.START_ID || parquetColumn.logicalColumnType() == ParquetLogicalColumnType.END_ID) {
                                try {
                                    this.groups.get(parquetColumn.groupName());
                                }
                                catch (HeaderException e) {
                                    throw new InputException(e.getMessage());
                                }
                            }
                            if (parquetColumn.logicalColumnType() == ParquetLogicalColumnType.TYPE) {
                                hasTypeColumn = true;
                            }
                            if (!mapColumns.contains(propertyName)) {
                                currentColumnInfo.add(parquetColumn);
                            }
                            if (namePath.length > 1 && "key_value".equals(namePath[1])) {
                                mapColumns.add(propertyName);
                            }
                            if (namePath.length <= 1) continue;
                            structColumns.add(propertyName);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InputException("Column name " + columnName + " is used as a special type but is unknown. Allowed types are " + ParquetColumn.getReservedColumns(EntityType.RELATIONSHIP));
                        }
                    }
                    columnInfo.put(relationshipFile, currentColumnInfo);
                    if (hasTypeColumn) continue;
                    this.monitor.noRelationshipTypeSpecified(fileName);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return columnInfo;
    }

    public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        List<ParquetColumn> idColumns = this.verifiedColumns.values().stream().flatMap(Collection::stream).filter(ParquetColumn::isIdColumn).toList();
        HashMap<String, SchemaDescriptor> result = new HashMap<String, SchemaDescriptor>();
        this.checkReferencedNodeSchema(idColumns, tokenHolders, result);
        return result;
    }

    private void checkReferencedNodeSchema(List<ParquetColumn> idColumns, TokenHolders tokenHolders, Map<String, SchemaDescriptor> result) {
        idColumns.forEach(column -> {
            String labelName = column.idLabel();
            Preconditions.checkState((labelName != null ? 1 : 0) != 0, (String)"No label was specified for the node index in '%s'", (Object[])new Object[]{column});
            String keyName = column.propertyName();
            Preconditions.checkState((keyName != null ? 1 : 0) != 0, (String)"No property key was specified for node index in '%s'", (Object[])new Object[]{column});
            int label = tokenHolders.labelTokens().getIdByName(labelName);
            int key = tokenHolders.propertyKeyTokens().getIdByName(keyName);
            Preconditions.checkState((label != -1 ? 1 : 0) != 0, (String)"Label '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{labelName, column});
            Preconditions.checkState((key != -1 ? 1 : 0) != 0, (String)"Property key '%s' for node index specified in '%s' does not exist", (Object[])new Object[]{keyName, column});
            LabelSchemaDescriptor schemaDescriptor = SchemaDescriptors.forLabel((int)label, (int[])new int[]{key});
            SchemaDescriptor prev = (SchemaDescriptor)result.put(column.groupName(), (SchemaDescriptor)schemaDescriptor);
            Preconditions.checkState((prev == null || prev.equals((Object)schemaDescriptor) ? 1 : 0) != 0, (String)("Multiple different indexes for group " + column.groupName()));
        });
    }

    public Input.Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) throws IOException {
        long numberOfNodes = 0L;
        long numberOfNodeProperties = 0L;
        long totalNodePropertiesSize = 0L;
        HashSet<String> mergedLabels = new HashSet<String>();
        for (Map.Entry<Set<String>, List<Path[]>> nodePathEntries : this.nodeFiles.entrySet()) {
            mergedLabels.addAll(Collections.unmodifiableSet(nodePathEntries.getKey()));
            for (Path[] nodePaths : nodePathEntries.getValue()) {
                for (Path nodePath : nodePaths) {
                    ParquetMetadata metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(nodePath));
                    List blocks = metadata.getBlocks();
                    for (BlockMetaData block : blocks) {
                        numberOfNodes += block.getRowCount();
                        int currentColumnCount = block.getColumns().size();
                        if ((long)currentColumnCount > numberOfNodeProperties) {
                            numberOfNodeProperties = currentColumnCount;
                        }
                        for (ColumnChunkMetaData column : block.getColumns()) {
                            totalNodePropertiesSize += column.getTotalUncompressedSize();
                        }
                    }
                }
            }
        }
        int numberOfNodeLabels = mergedLabels.size();
        long numberOfRelationships = 0L;
        long numberOfRelationshipProperties = 0L;
        long totalRelationshipPropertiesSize = 0L;
        for (Map.Entry<String, List<Path[]>> relationshipFileEntries : this.relationshipFiles.entrySet()) {
            for (Path[] relationshipPaths : relationshipFileEntries.getValue()) {
                for (Path relationshipPath : relationshipPaths) {
                    ParquetMetadata metadata = ParquetReader.readMetadata((InputFile)ParquetImportInputFile.of(relationshipPath));
                    for (BlockMetaData block : metadata.getBlocks()) {
                        numberOfNodes += block.getRowCount();
                        int currentColumnCount = block.getColumns().size();
                        if ((long)currentColumnCount > numberOfNodeProperties) {
                            numberOfNodeProperties = currentColumnCount;
                        }
                        for (ColumnChunkMetaData column : block.getColumns()) {
                            totalRelationshipPropertiesSize += column.getTotalUncompressedSize();
                        }
                    }
                }
            }
        }
        return Input.knownEstimates((long)numberOfNodes, (long)numberOfRelationships, (long)numberOfNodeProperties, (long)numberOfRelationshipProperties, (long)totalNodePropertiesSize, (long)totalRelationshipPropertiesSize, (long)numberOfNodeLabels);
    }

    static class ParquetImportInputFile
    implements InputFile {
        static Map<Path, ParquetImportInputFile> importFileCache = new HashMap<Path, ParquetImportInputFile>();
        private final Path lePath;

        static ParquetImportInputFile of(Path importFilePath) {
            return importFileCache.computeIfAbsent(importFilePath, any -> new ParquetImportInputFile(importFilePath));
        }

        private ParquetImportInputFile(Path lePath) {
            this.lePath = lePath;
        }

        public long getLength() throws IOException {
            return Files.size(this.lePath);
        }

        public SeekableInputStream newStream() throws IOException {
            InputStream inputStream = Files.newInputStream(this.lePath, new OpenOption[0]);
            if (inputStream instanceof ReadableChannel) {
                final ReadableChannel cloudFileChannel = (ReadableChannel)inputStream;
                return new DelegatingSeekableInputStream(this, inputStream){
                    private long position;
                    {
                        super(stream);
                        this.position = 0L;
                    }

                    public long getPos() {
                        return this.position;
                    }

                    public void seek(long newPos) throws IOException {
                        cloudFileChannel.position(newPos);
                        this.position = newPos;
                    }
                };
            }
            inputStream = new FileInputStream(this.lePath.toFile());
            final FileInputStream fis = (FileInputStream)inputStream;
            return new DelegatingSeekableInputStream(this, fis){
                private long position;
                {
                    super(stream);
                    this.position = 0L;
                }

                public long getPos() {
                    return this.position;
                }

                public void seek(long newPos) throws IOException {
                    fis.getChannel().position(newPos);
                    this.position = newPos;
                }
            };
        }
    }
}

