/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.DummyRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetInput;

class ParquetDataReader
implements Closeable {
    private final ParquetData parquetDataFile;
    private final Groups groups;
    private final IdType idType;
    private final Supplier<ZoneId> defaultTimezoneSupplier;
    private final String arrayDelimiter;
    private final ParquetFileReader reader;
    private final AtomicInteger blockCounter;
    private final MessageType schema;
    private final GroupConverter recordConverter;
    private final String createdBy;
    private final List<ColumnDescriptor> parquetColumns;

    ParquetDataReader(ParquetData parquetDataFile, Groups groups, IdType idType, Supplier<ZoneId> defaultTimezoneSupplier, String arrayDelimiter) {
        this.parquetDataFile = parquetDataFile;
        this.groups = groups;
        this.idType = idType;
        this.defaultTimezoneSupplier = defaultTimezoneSupplier;
        this.arrayDelimiter = arrayDelimiter;
        Path path = parquetDataFile.file();
        try {
            this.reader = ParquetFileReader.open((InputFile)ParquetInput.ParquetImportInputFile.of(path), (ParquetReadOptions)ParquetReadOptions.builder().build());
            FileMetaData metadata = this.reader.getFileMetaData();
            this.schema = metadata.getSchema();
            this.recordConverter = new DummyRecordConverter(this.schema).getRootConverter();
            this.createdBy = metadata.getCreatedBy();
            List<String> columnsToRead = parquetDataFile.columns().stream().map(ParquetColumn::columnName).toList();
            this.parquetColumns = this.schema.getColumns().stream().filter(c -> columnsToRead.contains(c.getPath()[0])).toList();
            this.blockCounter = new AtomicInteger(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<List<Object>> next() throws IOException {
        int nextRowGroupIndex = this.blockCounter.getAndIncrement();
        if (nextRowGroupIndex >= this.reader.getRowGroups().size()) {
            return null;
        }
        return new ParquetRowGroupReader(this.reader.readRowGroup(nextRowGroupIndex));
    }

    public ParquetData getParquetDataFile() {
        return this.parquetDataFile;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public Supplier<ZoneId> getDefaultTimezoneSupplier() {
        return this.defaultTimezoneSupplier;
    }

    public String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class ParquetRowGroupReader
    implements Iterator<List<Object>> {
        private final List<ColumnReader> columnReaders;
        private final long rowCount;
        private long rowIndex;

        ParquetRowGroupReader(PageReadStore store) {
            this.rowCount = store.getRowCount();
            ColumnReadStoreImpl columnReadStore = new ColumnReadStoreImpl(store, ParquetDataReader.this.recordConverter, ParquetDataReader.this.schema, ParquetDataReader.this.createdBy);
            this.columnReaders = ParquetDataReader.this.parquetColumns.stream().map(arg_0 -> ((ColumnReadStoreImpl)columnReadStore).getColumnReader(arg_0)).toList();
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < this.rowCount;
        }

        @Override
        public List<Object> next() {
            ArrayList<Object> result = new ArrayList<Object>();
            HashSet<String> processedEmptyMaps = new HashSet<String>();
            MapLikeRecord mapLikeRecord = null;
            for (ColumnReader columnReader : this.columnReaders) {
                Object readValue = this.readValue(columnReader);
                if (readValue instanceof Map) {
                    Map emptyRecord = (Map)readValue;
                    if (processedEmptyMaps.contains(columnReader.getDescriptor().getPath()[0])) continue;
                    result.add(emptyRecord);
                    processedEmptyMaps.add(columnReader.getDescriptor().getPath()[0]);
                    continue;
                }
                if (readValue instanceof MapLikeRecord.Keys) {
                    MapLikeRecord.Keys keys = (MapLikeRecord.Keys)readValue;
                    if (mapLikeRecord == null) {
                        mapLikeRecord = new MapLikeRecord(columnReader.getDescriptor().getPath()[0]);
                    } else if (!mapLikeRecord.fieldName.equals(keys.fieldName)) {
                        result.add(mapLikeRecord.asMap());
                        mapLikeRecord = new MapLikeRecord(keys.fieldName);
                    }
                    mapLikeRecord.keys = keys;
                    continue;
                }
                if (readValue instanceof MapLikeRecord.Values) {
                    MapLikeRecord.Values values = (MapLikeRecord.Values)readValue;
                    if (mapLikeRecord == null) {
                        mapLikeRecord = new MapLikeRecord(columnReader.getDescriptor().getPath()[0]);
                    } else if (!mapLikeRecord.fieldName.equals(values.fieldName)) {
                        result.add(mapLikeRecord.asMap());
                        mapLikeRecord = new MapLikeRecord(values.fieldName);
                    }
                    mapLikeRecord.values = values;
                    continue;
                }
                if (readValue instanceof MapLikeRecord) {
                    MapLikeRecord struct = (MapLikeRecord)readValue;
                    if (mapLikeRecord != null && mapLikeRecord.keys != null) {
                        result.add(mapLikeRecord.asMap());
                        mapLikeRecord = null;
                    }
                    result.add(struct.asMap());
                    continue;
                }
                if (mapLikeRecord != null && mapLikeRecord.keys != null) {
                    result.add(mapLikeRecord.asMap());
                    mapLikeRecord = null;
                }
                result.add(readValue);
            }
            if (mapLikeRecord != null && mapLikeRecord.keys != null) {
                result.add(mapLikeRecord.asMap());
            }
            ++this.rowIndex;
            return result;
        }

        private Object readValue(ColumnReader columnReader) {
            ColumnDescriptor column = columnReader.getDescriptor();
            PrimitiveType primitiveType = column.getPrimitiveType();
            int maxDefinitionLevel = column.getMaxDefinitionLevel();
            String fieldName = column.getPath()[0];
            Type type = ParquetDataReader.this.schema.getType(fieldName);
            LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
            if (columnReader.getCurrentDefinitionLevel() == maxDefinitionLevel) {
                if (logicalType != null && logicalType.equals(LogicalTypeAnnotation.listType())) {
                    ArrayList<Object> readValues = new ArrayList<Object>();
                    int i = 0;
                    while ((long)i < columnReader.getTotalValueCount()) {
                        readValues.add(ParquetRowGroupReader.readPrimitiveType(columnReader, primitiveType));
                        columnReader.consume();
                        ++i;
                    }
                    return readValues;
                }
                if (logicalType != null && logicalType.equals(LogicalTypeAnnotation.mapType())) {
                    if (column.getPath()[2].equals("key")) {
                        MapLikeRecord.Keys mapKeys = new MapLikeRecord.Keys(fieldName, new ArrayList<String>());
                        int i = 0;
                        while ((long)i < columnReader.getTotalValueCount()) {
                            String key = (String)ParquetRowGroupReader.readPrimitiveType(columnReader, primitiveType);
                            mapKeys.keys().add(fieldName + "." + key);
                            columnReader.consume();
                            ++i;
                        }
                        return mapKeys;
                    }
                    MapLikeRecord.Values mapValues = new MapLikeRecord.Values(fieldName, new ArrayList<Object>());
                    int i = 0;
                    while ((long)i < columnReader.getTotalValueCount()) {
                        Object value = ParquetRowGroupReader.readPrimitiveType(columnReader, primitiveType);
                        mapValues.values().add(value);
                        columnReader.consume();
                        ++i;
                    }
                    return mapValues;
                }
                if (type instanceof GroupType) {
                    MapLikeRecord.Keys mapKeys = new MapLikeRecord.Keys(fieldName, new ArrayList<String>());
                    String propertyName = fieldName + "." + column.getPath()[1];
                    mapKeys.keys().add(propertyName);
                    MapLikeRecord.Values mapValues = new MapLikeRecord.Values(fieldName, new ArrayList<Object>());
                    mapValues.values().add(ParquetRowGroupReader.readPrimitiveType(columnReader, primitiveType));
                    return new MapLikeRecord(fieldName, mapKeys, mapValues);
                }
                Object readValue = ParquetRowGroupReader.readPrimitiveType(columnReader, primitiveType);
                columnReader.consume();
                return readValue;
            }
            columnReader.consume();
            if (logicalType != null) {
                if (logicalType.equals(LogicalTypeAnnotation.listType())) {
                    return List.of();
                }
                if (logicalType.equals(LogicalTypeAnnotation.mapType())) {
                    return Map.of();
                }
            }
            return null;
        }

        private static Object readPrimitiveType(ColumnReader columnReader, PrimitiveType primitiveType) {
            return switch (primitiveType.getPrimitiveTypeName()) {
                default -> throw new MatchException(null, null);
                case PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, PrimitiveType.PrimitiveTypeName.INT96 -> primitiveType.stringifier().stringify(columnReader.getBinary());
                case PrimitiveType.PrimitiveTypeName.BOOLEAN -> columnReader.getBoolean();
                case PrimitiveType.PrimitiveTypeName.DOUBLE -> columnReader.getDouble();
                case PrimitiveType.PrimitiveTypeName.FLOAT -> Float.valueOf(columnReader.getFloat());
                case PrimitiveType.PrimitiveTypeName.INT32 -> columnReader.getInteger();
                case PrimitiveType.PrimitiveTypeName.INT64 -> columnReader.getLong();
            };
        }

        private static class MapLikeRecord {
            private final String fieldName;
            private Keys keys;
            private Values values;

            private MapLikeRecord(String fieldName) {
                this.fieldName = fieldName;
            }

            private MapLikeRecord(String fieldName, Keys keys, Values values) {
                this.fieldName = fieldName;
                this.keys = keys;
                this.values = values;
            }

            private Map<String, Object> asMap() {
                HashMap<String, Object> renderedMap = new HashMap<String, Object>();
                for (int i = 0; i < this.keys.keys().size(); ++i) {
                    renderedMap.put(this.keys.keys.get(i), this.values.values().get(i));
                }
                return renderedMap;
            }

            private record Keys(String fieldName, List<String> keys) {
            }

            private record Values(String fieldName, List<Object> values) {
            }
        }
    }
}

