/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping;

import java.util.function.LongPredicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.CuckooIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.StringCuckooIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.internal.batchimport.cache.idmapping.string.Radix;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.TrackerFactories;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.FeatureToggles;

public final class IdMappers {
    public static final boolean USE_CUCKOO_MAPPER = FeatureToggles.flag(IdMappers.class, (String)"use_cuckoo", (boolean)false);

    private IdMappers() {
    }

    public static IdMapper actual() {
        return new ActualIdMapper();
    }

    public static IdMapper strings(NumberArrayFactory cacheFactory, ReadableGroups groups, boolean strictNodeCheck, MemoryTracker memoryTracker, long estimatedNumberOfNodes, PropertyValueLookup inputIdLookup) {
        if (USE_CUCKOO_MAPPER) {
            return new StringCuckooIdMapper(estimatedNumberOfNodes, cacheFactory, groups, memoryTracker, inputIdLookup);
        }
        return new EncodingIdMapper(cacheFactory, new StringEncoder(), strictNodeCheck, Radix.STRING, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(memoryTracker), groups, numberOfCollisions -> new StringCollisionValues(cacheFactory, numberOfCollisions, memoryTracker), IdMappers.goodChunkSize(estimatedNumberOfNodes), EncodingIdMapper.defaultNumberOfSortWorkers(), ParallelSort.DEFAULT, memoryTracker);
    }

    public static IdMapper longs(NumberArrayFactory cacheFactory, ReadableGroups groups, MemoryTracker memoryTracker, long estimatedNumberOfNodes) {
        if (USE_CUCKOO_MAPPER) {
            return new CuckooIdMapper(estimatedNumberOfNodes, cacheFactory, groups, memoryTracker);
        }
        return new EncodingIdMapper(cacheFactory, new LongEncoder(), false, Radix.LONG, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(memoryTracker), groups, numberOfCollisions -> new LongCollisionValues(cacheFactory, numberOfCollisions, memoryTracker), IdMappers.goodChunkSize(estimatedNumberOfNodes), EncodingIdMapper.defaultNumberOfSortWorkers(), ParallelSort.DEFAULT, memoryTracker);
    }

    private static int goodChunkSize(long estimatedNumberOfNodes) {
        return (int)Math.clamp(estimatedNumberOfNodes / 100L, 1000000L, ByteUnit.gibiBytes((long)1L) / 8L);
    }

    public static LongPredicate combineSkipFilter(LongPredicate duplicateIds, LongSet otherViolatingIds) {
        boolean emptyOtherViolatingIds;
        boolean emptyDuplicateIds = duplicateIds == null;
        boolean bl = emptyOtherViolatingIds = otherViolatingIds == null || otherViolatingIds.isEmpty();
        if (emptyDuplicateIds && emptyOtherViolatingIds) {
            return null;
        }
        return emptyDuplicateIds ? arg_0 -> ((LongSet)otherViolatingIds).contains(arg_0) : nodeId -> otherViolatingIds.contains(nodeId) || duplicateIds.test(nodeId);
    }

    public static LongIterator combineSkipListSorted(LongIterator duplicateIds, LongSet otherViolatingIds) {
        if (otherViolatingIds == null || otherViolatingIds.isEmpty()) {
            return duplicateIds;
        }
        MutableLongIterator sortedViolations = otherViolatingIds.toSortedList().longIterator();
        if (!duplicateIds.hasNext()) {
            return sortedViolations;
        }
        return new MergingLongIterator(duplicateIds, (LongIterator)sortedViolations);
    }

    private static class ActualIdMapper
    implements IdMapper,
    IdMapper.Getter {
        private ActualIdMapper() {
        }

        @Override
        public IdMapper.Setter newSetter() {
            return (inputId, actualId, group) -> {};
        }

        @Override
        public void remove(Object inputId, long actualId, Group group) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean needsPreparation() {
            return false;
        }

        @Override
        public void prepare(PropertyValueLookup inputIdLookup, Collector collector, ProgressMonitorFactory progressMonitorFactory, LongSet otherViolatingNodes) {
        }

        @Override
        public long get(Object inputId, Group group) {
            return (Long)inputId;
        }

        @Override
        public IdMapper.Getter newGetter() {
            return this;
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public void close() {
        }

        @Override
        public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
            return MemoryStatsVisitor.NONE;
        }

        @Override
        public LongIterator leftOverDuplicateNodesIds() {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        @Override
        public LongPredicate leftOverDuplicateNodesIdsPredicate() {
            return id -> false;
        }
    }

    private static class MergingLongIterator
    extends PrimitiveLongCollections.AbstractPrimitiveLongBaseIterator {
        private final LongIterator first;
        private final LongIterator other;
        private boolean hasFirst;
        private boolean hasOther;
        private long firstHead;
        private long otherHead;

        private MergingLongIterator(LongIterator first, LongIterator other) {
            this.first = first;
            this.other = other;
            this.getAndAdvanceFirst();
            this.getAndAdvanceOther();
        }

        private long getAndAdvanceFirst() {
            long result = this.firstHead;
            this.hasFirst = this.first.hasNext();
            this.firstHead = this.hasFirst ? this.first.next() : 0L;
            return result;
        }

        private long getAndAdvanceOther() {
            long result = this.otherHead;
            this.hasOther = this.other.hasNext();
            this.otherHead = this.hasOther ? this.other.next() : 0L;
            return result;
        }

        protected boolean fetchNext() {
            if (this.hasFirst && this.hasOther) {
                if (this.firstHead < this.otherHead) {
                    return this.next(this.getAndAdvanceFirst());
                }
                if (this.otherHead < this.firstHead) {
                    return this.next(this.getAndAdvanceOther());
                }
                this.getAndAdvanceFirst();
                return this.next(this.getAndAdvanceOther());
            }
            if (this.hasFirst) {
                return this.next(this.getAndAdvanceFirst());
            }
            if (this.hasOther) {
                return this.next(this.getAndAdvanceOther());
            }
            return false;
        }
    }
}

