/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import org.neo4j.internal.batchimport.cache.BufferFactory;
import org.neo4j.internal.batchimport.cache.SwappingBufferFactory;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class BufferFactories {
    public static final BufferFactory HEAP = new BufferFactory(){

        @Override
        public BufferFactory.AllocatedBuffer allocate(int size, MemoryTracker memoryTracker) {
            memoryTracker.allocateHeap(HeapEstimator.sizeOfByteArray((int)size));
            return new BufferFactory.AllocatedBuffer(ByteBuffer.wrap(new byte[size]), null);
        }

        @Override
        public void clear(ByteBuffer buffer, byte defaultValue) {
            Arrays.fill(buffer.array(), defaultValue);
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "HeapBufferFactory";
        }
    };
    public static final BufferFactory OFF_HEAP = new BufferFactory(){

        @Override
        public BufferFactory.AllocatedBuffer allocate(int size, MemoryTracker memoryTracker) {
            NativeScopedBuffer nativeScopedBuffer = new NativeScopedBuffer(size, ByteOrder.LITTLE_ENDIAN, memoryTracker);
            return new BufferFactory.AllocatedBuffer(nativeScopedBuffer.getBuffer(), (AutoCloseable)nativeScopedBuffer);
        }

        @Override
        public void clear(ByteBuffer buffer, byte defaultValue) {
            UnsafeUtil.setMemory((long)UnsafeUtil.getDirectByteBufferAddress((Buffer)buffer), (long)buffer.capacity(), (byte)defaultValue);
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "OffHeapBufferFactory";
        }
    };

    public static BufferFactory fileBacked(FileSystemAbstraction fs, Path workingDirectory) {
        try {
            return new SwappingBufferFactory(fs, workingDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private BufferFactories() {
    }
}

