/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.cuckoo;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.CuckooTable;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.memory.MemoryTracker;

public class CuckooIdMapper
implements IdMapper {
    final CuckooTable cuckooTable;
    final int groupShift;
    final long longValueMask;

    public CuckooIdMapper(long estimatedNumberOfNodes, NumberArrayFactory arrayFactory, ReadableGroups groups, MemoryTracker memoryTracker) {
        this.cuckooTable = new CuckooTable(estimatedNumberOfNodes, arrayFactory, memoryTracker);
        this.groupShift = CuckooIdMapper.calculateGroupShift(groups.size() - 1);
        this.longValueMask = this.groupShift == 0 ? 0L : -(1L << 64 - this.groupShift);
    }

    @Override
    public IdMapper.Setter newSetter() {
        return (inputId, actualId, group) -> this.cuckooTable.insert(this.getKey(inputId, group), actualId);
    }

    @Override
    public IdMapper.Getter newGetter() {
        return new IdMapper.Getter(){

            @Override
            public long get(Object inputId, Group group) {
                return CuckooIdMapper.this.cuckooTable.get(CuckooIdMapper.this.getKey(inputId, group));
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void remove(Object inputId, long actualId, Group group) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsPreparation() {
        return false;
    }

    @Override
    public void prepare(PropertyValueLookup propertyValueLookup, Collector collector, ProgressMonitorFactory progressMonitorFactory) {
    }

    @Override
    public void close() {
        this.cuckooTable.close();
    }

    @Override
    public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
        long sizePerKeyPair = 16L;
        return visitor -> visitor.offHeapUsage((long)((double)(numberOfNodes * sizePerKeyPair) / 0.95));
    }

    public static long estimateMemory(long numberOfNodes) {
        long sizePerKeyPair = 16L;
        return (long)((double)(numberOfNodes * sizePerKeyPair) / 0.95);
    }

    @Override
    public LongIterator leftOverDuplicateNodesIds() {
        return ImmutableEmptyLongIterator.INSTANCE;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
    }

    private long getKey(Object inputId, Group group) {
        long idHash = CuckooIdMapper.inputIdToLongHash(inputId, this.longValueMask);
        return idHash << this.groupShift | (long)group.id();
    }

    private static long inputIdToLongHash(Object inputId, long longValueMask) {
        if (inputId instanceof Number) {
            Number n = (Number)inputId;
            long l = n.longValue();
            if ((l & longValueMask) != 0L) {
                throw new IllegalArgumentException("Id " + l + " overflowed");
            }
            return l;
        }
        throw new IllegalArgumentException("Id " + String.valueOf(inputId) + " not a number");
    }

    private static int calculateGroupShift(int numberOfGroups) {
        if (numberOfGroups <= 0) {
            return 0;
        }
        return 32 - Integer.numberOfLeadingZeros(numberOfGroups);
    }
}

