/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.CuckooIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.cuckoo.StringCuckooIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.internal.batchimport.cache.idmapping.string.Radix;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.TrackerFactories;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.FeatureToggles;

public final class IdMappers {
    public static final boolean USE_CUCKOO_MAPPER = FeatureToggles.flag(IdMappers.class, (String)"use_cuckoo", (boolean)false);

    private IdMappers() {
    }

    public static IdMapper actual() {
        return new ActualIdMapper();
    }

    public static IdMapper strings(NumberArrayFactory cacheFactory, ReadableGroups groups, boolean strictNodeCheck, MemoryTracker memoryTracker, long estimatedNumberOfNodes, PropertyValueLookup inputIdLookup) {
        if (USE_CUCKOO_MAPPER) {
            return new StringCuckooIdMapper(estimatedNumberOfNodes, cacheFactory, groups, memoryTracker, inputIdLookup);
        }
        return new EncodingIdMapper(cacheFactory, new StringEncoder(), strictNodeCheck, Radix.STRING, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(memoryTracker), groups, numberOfCollisions -> new StringCollisionValues(cacheFactory, numberOfCollisions, memoryTracker), IdMappers.goodChunkSize(estimatedNumberOfNodes), EncodingIdMapper.defaultNumberOfSortWorkers(), ParallelSort.DEFAULT, memoryTracker);
    }

    public static IdMapper longs(NumberArrayFactory cacheFactory, ReadableGroups groups, MemoryTracker memoryTracker, long estimatedNumberOfNodes) {
        if (USE_CUCKOO_MAPPER) {
            return new CuckooIdMapper(estimatedNumberOfNodes, cacheFactory, groups, memoryTracker);
        }
        return new EncodingIdMapper(cacheFactory, new LongEncoder(), false, Radix.LONG, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(memoryTracker), groups, numberOfCollisions -> new LongCollisionValues(cacheFactory, numberOfCollisions, memoryTracker), IdMappers.goodChunkSize(estimatedNumberOfNodes), EncodingIdMapper.defaultNumberOfSortWorkers(), ParallelSort.DEFAULT, memoryTracker);
    }

    private static int goodChunkSize(long estimatedNumberOfNodes) {
        return (int)Math.clamp(estimatedNumberOfNodes / 100L, 1000000L, ByteUnit.gibiBytes((long)1L) / 8L);
    }

    private static class ActualIdMapper
    implements IdMapper,
    IdMapper.Getter {
        private ActualIdMapper() {
        }

        @Override
        public IdMapper.Setter newSetter() {
            return (inputId, actualId, group) -> {};
        }

        @Override
        public void remove(Object inputId, long actualId, Group group) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean needsPreparation() {
            return false;
        }

        @Override
        public void prepare(PropertyValueLookup inputIdLookup, Collector collector, ProgressMonitorFactory progressMonitorFactory) {
        }

        @Override
        public long get(Object inputId, Group group) {
            return (Long)inputId;
        }

        @Override
        public IdMapper.Getter newGetter() {
            return this;
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public void close() {
        }

        @Override
        public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
            return MemoryStatsVisitor.NONE;
        }

        @Override
        public LongIterator leftOverDuplicateNodesIds() {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
    }
}

