/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.batchimport.ImportIndexBuilder;
import org.neo4j.internal.batchimport.ImportPropertyConstraintEnforcer;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.batchimport.SchemaMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class OtherAffectedSchemaMonitors
implements Supplier<SchemaMonitor>,
Closeable {
    private final SchemaCache schemaCache;
    private final EntityType entityType;
    private final LongToLongFunction indexedEntityIdConverter;
    private final boolean generateNonUniqueIndexUpdates;
    private final ImportPropertyConstraintEnforcer propertyConstraints;
    private final ImportIndexBuilder indexBuilder;

    public OtherAffectedSchemaMonitors(FileSystemAbstraction fileSystem, IndexProviderMap indexProviderMap, IndexProviderMap tempIndexes, SchemaCache schemaCache, TokenNameLookup tokenNameLookup, EntityType entityType, ImmutableSet<OpenOption> openOptions, PopulationWorkJobScheduler workScheduler, LongToLongFunction indexedEntityIdConverter, LongToLongFunction entityIdFromIndexIdConverter, Configuration configuration, IndexStatisticsStore indexStatisticsStore, StorageEngineIndexingBehaviour indexingBehaviour, boolean incrementalIndexing, boolean generateNonUniqueIndexUpdates, Set<IndexDescriptor> excludedIndexes) {
        this.schemaCache = schemaCache;
        this.entityType = entityType;
        this.indexedEntityIdConverter = indexedEntityIdConverter;
        this.generateNonUniqueIndexUpdates = generateNonUniqueIndexUpdates;
        this.propertyConstraints = new ImportPropertyConstraintEnforcer(schemaCache, entityType);
        this.indexBuilder = new ImportIndexBuilder(fileSystem, indexProviderMap, tempIndexes, tokenNameLookup, openOptions, workScheduler, (LongToLongFunction & Serializable)id -> id, entityIdFromIndexIdConverter, configuration, indexStatisticsStore, indexingBehaviour, incrementalIndexing, excludedIndexes);
    }

    @Override
    public SchemaMonitor get() {
        return new OtherAffectedSchemaMonitor();
    }

    public void completeBuild(Collector collector, Consumer<Runnable> scheduler) {
        this.indexBuilder.completeBuild(collector, scheduler);
    }

    public LongSet validate(LongSet skippedEntityIds, Collector collector) {
        return this.indexBuilder.validate(skippedEntityIds, collector);
    }

    @Override
    public void close() throws IOException {
        this.indexBuilder.close();
    }

    public LongSet affectedIndexes() {
        return this.indexBuilder.affectedIndexes();
    }

    private class OtherAffectedSchemaMonitor
    implements SchemaMonitor {
        private final MutableIntList entityTokens = IntLists.mutable.empty();
        private final MutableIntList existingEntityTokens = IntLists.mutable.empty();
        private final MutableIntSet removedEntityTokens = IntSets.mutable.empty();
        private final MutableIntObjectMap<Value> properties = IntObjectMaps.mutable.empty();
        private final MutableIntSet removedProperties = IntSets.mutable.empty();
        private final MutableIntSet identifierPropertyKeys = IntSets.mutable.empty();
        private ApplicationMode mode;

        private OtherAffectedSchemaMonitor() {
        }

        @Override
        public void applicationMode(ApplicationMode mode) {
            this.mode = mode;
        }

        @Override
        public void property(int propertyKeyId, Object value, boolean identifier) {
            Value v;
            Value propertyValue = value instanceof Value ? (v = (Value)value) : Values.of((Object)value);
            this.properties.put(propertyKeyId, (Object)propertyValue);
            if (identifier) {
                this.identifierPropertyKeys.add(propertyKeyId);
            }
        }

        @Override
        public void removedProperty(int propertyKeyId) {
            this.removedProperties.add(propertyKeyId);
        }

        @Override
        public void existingEntityTokens(int[] entityTokens) {
            this.existingEntityTokens.addAll(entityTokens);
        }

        @Override
        public void entityToken(int entityTokenId) {
            this.entityTokens.add(entityTokenId);
        }

        @Override
        public void entityTokens(int[] entityTokenIds) {
            this.entityTokens.addAll(entityTokenIds);
        }

        @Override
        public void removedEntityTokens(int[] entityTokens) {
            this.removedEntityTokens.addAll(entityTokens);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean endOfEntity(long entityId, SchemaMonitor.ExistingPropertyKeysLookup existingPropertyKeysLookup, SchemaMonitor.ViolationVisitor violationVisitor) {
            try {
                this.entityTokens.sortThis();
                if (this.mode == null || this.mode == ApplicationMode.CREATE) {
                    boolean propertyExistenceOk = this.checkPropertyExistenceConstraintsOnCreate(entityId, violationVisitor);
                    boolean propertyTypesOk = this.checkPropertyTypeConstraints(entityId, violationVisitor);
                    if (propertyExistenceOk && propertyTypesOk && OtherAffectedSchemaMonitors.this.generateNonUniqueIndexUpdates) {
                        this.generateIndexUpdatesForCreatedEntity(entityId);
                    }
                    boolean bl = propertyExistenceOk && propertyTypesOk;
                    return bl;
                }
                if (this.mode == ApplicationMode.UPDATE) {
                    boolean propertyExistenceOk = this.checkPropertyExistenceConstraintsOnUpdate(entityId, existingPropertyKeysLookup, violationVisitor);
                    boolean propertyTypesOk = this.checkPropertyTypeConstraints(entityId, violationVisitor);
                    if (propertyExistenceOk && propertyTypesOk) {
                        boolean bl = this.generateAndValidateUniquenessIndexUpdates(entityId, violationVisitor);
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.reset();
            }
        }

        private boolean checkPropertyExistenceConstraintsOnUpdate(long entityId, SchemaMonitor.ExistingPropertyKeysLookup existingPropertyKeysLookup, SchemaMonitor.ViolationVisitor violationVisitor) {
            IntSet affectedLabels;
            IntSet mandatoryPropertyKeys;
            if (!this.entityTokens.isEmpty() && !(mandatoryPropertyKeys = OtherAffectedSchemaMonitors.this.propertyConstraints.mandatoryPropertyKeys(this.entityTokens.toArray())).isEmpty()) {
                MutableIntSet mandatoryPropertyKeysLeftToCheck = IntSets.mutable.ofAll((IntIterable)mandatoryPropertyKeys);
                this.properties.keySet().forEach(arg_0 -> ((MutableIntSet)mandatoryPropertyKeysLeftToCheck).remove(arg_0));
                if (!mandatoryPropertyKeysLeftToCheck.isEmpty()) {
                    IntSet existingRemainingKeys = existingPropertyKeysLookup.lookup(entityId, (IntSet)mandatoryPropertyKeysLeftToCheck);
                    existingRemainingKeys.forEach((IntProcedure & Serializable)key -> {
                        if (!this.removedProperties.contains(key)) {
                            mandatoryPropertyKeysLeftToCheck.remove(key);
                        }
                    });
                }
                if (!mandatoryPropertyKeysLeftToCheck.isEmpty()) {
                    violationVisitor.accept(entityId, (IntList)this.entityTokens, (IntObjectMap<Value>)this.properties, "a property existence constraint");
                    return false;
                }
            }
            if (!this.removedProperties.isEmpty() && !(affectedLabels = OtherAffectedSchemaMonitors.this.propertyConstraints.entityTokensRelatedToPropertyKeys(this.removedProperties.toArray())).isEmpty()) {
                MutableIntSet affectedLabelsLeftToCheck = IntSets.mutable.ofAll((IntIterable)affectedLabels);
                affectedLabelsLeftToCheck.removeAll((IntIterable)this.removedEntityTokens);
                if (affectedLabelsLeftToCheck.containsAny((IntIterable)this.existingEntityTokens) || affectedLabelsLeftToCheck.containsAny((IntIterable)this.entityTokens)) {
                    violationVisitor.accept(entityId, (IntList)this.entityTokens, (IntObjectMap<Value>)this.properties, "a property existence constraint");
                    return false;
                }
            }
            return true;
        }

        @Override
        public void indexUpdate(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
            if (((IndexDescriptor)indexUpdate.indexKey()).isUnique() && indexUpdate.updateMode() == UpdateMode.CHANGED) {
                indexUpdate = this.asRemoval(indexUpdate);
            }
            OtherAffectedSchemaMonitors.this.indexBuilder.add(indexUpdate);
        }

        @Override
        public void reset() {
            this.entityTokens.clear();
            this.properties.clear();
            this.removedProperties.clear();
            this.existingEntityTokens.clear();
            this.removedEntityTokens.clear();
            this.mode = null;
            this.identifierPropertyKeys.clear();
        }

        private void generateIndexUpdatesForCreatedEntity(long entityId) {
            int[] propertyKeyTokens = this.properties.keySet().toSortedArray();
            Set indexes = OtherAffectedSchemaMonitors.this.schemaCache.getValueIndexesRelatedTo(this.entityTokens.toArray(), ArrayUtils.EMPTY_INT_ARRAY, propertyKeyTokens, true, OtherAffectedSchemaMonitors.this.entityType);
            for (IndexDescriptor index : indexes) {
                OtherAffectedSchemaMonitors.this.indexBuilder.add(this.constructIndexUpdate(entityId, index));
            }
        }

        private boolean generateAndValidateUniquenessIndexUpdates(long entityId, SchemaMonitor.ViolationVisitor violationVisitor) {
            int[] propertyKeyTokens = this.identifierPropertyKeys.isEmpty() ? this.properties.keySet().toSortedArray() : this.properties.keySet().reject(arg_0 -> ((MutableIntSet)this.identifierPropertyKeys).contains(arg_0)).toSortedArray();
            MutableIntSet allEntityTokens = IntSets.mutable.ofAll((IntIterable)this.existingEntityTokens);
            allEntityTokens.addAll((IntIterable)this.entityTokens);
            Set indexes = OtherAffectedSchemaMonitors.this.schemaCache.getValueIndexesRelatedTo(allEntityTokens.toSortedArray(), ArrayUtils.EMPTY_INT_ARRAY, propertyKeyTokens, true, OtherAffectedSchemaMonitors.this.entityType);
            if (!indexes.isEmpty()) {
                ArrayList<IndexEntryUpdate<IndexDescriptor>> appliedAdditions = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
                boolean failed = false;
                for (IndexDescriptor indexDescriptor : indexes) {
                    if (!indexDescriptor.isUnique()) continue;
                    IndexEntryUpdate<IndexDescriptor> indexUpdate = this.constructIndexUpdate(entityId, indexDescriptor);
                    if (OtherAffectedSchemaMonitors.this.indexBuilder.addDirect(indexUpdate)) {
                        appliedAdditions.add(indexUpdate);
                        continue;
                    }
                    failed = true;
                    violationVisitor.accept(entityId, (IntList)this.entityTokens, (IntObjectMap<Value>)this.properties, indexDescriptor.toString());
                    break;
                }
                if (failed) {
                    for (IndexEntryUpdate indexEntryUpdate : appliedAdditions) {
                        boolean removed = OtherAffectedSchemaMonitors.this.indexBuilder.addDirect((IndexEntryUpdate<IndexDescriptor>)this.asRemoval((IndexEntryUpdate<IndexDescriptor>)indexEntryUpdate));
                        assert (removed);
                    }
                    return false;
                }
            }
            return true;
        }

        private ValueIndexEntryUpdate<IndexDescriptor> asRemoval(IndexEntryUpdate<IndexDescriptor> update) {
            ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)update;
            return ValueIndexEntryUpdate.remove((long)update.getEntityId(), (SchemaDescriptorSupplier)((IndexDescriptor)update.indexKey()), (Value[])valueUpdate.beforeValues());
        }

        private IndexEntryUpdate<IndexDescriptor> constructIndexUpdate(long entityId, IndexDescriptor index) {
            int[] propertyIds = index.schema().getPropertyIds();
            Value[] values = new Value[propertyIds.length];
            for (int i = 0; i < propertyIds.length; ++i) {
                values[i] = (Value)this.properties.get(propertyIds[i]);
            }
            return IndexEntryUpdate.add((long)OtherAffectedSchemaMonitors.this.indexedEntityIdConverter.applyAsLong(entityId), (SchemaDescriptorSupplier)index, (Value[])values);
        }

        private boolean checkPropertyExistenceConstraintsOnCreate(long entityId, SchemaMonitor.ViolationVisitor violationVisitor) {
            if (OtherAffectedSchemaMonitors.this.propertyConstraints.hasPropertyExistenceConstraints()) {
                MutableIntIterator entityTokensIterator = this.entityTokens.intIterator();
                while (entityTokensIterator.hasNext()) {
                    IntSet mandatoryPropertyKeys = OtherAffectedSchemaMonitors.this.propertyConstraints.mandatoryPropertyKeys(entityTokensIterator.next());
                    if (mandatoryPropertyKeys == null || this.properties.keySet().containsAll((IntIterable)mandatoryPropertyKeys)) continue;
                    violationVisitor.accept(entityId, (IntList)this.entityTokens, (IntObjectMap<Value>)this.properties, "a property existence constraint");
                    return false;
                }
            }
            return true;
        }

        private boolean checkPropertyTypeConstraints(long entityId, SchemaMonitor.ViolationVisitor violationVisitor) {
            if (OtherAffectedSchemaMonitors.this.propertyConstraints.hasPropertyTypeConstraints()) {
                return this.checkPropertyTypeConstraints(entityId, violationVisitor, (IntList)this.entityTokens) && this.checkPropertyTypeConstraints(entityId, violationVisitor, (IntList)this.existingEntityTokens);
            }
            return true;
        }

        private boolean checkPropertyTypeConstraints(long entityId, SchemaMonitor.ViolationVisitor violationVisitor, IntList tokens) {
            IntIterator tokenIterator = tokens.intIterator();
            while (tokenIterator.hasNext()) {
                int token = tokenIterator.next();
                for (ImportPropertyConstraintEnforcer.PropertyAndType typeConstraint : OtherAffectedSchemaMonitors.this.propertyConstraints.propertyTypeConstraints(token)) {
                    Value value = (Value)this.properties.get(typeConstraint.propertyKeyId());
                    if (!TypeRepresentation.disallows((PropertyTypeSet)typeConstraint.type(), (Value)value)) continue;
                    violationVisitor.accept(entityId, (IntList)this.entityTokens, (IntObjectMap<Value>)this.properties, "a property type constraint " + String.valueOf(value));
                    return false;
                }
            }
            return true;
        }
    }
}

