/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.batchimport.IncrementalBatchImportUtil;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.UnsafeDirectByteBufferAllocator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;

public class ImportIndexBuilder
implements Closeable {
    private final FileSystemAbstraction fileSystem;
    private final IndexProviderMap indexProviderMap;
    private final IndexProviderMap tempIndexes;
    private final TokenNameLookup tokenNameLookup;
    private final ImmutableSet<OpenOption> openOptions;
    private final PopulationWorkJobScheduler workScheduler;
    private final LongToLongFunction indexedEntityIdConverter;
    private final LongToLongFunction entityIdFromIndexIdConverter;
    private final Configuration configuration;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Map<IndexDescriptor, IndexBuilder> indexBuilders = new ConcurrentHashMap<IndexDescriptor, IndexBuilder>();
    private final Lock builderConstructionLock = new ReentrantLock();
    private final ByteBufferFactory bufferFactory;
    private final MutableLongSet violatingEntities = LongSets.mutable.empty().asSynchronized();
    private final StorageEngineIndexingBehaviour indexingBehaviour;
    private final boolean incrementalIndexing;
    private final Set<IndexDescriptor> excludedIndexes;

    public ImportIndexBuilder(FileSystemAbstraction fileSystem, IndexProviderMap indexProviderMap, IndexProviderMap tempIndexes, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, PopulationWorkJobScheduler workScheduler, LongToLongFunction indexedEntityIdConverter, LongToLongFunction entityIdFromIndexIdConverter, Configuration configuration, IndexStatisticsStore indexStatisticsStore, StorageEngineIndexingBehaviour indexingBehaviour, boolean incrementalIndexing, Set<IndexDescriptor> excludedIndexes) {
        this.fileSystem = fileSystem;
        this.indexProviderMap = indexProviderMap;
        this.tempIndexes = tempIndexes;
        this.tokenNameLookup = tokenNameLookup;
        this.openOptions = openOptions;
        this.workScheduler = workScheduler;
        this.indexedEntityIdConverter = indexedEntityIdConverter;
        this.entityIdFromIndexIdConverter = entityIdFromIndexIdConverter;
        this.configuration = configuration;
        this.indexStatisticsStore = indexStatisticsStore;
        this.indexingBehaviour = indexingBehaviour;
        this.incrementalIndexing = incrementalIndexing;
        this.excludedIndexes = excludedIndexes;
        this.bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, ((Long)Config.defaults().get(GraphDatabaseInternalSettings.index_populator_block_size)).intValue());
    }

    public void add(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
        if (!this.excludedIndexes.contains(indexUpdate.indexKey())) {
            IndexBuilder builder = this.getIndexBuilder((IndexDescriptor)indexUpdate.indexKey());
            builder.add(this.convertEntityId(indexUpdate));
        }
    }

    public boolean addDirect(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
        if (!this.excludedIndexes.contains(indexUpdate.indexKey())) {
            IndexBuilder builder = this.getIndexBuilder((IndexDescriptor)indexUpdate.indexKey());
            return builder.addDirect(this.convertEntityId(indexUpdate));
        }
        return true;
    }

    private IndexEntryUpdate<IndexDescriptor> convertEntityId(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
        long convertedEntityId;
        long entityId = indexUpdate.getEntityId();
        return entityId != (convertedEntityId = this.indexedEntityIdConverter.applyAsLong(entityId)) ? indexUpdate.withEntityId(convertedEntityId) : indexUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexBuilder getIndexBuilder(IndexDescriptor index) {
        IndexBuilder builder = this.indexBuilders.get(index);
        if (builder == null) {
            this.builderConstructionLock.lock();
            try {
                builder = this.indexBuilders.get(index);
                if (builder == null) {
                    IndexPopulator populator = this.constructIndexPopulator(index);
                    IndexAccessor accessor = this.constructIndexAccessor(index);
                    builder = new IndexBuilder(populator, accessor);
                    this.indexBuilders.put(index, builder);
                }
            }
            finally {
                this.builderConstructionLock.unlock();
            }
        }
        return builder;
    }

    private IndexAccessor constructIndexAccessor(IndexDescriptor index) {
        IndexProvider indexProvider = this.indexProviderMap.lookup(index.getIndexProvider());
        try {
            return indexProvider.getOnlineAccessor(index, new IndexSamplingConfig(Config.defaults()), this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private IndexPopulator constructIndexPopulator(IndexDescriptor index) {
        IndexProvider indexProvider = this.tempIndexes.lookup(index.getIndexProvider());
        IndexPopulator populator = indexProvider.getPopulator(index, new IndexSamplingConfig(Config.defaults()), this.bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
        try {
            populator.create();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return populator;
    }

    public void completeBuild(Collector collector, Consumer<Runnable> scheduler) {
        for (Map.Entry<IndexDescriptor, IndexBuilder> population : this.indexBuilders.entrySet()) {
            IndexBuilder builder = population.getValue();
            builder.flush();
            IndexPopulator populator = builder.populator;
            scheduler.accept(() -> {
                RecordingIndexEntryConflictHandler conflictHandler = new RecordingIndexEntryConflictHandler(collector, this.violatingEntities, (IndexDescriptor)population.getKey(), this.tokenNameLookup, this.entityIdFromIndexIdConverter);
                boolean successful = false;
                try {
                    populator.scanCompleted(PhaseTracker.nullInstance, (IndexPopulator.PopulationWorkScheduler)this.workScheduler, (IndexEntryConflictHandler)conflictHandler, CursorContext.NULL_CONTEXT);
                    this.indexStatisticsStore.setSampleStats(((IndexDescriptor)population.getKey()).getId(), populator.sample(CursorContext.NULL_CONTEXT));
                    successful = true;
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    populator.close(successful, CursorContext.NULL_CONTEXT);
                }
            });
        }
    }

    public LongSet validate(LongSet skippedEntityIds, Collector collector) {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        try {
            IndexAccessor builtIncrementIndex;
            for (Map.Entry<IndexDescriptor, IndexBuilder> population : this.indexBuilders.entrySet()) {
                IndexDescriptor descriptor = population.getKey();
                IndexBuilder builder = population.getValue();
                RecordingIndexEntryConflictHandler conflictHandler = new RecordingIndexEntryConflictHandler(collector, this.violatingEntities, descriptor, this.tokenNameLookup, this.entityIdFromIndexIdConverter);
                if (!descriptor.isUnique()) continue;
                builtIncrementIndex = this.tempIndexes.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
                try {
                    builder.accessor.validate(builtIncrementIndex, true, (IndexEntryConflictHandler)conflictHandler, arg_0 -> ((LongSet)skippedEntityIds).contains(arg_0), this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler());
                }
                finally {
                    if (builtIncrementIndex == null) continue;
                    builtIncrementIndex.close();
                }
            }
            LongPredicate filter = skippedEntityIds.isEmpty() && this.violatingEntities.isEmpty() ? null : indexEntityId -> !skippedEntityIds.contains(indexEntityId) && !this.violatingEntities.contains(this.entityIdFromIndexIdConverter.applyAsLong(indexEntityId));
            for (Map.Entry<IndexDescriptor, IndexBuilder> population : this.indexBuilders.entrySet()) {
                IndexDescriptor descriptor = population.getKey();
                IndexBuilder builder = population.getValue();
                if (!descriptor.isUnique() && filter == null && this.incrementalIndexing) {
                    builder.close();
                    IncrementalBatchImportUtil.moveIndex(this.fileSystem, this.tempIndexes, this.indexProviderMap, descriptor);
                    continue;
                }
                builtIncrementIndex = this.tempIndexes.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
                try {
                    builder.accessor.insertFrom(builtIncrementIndex, null, false, IndexEntryConflictHandler.THROW, filter, this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler(), ProgressListener.NONE);
                    builder.accessor.force(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
                }
                finally {
                    if (builtIncrementIndex == null) continue;
                    builtIncrementIndex.close();
                }
            }
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.violatingEntities;
    }

    public LongSet affectedIndexes() {
        MutableLongSet ids = LongSets.mutable.empty();
        this.indexBuilders.keySet().stream().map(IndexDescriptor::getId).forEach(arg_0 -> ((MutableLongSet)ids).add(arg_0));
        return ids;
    }

    @Override
    public void close() throws IOException {
        ArrayList<IndexBuilder> toClose = new ArrayList<IndexBuilder>(this.indexBuilders.values());
        toClose.add((IndexBuilder)this.bufferFactory);
        IOUtils.closeAll(toClose);
    }

    private static class IndexBuilder
    implements AutoCloseable {
        private final IndexPopulator populator;
        private final List<IndexUpdatesBatch> allChanges = new CopyOnWriteArrayList<IndexUpdatesBatch>();
        private final ThreadLocal<IndexUpdatesBatch> changes;
        private final IndexAccessor accessor;

        IndexBuilder(IndexPopulator populator, IndexAccessor accessor) {
            this.populator = populator;
            this.changes = ThreadLocal.withInitial(() -> {
                IndexUpdatesBatch indexUpdatesBatch = new IndexUpdatesBatch(accessor);
                this.allChanges.add(indexUpdatesBatch);
                return indexUpdatesBatch;
            });
            this.accessor = accessor;
        }

        void add(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
            if (indexUpdate.updateMode() == UpdateMode.ADDED) {
                try {
                    this.populator.add(List.of(indexUpdate), CursorContext.NULL_CONTEXT);
                    this.populator.includeSample(indexUpdate);
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.changes.get().add(indexUpdate);
            }
        }

        boolean addDirect(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
            assert (indexUpdate.updateMode() == UpdateMode.ADDED || indexUpdate.updateMode() == UpdateMode.REMOVED);
            try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.DIRECT, CursorContext.NULL_CONTEXT, true);){
                updater.process(indexUpdate);
            }
            catch (IndexEntryConflictException e) {
                return false;
            }
            return true;
        }

        void flush() {
            for (IndexUpdatesBatch batch : this.allChanges) {
                batch.flushChanges();
            }
        }

        @Override
        public void close() {
            this.accessor.close();
        }
    }

    private record RecordingIndexEntryConflictHandler(Collector badCollector, MutableLongSet violatingEntities, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, LongToLongFunction entityIdFromIndexIdConverter) implements IndexEntryConflictHandler
    {
        public IndexEntryConflictHandler.IndexEntryConflictAction indexEntryConflict(long firstEntityId, long otherEntityId, Value[] values) {
            long realId = this.entityIdFromIndexIdConverter.applyAsLong(otherEntityId);
            this.violatingEntities.add(realId);
            this.badCollector.collectEntityViolatingConstraint(null, realId, this.asPropertyMap(this.descriptor, values), this.descriptor.userDescription(this.tokenNameLookup), this.descriptor.schema().entityType());
            return IndexEntryConflictHandler.IndexEntryConflictAction.DELETE;
        }

        private Map<String, Object> asPropertyMap(IndexDescriptor descriptor, Value[] values) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            int[] propertyIds = descriptor.schema().getPropertyIds();
            for (int i = 0; i < propertyIds.length; ++i) {
                properties.put(this.tokenNameLookup.propertyKeyGetName(propertyIds[i]), values[i].asObjectCopy());
            }
            return properties;
        }
    }

    private static class IndexUpdatesBatch {
        private static final int BATCH_SIZE = 100;
        private final List<IndexEntryUpdate<IndexDescriptor>> changes = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
        private final IndexAccessor accessor;

        IndexUpdatesBatch(IndexAccessor accessor) {
            this.accessor = accessor;
        }

        void add(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
            this.changes.add(indexUpdate);
            if (this.changes.size() == 100) {
                this.flushChanges();
            }
        }

        private void flushChanges() {
            try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, true);){
                for (IndexEntryUpdate<IndexDescriptor> change : this.changes) {
                    updater.process(change);
                }
                this.changes.clear();
            }
            catch (IndexEntryConflictException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

