/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.csv.reader.IllegalMultilineFieldException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.importer.Importer;
import org.neo4j.importer.PrintingImportLogicMonitor;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Collectors;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputEntityDecorators;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.MissingRelationshipDataException;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.locker.FileLockException;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.impl.index.schema.DefaultIndexProvidersAccess;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.PrefixedLogProvider;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.Preconditions;

class CsvImporter
implements Importer {
    static final String DEFAULT_REPORT_FILE_NAME = "import.report";
    private final RecordDatabaseLayout databaseLayout;
    private final Config databaseConfig;
    private final org.neo4j.csv.reader.Configuration csvConfig;
    private final org.neo4j.internal.batchimport.Configuration importConfig;
    private final Path reportFile;
    private final IdType idType;
    private final Charset inputEncoding;
    private final boolean ignoreExtraColumns;
    private final boolean skipBadRelationships;
    private final boolean skipDuplicateNodes;
    private final boolean skipBadEntriesLogging;
    private final long badTolerance;
    private final boolean normalizeTypes;
    private final boolean verbose;
    private final boolean autoSkipHeaders;
    private final Map<Set<String>, List<Path[]>> nodeFiles;
    private final Map<String, List<Path[]>> relationshipFiles;
    private final FileSystemAbstraction fileSystem;
    private final PrintStream stdOut;
    private final PrintStream stdErr;
    private final PageCacheTracer pageCacheTracer;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final boolean force;
    private final IncrementalStage incrementalStage;
    private final boolean incremental;

    private CsvImporter(Builder b) {
        this.databaseLayout = Objects.requireNonNull(b.databaseLayout);
        this.databaseConfig = Objects.requireNonNull(b.databaseConfig);
        this.csvConfig = Objects.requireNonNull(b.csvConfig);
        this.importConfig = Objects.requireNonNull(b.importConfig);
        this.reportFile = Objects.requireNonNull(b.reportFile);
        this.idType = Objects.requireNonNull(b.idType);
        this.inputEncoding = Objects.requireNonNull(b.inputEncoding);
        this.ignoreExtraColumns = b.ignoreExtraColumns;
        this.skipBadRelationships = b.skipBadRelationships;
        this.skipDuplicateNodes = b.skipDuplicateNodes;
        this.skipBadEntriesLogging = b.skipBadEntriesLogging;
        this.badTolerance = b.badTolerance;
        this.normalizeTypes = b.normalizeTypes;
        this.verbose = b.verbose;
        this.autoSkipHeaders = b.autoSkipHeaders;
        this.nodeFiles = Objects.requireNonNull(b.nodeFiles);
        this.relationshipFiles = Objects.requireNonNull(b.relationshipFiles);
        this.fileSystem = Objects.requireNonNull(b.fileSystem);
        this.pageCacheTracer = Objects.requireNonNull(b.pageCacheTracer);
        this.contextFactory = Objects.requireNonNull(b.contextFactory);
        this.memoryTracker = Objects.requireNonNull(b.memoryTracker);
        this.stdOut = Objects.requireNonNull(b.stdOut);
        this.stdErr = Objects.requireNonNull(b.stdErr);
        this.force = b.force;
        this.incremental = b.incremental;
        this.incrementalStage = b.incrementalStage;
    }

    @Override
    public void doImport() throws IOException {
        if (this.force) {
            this.fileSystem.deleteRecursively(this.databaseLayout.databaseDirectory());
            this.fileSystem.deleteRecursively(this.databaseLayout.getTransactionLogsDirectory());
        }
        try (OutputStream badOutput = this.fileSystem.openAsOutputStream(this.reportFile, false);
             Collector badCollector = this.getBadCollector(this.skipBadEntriesLogging, badOutput);){
            ZoneId dbTimeZone = (ZoneId)this.databaseConfig.get(GraphDatabaseSettings.db_temporal_timezone);
            Supplier<ZoneId> defaultTimeZone = () -> dbTimeZone;
            Iterable<DataFactory> nodeData = this.nodeData();
            Iterable<DataFactory> relationshipsData = this.relationshipData();
            try (CsvInput input = new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(defaultTimeZone, (boolean)this.normalizeTypes), relationshipsData, DataFactories.defaultFormatRelationshipFileHeader(defaultTimeZone, (boolean)this.normalizeTypes), this.idType, this.csvConfig, this.autoSkipHeaders, (CsvInput.Monitor)new CsvInput.PrintingMonitor(this.stdOut), this.memoryTracker);){
                this.doImport((Input)input, badCollector);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doImport(Input input, Collector badCollector) {
        success = false;
        this.printOverview();
        loggerContext = LogConfig.createLoggerFromXmlConfig((FileSystemAbstraction)this.fileSystem, (Path)((Path)this.databaseConfig.get(GraphDatabaseSettings.server_logging_config_path)), (boolean)(!this.databaseConfig.isExplicitlySet(GraphDatabaseSettings.server_logging_config_path)), (Function<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, configStringLookup(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((Config)this.databaseConfig));
        try {
            jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
            try {
                logProvider = new Log4jLogProvider(loggerContext);
                try {
                    storageEngineFactory = StorageEngineFactory.selectStorageEngine((Configuration)this.databaseConfig);
                    logService = new SimpleLogService((InternalLogProvider)NullLogProvider.getInstance(), (InternalLogProvider)new PrefixedLogProvider((InternalLogProvider)logProvider, this.databaseLayout.getDatabaseName()), ((Boolean)this.databaseConfig.get(GraphDatabaseInternalSettings.duplication_user_messages)).booleanValue());
                    if (this.incremental) {
                        life = new Lifespan(new Lifecycle[0]);
                        try {
                            indexProviders = (DefaultIndexProvidersAccess)life.add((Lifecycle)new DefaultIndexProvidersAccess(storageEngineFactory, this.fileSystem, this.databaseConfig, jobScheduler, (LogService)new SimpleLogService((InternalLogProvider)logProvider), this.pageCacheTracer, this.contextFactory));
                            importer = storageEngineFactory.incrementalBatchImporter((DatabaseLayout)this.databaseLayout, this.fileSystem, this.pageCacheTracer, this.importConfig, (LogService)logService, this.stdOut, this.verbose, AdditionalInitialIds.EMPTY, (ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doImport$1(org.neo4j.storageengine.api.StorageEngineFactory ), ()Lorg/neo4j/kernel/impl/transaction/log/LogTailMetadata;)((CsvImporter)this, (StorageEngineFactory)storageEngineFactory), this.databaseConfig, (Monitor)new PrintingImportLogicMonitor(this.stdOut, this.stdErr), jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), this.memoryTracker, this.contextFactory, (IndexProvidersAccess)indexProviders);
                            switch (1.$SwitchMap$org$neo4j$importer$CsvImporter$IncrementalStage[this.incrementalStage.ordinal()]) {
                                case 1: {
                                    importer.prepare(input);
                                    ** break;
lbl20:
                                    // 1 sources

                                }
                                case 2: {
                                    importer.build(input);
                                    ** break;
lbl24:
                                    // 1 sources

                                }
                                case 3: {
                                    importer.merge();
                                    ** break;
lbl28:
                                    // 1 sources

                                }
                                case 4: {
                                    importer.prepare(input);
                                    importer.build(input);
                                    importer.merge();
                                    ** break;
lbl34:
                                    // 1 sources

                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown import mode " + this.incrementalStage);
                                }
                            }
                        }
                        finally {
                            life.close();
                        }
                    } else {
                        importer = storageEngineFactory.batchImporter((DatabaseLayout)this.databaseLayout, this.fileSystem, this.pageCacheTracer, this.importConfig, (LogService)logService, this.stdOut, this.verbose, AdditionalInitialIds.EMPTY, this.databaseConfig, (Monitor)new PrintingImportLogicMonitor(this.stdOut, this.stdErr), jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), this.memoryTracker, this.contextFactory);
                        importer.doImport(input);
                    }
                    success = true;
                }
                finally {
                    logProvider.close();
                }
            }
            finally {
                if (jobScheduler != null) {
                    jobScheduler.close();
                }
            }
        }
        catch (Exception ex) {
            throw CsvImporter.andPrintError(this.databaseLayout.getDatabaseName(), ex, this.verbose, this.incremental, this.stdErr);
        }
        finally {
            numberOfBadEntries = badCollector.badEntries();
            if (this.reportFile != null && numberOfBadEntries > 0L) {
                this.stdOut.println("There were bad entries which were skipped and logged into " + this.reportFile.toAbsolutePath());
            }
            if (!success) {
                this.stdErr.println("WARNING Import failed. The store files in " + this.databaseLayout.databaseDirectory().toAbsolutePath() + " are left as they are, although they are likely in an unusable state. Starting a database on these store files will likely fail or observe inconsistent records so start at your own risk or delete the store manually");
            }
        }
    }

    private LogTailMetadata readLogTailMetaData(StorageEngineFactory storageEngineFactory) throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fileSystem).withStorageEngineFactory(storageEngineFactory).build().getTailMetadata();
    }

    private static RuntimeException andPrintError(String databaseName, Exception e, boolean stackTrace, boolean incremental, PrintStream err) {
        if (DuplicateInputIdException.class.equals(e.getClass())) {
            CsvImporter.printErrorMessage("Duplicate input ids that would otherwise clash can be put into separate id space.", e, stackTrace, err);
        } else if (MissingRelationshipDataException.class.equals(e.getClass())) {
            CsvImporter.printErrorMessage("Relationship missing mandatory field", e, stackTrace, err);
        } else if (DirectoryNotEmptyException.class.equals(e.getClass())) {
            CsvImporter.printErrorMessage("Database already exist. Re-run with `--overwrite-destination` to remove the database prior to import", e, stackTrace, err);
        } else if (FileLockException.class.equals(e.getClass())) {
            CsvImporter.printErrorMessage("%s can only be run against a database which is offline. The current state of database '%s' is online.".formatted(incremental ? "Incremental import" : "Import", databaseName), e, stackTrace, err);
        } else if (ExceptionUtils.indexOfThrowable((Throwable)e, IllegalMultilineFieldException.class) != -1) {
            CsvImporter.printErrorMessage("Detected field which spanned multiple lines for an import where --multiline-fields=false. If you know that your input data include fields containing new-line characters then import with this option set to true.", e, stackTrace, err);
        } else if (ExceptionUtils.indexOfThrowable((Throwable)e, InputException.class) != -1) {
            CsvImporter.printErrorMessage("Error in input data", e, stackTrace, err);
        } else {
            CsvImporter.printErrorMessage("Import error: " + e.getMessage(), e, true, err);
        }
        err.println();
        Thread.currentThread().setUncaughtExceptionHandler((t, e1) -> {});
        Exceptions.throwIfUnchecked((Throwable)e);
        return new RuntimeException(e);
    }

    private static void printErrorMessage(String string, Exception e, boolean stackTrace, PrintStream err) {
        err.println(string);
        err.println("Caused by:" + e.getMessage());
        if (stackTrace) {
            e.printStackTrace(err);
        }
    }

    private void printOverview() {
        this.stdOut.println("Neo4j version: " + Version.getNeo4jVersion());
        this.stdOut.println("Importing the contents of these files into " + this.databaseLayout.databaseDirectory() + ":");
        if (this.incrementalStage != null) {
            this.stdOut.println("Import mode: " + this.incrementalStage);
        }
        CsvImporter.printInputFiles("Nodes", this.nodeFiles, this.stdOut);
        CsvImporter.printInputFiles("Relationships", this.relationshipFiles, this.stdOut);
        this.stdOut.println();
        this.stdOut.println("Available resources:");
        CsvImporter.printIndented("Total machine memory: " + ByteUnit.bytesToString((long)OsBeanUtil.getTotalPhysicalMemory()), this.stdOut);
        CsvImporter.printIndented("Free machine memory: " + ByteUnit.bytesToString((long)OsBeanUtil.getFreePhysicalMemory()), this.stdOut);
        CsvImporter.printIndented("Max heap memory : " + ByteUnit.bytesToString((long)Runtime.getRuntime().maxMemory()), this.stdOut);
        CsvImporter.printIndented("Max worker threads: " + this.importConfig.maxNumberOfWorkerThreads(), this.stdOut);
        CsvImporter.printIndented("Configured max memory: " + ByteUnit.bytesToString((long)this.importConfig.maxOffHeapMemory()), this.stdOut);
        CsvImporter.printIndented("High parallel IO: " + this.importConfig.highIO(), this.stdOut);
        this.stdOut.println();
    }

    private static void printInputFiles(String name, Map<?, List<Path[]>> inputFiles, PrintStream out) {
        if (inputFiles.isEmpty()) {
            return;
        }
        out.println(name + ":");
        inputFiles.forEach((k, files) -> {
            if (!CsvImporter.isEmptyKey(k)) {
                CsvImporter.printIndented(k + ":", out);
            }
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                Path[] arr;
                for (Path file : arr = (Path[])iterator.next()) {
                    CsvImporter.printIndented(file, out);
                }
            }
            out.println();
        });
    }

    private static boolean isEmptyKey(Object k) {
        if (k instanceof String) {
            return ((String)k).isEmpty();
        }
        if (k instanceof Set) {
            return ((Set)k).isEmpty();
        }
        return false;
    }

    private static void printIndented(Object value, PrintStream out) {
        out.println("  " + value);
    }

    private Iterable<DataFactory> relationshipData() {
        ArrayList<DataFactory> result = new ArrayList<DataFactory>();
        this.relationshipFiles.forEach((defaultTypeName, fileSets) -> {
            Decorator decorator = InputEntityDecorators.defaultRelationshipType((String)defaultTypeName);
            for (Path[] files : fileSets) {
                DataFactory data = DataFactories.data((Decorator)decorator, (Charset)this.inputEncoding, (Path[])files);
                result.add(data);
            }
        });
        return result;
    }

    private Iterable<DataFactory> nodeData() {
        ArrayList<DataFactory> result = new ArrayList<DataFactory>();
        this.nodeFiles.forEach((labels, fileSets) -> {
            Decorator decorator = labels.isEmpty() ? InputEntityDecorators.NO_DECORATOR : InputEntityDecorators.additiveLabels((String[])labels.toArray(new String[0]));
            for (Path[] files : fileSets) {
                DataFactory data = DataFactories.data((Decorator)decorator, (Charset)this.inputEncoding, (Path[])files);
                result.add(data);
            }
        });
        return result;
    }

    private Collector getBadCollector(boolean skipBadEntriesLogging, OutputStream badOutput) {
        return skipBadEntriesLogging ? Collectors.silentBadCollector((long)this.badTolerance) : Collectors.badCollector((OutputStream)badOutput, (long)(this.isIgnoringSomething() ? -1L : 0L), (int)Collectors.collect((boolean)this.skipBadRelationships, (boolean)this.skipDuplicateNodes, (boolean)this.ignoreExtraColumns));
    }

    private boolean isIgnoringSomething() {
        return this.skipBadRelationships || this.skipDuplicateNodes || this.ignoreExtraColumns;
    }

    static Builder builder() {
        return new Builder();
    }

    private /* synthetic */ LogTailMetadata lambda$doImport$1(StorageEngineFactory storageEngineFactory) throws IOException {
        return this.readLogTailMetaData(storageEngineFactory);
    }

    static class Builder {
        private RecordDatabaseLayout databaseLayout;
        private Config databaseConfig;
        private org.neo4j.csv.reader.Configuration csvConfig = org.neo4j.csv.reader.Configuration.COMMAS;
        private org.neo4j.internal.batchimport.Configuration importConfig = org.neo4j.internal.batchimport.Configuration.DEFAULT;
        private Path reportFile;
        private IdType idType = IdType.STRING;
        private Charset inputEncoding = StandardCharsets.UTF_8;
        private boolean ignoreExtraColumns;
        private boolean skipBadRelationships;
        private boolean skipDuplicateNodes;
        private boolean skipBadEntriesLogging;
        private long badTolerance;
        private boolean normalizeTypes;
        private boolean verbose;
        private boolean autoSkipHeaders;
        private final Map<Set<String>, List<Path[]>> nodeFiles = new HashMap<Set<String>, List<Path[]>>();
        private final Map<String, List<Path[]>> relationshipFiles = new HashMap<String, List<Path[]>>();
        private FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        private PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
        private CursorContextFactory contextFactory = CursorContextFactory.NULL_CONTEXT_FACTORY;
        private MemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        private PrintStream stdOut = System.out;
        private PrintStream stdErr = System.err;
        private boolean force;
        private boolean incremental = false;
        private IncrementalStage incrementalStage = null;

        Builder() {
        }

        Builder withDatabaseLayout(DatabaseLayout databaseLayout) {
            this.databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout);
            return this;
        }

        Builder withDatabaseConfig(Config databaseConfig) {
            this.databaseConfig = databaseConfig;
            return this;
        }

        Builder withCsvConfig(org.neo4j.csv.reader.Configuration csvConfig) {
            this.csvConfig = csvConfig;
            return this;
        }

        Builder withImportConfig(org.neo4j.internal.batchimport.Configuration importConfig) {
            this.importConfig = importConfig;
            return this;
        }

        Builder withReportFile(Path reportFile) {
            this.reportFile = reportFile;
            return this;
        }

        Builder withIdType(IdType idType) {
            this.idType = idType;
            return this;
        }

        Builder withInputEncoding(Charset inputEncoding) {
            this.inputEncoding = inputEncoding;
            return this;
        }

        Builder withIgnoreExtraColumns(boolean ignoreExtraColumns) {
            this.ignoreExtraColumns = ignoreExtraColumns;
            return this;
        }

        Builder withSkipBadRelationships(boolean skipBadRelationships) {
            this.skipBadRelationships = skipBadRelationships;
            return this;
        }

        Builder withSkipDuplicateNodes(boolean skipDuplicateNodes) {
            this.skipDuplicateNodes = skipDuplicateNodes;
            return this;
        }

        Builder withSkipBadEntriesLogging(boolean skipBadEntriesLogging) {
            this.skipBadEntriesLogging = skipBadEntriesLogging;
            return this;
        }

        Builder withBadTolerance(long badTolerance) {
            this.badTolerance = badTolerance;
            return this;
        }

        Builder withNormalizeTypes(boolean normalizeTypes) {
            this.normalizeTypes = normalizeTypes;
            return this;
        }

        Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        Builder withAutoSkipHeaders(boolean autoSkipHeaders) {
            this.autoSkipHeaders = autoSkipHeaders;
            return this;
        }

        Builder addNodeFiles(Set<String> labels, Path[] files) {
            List list = this.nodeFiles.computeIfAbsent(labels, unused -> new ArrayList());
            list.add(files);
            return this;
        }

        Builder addRelationshipFiles(String defaultRelType, Path[] files) {
            List list = this.relationshipFiles.computeIfAbsent(defaultRelType, unused -> new ArrayList());
            list.add(files);
            return this;
        }

        Builder withFileSystem(FileSystemAbstraction fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        Builder withPageCacheTracer(PageCacheTracer pageCacheTracer) {
            this.pageCacheTracer = pageCacheTracer;
            this.contextFactory = new CursorContextFactory(pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
            return this;
        }

        Builder withMemoryTracker(MemoryTracker memoryTracker) {
            this.memoryTracker = memoryTracker;
            return this;
        }

        Builder withStdOut(PrintStream stdOut) {
            this.stdOut = stdOut;
            return this;
        }

        Builder withStdErr(PrintStream stdErr) {
            this.stdErr = stdErr;
            return this;
        }

        Builder withForce(boolean force) {
            this.force = force;
            return this;
        }

        Builder withIncremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        Builder withIncrementalStage(IncrementalStage mode) {
            this.incrementalStage = mode;
            return this;
        }

        CsvImporter build() {
            Preconditions.checkState((!this.force || !this.incremental ? 1 : 0) != 0, (String)"--force doesn't work with incremental import", (Object[])new Object[]{this.incrementalStage});
            return new CsvImporter(this);
        }
    }

    static enum IncrementalStage {
        prepare,
        build,
        merge,
        all;

    }
}

