/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.ast.GraphSelection;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.Statements;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckContext;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.parser.AstParserFactory$;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.Neo4jCypherExceptionFactory;
import org.neo4j.cypher.internal.util.devNullLogger$;
import org.neo4j.importer.SchemaCommandsBuilder;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import scala.Option;

public class SchemaCommandReader {
    private static final String ERROR_SUFFIX = " in import change commands.";
    private static final InternalNotificationLogger NOTIFICATION_LOGGER = devNullLogger$.MODULE$;
    private final FileSystemAbstraction fileSystem;
    private final ReaderConfig readerConfig;
    private final PreParser preParser;

    public SchemaCommandReader(FileSystemAbstraction fileSystem, Config config, ReaderConfig readerConfig) {
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.preParser = new PreParser(CypherConfiguration.fromConfig((Config)Objects.requireNonNull(config)));
        this.readerConfig = Objects.requireNonNull(readerConfig);
    }

    public List<SchemaCommand> parse(Path cypherPath) throws SchemaCommand.SchemaCommandReaderException {
        String cypherText = this.parseFile(cypherPath);
        if (cypherText.isEmpty()) {
            return List.of();
        }
        SemanticState semanticState = SemanticState.clean();
        PreParsedQuery preParsedQuery = this.preParser.preParse(cypherText, NOTIFICATION_LOGGER);
        CypherVersion cypherVersion = preParsedQuery.options().queryOptions().cypherVersion().actualVersion();
        Neo4jCypherExceptionFactory exceptionFactory = new Neo4jCypherExceptionFactory(cypherText, Option.apply((Object)preParsedQuery.options().offset()));
        Statements statements = AstParserFactory$.MODULE$.apply(cypherVersion).apply(preParsedQuery.statement(), (CypherExceptionFactory)exceptionFactory, Option.apply((Object)NOTIFICATION_LOGGER)).statements();
        SchemaCommandsBuilder changesBuilder = new SchemaCommandsBuilder(this.readerConfig, cypherVersion);
        SemanticCheckContext checkContext = SemanticCheckContext.empty();
        int length = statements.size();
        for (int i = 0; i < length; ++i) {
            semanticState = this.transform(changesBuilder, statements.get(i), semanticState, checkContext);
        }
        return changesBuilder.build();
    }

    private String parseFile(Path cypherPath) throws SchemaCommand.SchemaCommandReaderException {
        Preconditions.checkState((cypherPath != null && this.fileSystem.fileExists(cypherPath) ? 1 : 0) != 0, (String)"The path to the Cypher schema commands must exist");
        try {
            return FileSystemUtils.readString((FileSystemAbstraction)this.fileSystem, (Path)cypherPath, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        catch (IOException ex) {
            throw new SchemaCommand.SchemaCommandReaderException("Unable to read Cypher statement(s) in " + String.valueOf(cypherPath), (Throwable)ex);
        }
    }

    private SemanticState transform(SchemaCommandsBuilder changesBuilder, Statement statement, SemanticState semanticState, SemanticCheckContext checkContext) throws SchemaCommand.SchemaCommandReaderException {
        if (statement instanceof org.neo4j.cypher.internal.ast.SchemaCommand) {
            org.neo4j.cypher.internal.ast.SchemaCommand command = (org.neo4j.cypher.internal.ast.SchemaCommand)statement;
            if (!command.useGraph().isEmpty()) {
                throw new SchemaCommand.SchemaCommandReaderException("Schema commands are only applied to the database to be imported into so graph names are not allowed: " + ((GraphSelection)command.useGraph().get()).graphReference().print());
            }
            SemanticState nextState = SchemaCommandReader.checkStatement(statement, semanticState, checkContext);
            changesBuilder.withCommand(command);
            return nextState;
        }
        throw new SchemaCommand.SchemaCommandReaderException("Only schema change clauses are allowed here but found: " + statement.getClass().getSimpleName());
    }

    private static SemanticState checkStatement(Statement statement, SemanticState semanticState, SemanticCheckContext checkContext) throws SchemaCommand.SchemaCommandReaderException {
        SemanticCheckResult checkResult = statement.semanticCheck().run(semanticState, checkContext);
        if (!checkResult.errors().isEmpty()) {
            StringBuilder errorText = new StringBuilder("Unable to parse the Cypher").append(ERROR_SUFFIX);
            checkResult.errors().foreach(error -> {
                errorText.append(System.lineSeparator()).append(error.msg());
                return null;
            });
            throw new SchemaCommand.SchemaCommandReaderException(errorText.toString());
        }
        return checkResult.state();
    }

    public record ReaderConfig(boolean allowEnterpriseFeatures, boolean allowConstraints, boolean allowDropOperations, VectorIndexVersion latestVectorIndexVersion) {
        public static ReaderConfig defaults() {
            return new ReaderConfig(false, false, false, VectorIndexVersion.latestSupportedVersion((KernelVersion)KernelVersion.getLatestVersion((Config)Config.defaults())));
        }
    }
}

