/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.importer.CharacterConverter;
import org.neo4j.importer.CsvImporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexConfig;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="import", description={"Import a collection of CSV files."})
public class ImportCommand
extends AbstractCommand {
    private static final String MULTI_FILE_DELIMITER = ",";
    private static final Function<String, Character> CHARACTER_CONVERTER = new CharacterConverter();
    private static final Configuration DEFAULT_CSV_CONFIG = Configuration.COMMAS;
    private static final org.neo4j.internal.batchimport.Configuration DEFAULT_IMPORTER_CONFIG = org.neo4j.internal.batchimport.Configuration.DEFAULT;
    @CommandLine.Option(names={"--database"}, defaultValue="neo4j", converter={Converters.DatabaseNameConverter.class}, description={"Name of the database to import.%n  If the database used to import into doesn't exist prior to importing,%n  then it must be created subsequently using CREATE DATABASE."})
    private NormalizedDatabaseName database;
    @CommandLine.Option(names={"--additional-config"}, paramLabel="<path>", description={"Configuration file to supply additional configuration in."})
    private Path additionalConfig;
    @CommandLine.Option(names={"--report-file"}, paramLabel="<path>", defaultValue="import.report", description={"File in which to store the report of the csv-import."})
    private Path reportFile = Path.of("import.report", new String[0]);
    @CommandLine.Option(names={"--force"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Force will delete any existing database files prior to the import."})
    private boolean force;
    @CommandLine.Option(names={"--id-type"}, paramLabel="<STRING|INTEGER|ACTUAL>", description={"Each node must provide a unique id. This is used to find the correct nodes when creating relationships. Possible values are:%n  STRING: arbitrary strings for identifying nodes,%n  INTEGER: arbitrary integer values for identifying nodes,%n  ACTUAL: (advanced) actual node ids.%nFor more information on id handling, please see the Neo4j Manual: https://neo4j.com/docs/operations-manual/current/tools/import/"})
    private IdType idType = IdType.STRING;
    @CommandLine.Option(names={"--input-encoding"}, paramLabel="<character-set>", description={"Character set that input data is encoded in."})
    private Charset inputEncoding = StandardCharsets.UTF_8;
    @CommandLine.Option(names={"--ignore-extra-columns"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"If un-specified columns should be ignored during the import."})
    private boolean ignoreExtraColumns;
    @CommandLine.Option(names={"--multiline-fields"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not fields from input source can span multiple lines, i.e. contain newline characters."})
    private boolean multilineFields = DEFAULT_CSV_CONFIG.multilineFields();
    @CommandLine.Option(names={"--ignore-empty-strings"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not empty string fields, i.e. \"\" from input source are ignored, i.e. treated as null."})
    private boolean ignoreEmptyStrings = DEFAULT_CSV_CONFIG.emptyQuotedStringsAsNull();
    @CommandLine.Option(names={"--trim-strings"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not strings should be trimmed for whitespaces."})
    private boolean trimStrings = DEFAULT_CSV_CONFIG.trimStrings();
    @CommandLine.Option(names={"--legacy-style-quoting"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not backslash-escaped quote e.g. \\\" is interpreted as inner quote."})
    private boolean legacyStyleQuoting = DEFAULT_CSV_CONFIG.legacyStyleQuoting();
    @CommandLine.Option(names={"--delimiter"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Delimiter character between values in CSV data. Also accepts 'TAB' and e.g. 'U+20AC' for specifying character using unicode."})
    private char delimiter = DEFAULT_CSV_CONFIG.delimiter();
    @CommandLine.Option(names={"--array-delimiter"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Delimiter character between array elements within a value in CSV data. Also accepts 'TAB' and e.g. 'U+20AC' for specifying character using unicode."})
    private char arrayDelimiter = DEFAULT_CSV_CONFIG.arrayDelimiter();
    @CommandLine.Option(names={"--quote"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Character to treat as quotation character for values in CSV data. Quotes can be escaped as per RFC 4180 by doubling them, for example \"\" would be interpreted as a literal \". You cannot escape using \\."})
    private char quote = DEFAULT_CSV_CONFIG.quotationCharacter();
    @CommandLine.Option(names={"--read-buffer-size"}, paramLabel="<size>", converter={Converters.ByteUnitConverter.class}, description={"Size of each buffer for reading input data. The size has to at least be large enough to hold the biggest single value in the input data. The value can be a plain number or a byte units string, e.g. 128k, 1m."})
    private long bufferSize = DEFAULT_CSV_CONFIG.bufferSize();
    @CommandLine.Option(names={"--max-memory"}, paramLabel="<size>", defaultValue="90%", converter={MemoryConverter.class}, description={"Maximum memory that neo4j-admin can use for various data structures and caching to improve performance. Values can be plain numbers, like 10000000 or e.g. 20G for 20 gigabyte, or even e.g. 70%%."})
    private long maxMemory;
    @CommandLine.Option(names={"--high-io"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Ignore environment-based heuristics, and assume that the target storage subsystem can support parallel IO with high throughput."})
    private Boolean highIo;
    @CommandLine.Option(names={"--cache-on-heap"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, arity="0..1", paramLabel="<true/false>", description={"(advanced) Whether or not to allow allocating memory for the cache on heap. If 'false' then caches will still be allocated off-heap, but the additional free memory inside the JVM will not be allocated for the caches. Use this option to be able to have better control over the heap memory."})
    private boolean cacheOnHeap = DEFAULT_IMPORTER_CONFIG.allowCacheAllocationOnHeap();
    @CommandLine.Option(names={"--processors"}, paramLabel="<num>", description={"(advanced) Max number of processors used by the importer. Defaults to the number of available processors reported by the JVM. There is a certain amount of minimum threads needed so for that reason there is no lower bound for this value. For optimal performance this value shouldn't be greater than the number of available processors."})
    private int processors = DEFAULT_IMPORTER_CONFIG.maxNumberOfProcessors();
    @CommandLine.Option(names={"--bad-tolerance"}, paramLabel="<num>", description={"Number of bad entries before the import is considered failed. This tolerance threshold is about relationships referring to missing nodes. Format errors in input data are still treated as errors"})
    private long badTolerance = 1000L;
    @CommandLine.Option(names={"--skip-bad-entries-logging"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not to skip logging bad entries detected during import."})
    private boolean skipBadEntriesLogging;
    @CommandLine.Option(names={"--skip-bad-relationships"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not to skip importing relationships that refers to missing node ids, i.e. either start or end node id/group referring to node that wasn't specified by the node input data. Skipped relationships will be logged, containing at most number of entities specified by bad-tolerance, unless otherwise specified by skip-bad-entries-logging option."})
    private boolean skipBadRelationships;
    @CommandLine.Option(names={"--skip-duplicate-nodes"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not to skip importing nodes that have the same id/group. In the event of multiple nodes within the same group having the same id, the first encountered will be imported whereas consecutive such nodes will be skipped. Skipped nodes will be logged, containing at most number of entities specified by bad-tolerance, unless otherwise specified by skip-bad-entries-logging option."})
    private boolean skipDuplicateNodes;
    @CommandLine.Option(names={"--normalize-types"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not to normalize property types to Cypher types, e.g. 'int' becomes 'long' and 'float' becomes 'double'"})
    private boolean normalizeTypes = true;
    @CommandLine.Option(names={"--nodes"}, required=true, arity="1..*", converter={NodeFilesConverter.class}, paramLabel="[<label>[:<label>]...=]<files>", description={"Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header."})
    private List<NodeFilesGroup> nodes;
    @CommandLine.Option(names={"--relationships"}, arity="1..*", converter={RelationsipFilesConverter.class}, showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="[<type>=]<files>", description={"Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header."})
    private List<RelationshipFilesGroup> relationships = new ArrayList<RelationshipFilesGroup>();
    @CommandLine.Option(names={"--auto-skip-subsequent-headers"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Automatically skip accidental header lines in subsequent files in file groups with more than one file"})
    private boolean autoSkipHeaders;

    public ImportCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        try {
            Config databaseConfig = this.loadNeo4jConfig();
            Neo4jLayout neo4jLayout = Neo4jLayout.of((Config)databaseConfig);
            RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)this.database.name());
            Configuration csvConfig = this.csvConfiguration();
            org.neo4j.internal.batchimport.Configuration importConfig = this.importConfiguration((DatabaseLayout)databaseLayout);
            CsvImporter.Builder importerBuilder = CsvImporter.builder().withDatabaseLayout((DatabaseLayout)databaseLayout).withDatabaseConfig(databaseConfig).withFileSystem(this.ctx.fs()).withStdOut(this.ctx.out()).withStdErr(this.ctx.err()).withCsvConfig(csvConfig).withImportConfig(importConfig).withIdType(this.idType).withInputEncoding(this.inputEncoding).withReportFile(this.reportFile.toAbsolutePath()).withIgnoreExtraColumns(this.ignoreExtraColumns).withBadTolerance(this.badTolerance).withSkipBadRelationships(this.skipBadRelationships).withSkipDuplicateNodes(this.skipDuplicateNodes).withSkipBadEntriesLogging(this.skipBadEntriesLogging).withSkipBadRelationships(this.skipBadRelationships).withNormalizeTypes(this.normalizeTypes).withVerbose(this.verbose).withAutoSkipHeaders(this.autoSkipHeaders).withForce(this.force);
            this.nodes.forEach(n -> importerBuilder.addNodeFiles((Set)n.key, n.files));
            this.relationships.forEach(n -> importerBuilder.addRelationshipFiles((String)n.key, n.files));
            CsvImporter importer = importerBuilder.build();
            importer.doImport();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    Config loadNeo4jConfig() {
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir().toAbsolutePath()).fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf")).fromFileNoThrow(this.additionalConfig).commandExpansion(this.allowCommandExpansion).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }

    private Configuration csvConfiguration() {
        return DEFAULT_CSV_CONFIG.toBuilder().withDelimiter(this.delimiter).withArrayDelimiter(this.arrayDelimiter).withQuotationCharacter(this.quote).withMultilineFields(this.multilineFields).withEmptyQuotedStringsAsNull(this.ignoreEmptyStrings).withTrimStrings(this.trimStrings).withLegacyStyleQuoting(this.legacyStyleQuoting).withBufferSize(Math.toIntExact(this.bufferSize)).build();
    }

    private org.neo4j.internal.batchimport.Configuration importConfiguration(DatabaseLayout databaseLayout) {
        return new Configuration.Overridden(org.neo4j.internal.batchimport.Configuration.defaultConfiguration((Path)databaseLayout.databaseDirectory())){

            public int maxNumberOfProcessors() {
                return ImportCommand.this.processors;
            }

            public long maxMemoryUsage() {
                return ImportCommand.this.maxMemory;
            }

            public boolean highIO() {
                return ImportCommand.this.highIo != null ? ImportCommand.this.highIo.booleanValue() : super.highIO();
            }

            public IndexConfig indexConfig() {
                return IndexConfig.create().withLabelIndex().withRelationshipTypeIndex();
            }

            public boolean allowCacheAllocationOnHeap() {
                return ImportCommand.this.cacheOnHeap;
            }
        };
    }

    @VisibleForTesting
    static RelationshipFilesGroup parseRelationshipFilesGroup(String str) {
        Pair<String, Path[]> p = ImportCommand.parseInputFilesGroup(str, String::trim);
        return new RelationshipFilesGroup((String)p.getOne(), (Path[])p.getTwo());
    }

    @VisibleForTesting
    static NodeFilesGroup parseNodeFilesGroup(String str) {
        Pair<Set, Path[]> p = ImportCommand.parseInputFilesGroup(str, s -> Arrays.stream(s.split(":")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toSet()));
        return new NodeFilesGroup((Set)p.getOne(), (Path[])p.getTwo());
    }

    private static <T> Pair<T, Path[]> parseInputFilesGroup(String str, Function<String, ? extends T> keyParser) {
        int i = str.indexOf(61);
        if (i < 0) {
            return Tuples.pair(keyParser.apply(""), (Object)ImportCommand.parseFilesList(str));
        }
        if (i == 0 || i == str.length() - 1) {
            throw new IllegalArgumentException("illegal `=` position: " + str);
        }
        String keyStr = str.substring(0, i);
        String filesStr = str.substring(i + 1);
        T key = keyParser.apply(keyStr);
        Path[] files = ImportCommand.parseFilesList(filesStr);
        return Tuples.pair(key, (Object)files);
    }

    private static Path[] parseFilesList(String str) {
        Function converter = Converters.regexFiles((boolean)true);
        return (Path[])Converters.toFiles((String)MULTI_FILE_DELIMITER, s -> {
            Validators.REGEX_FILE_EXISTS.validate(s);
            return (Path[])converter.apply(s);
        }).apply(str);
    }

    static abstract class InputFilesGroup<T> {
        final T key;
        final Path[] files;

        InputFilesGroup(T key, Path[] files) {
            this.key = key;
            this.files = files;
        }
    }

    static class RelationshipFilesGroup
    extends InputFilesGroup<String> {
        RelationshipFilesGroup(String key, Path[] files) {
            super(key, files);
        }
    }

    static class NodeFilesGroup
    extends InputFilesGroup<Set<String>> {
        NodeFilesGroup(Set<String> key, Path[] files) {
            super(key, files);
        }
    }

    static class RelationsipFilesConverter
    implements CommandLine.ITypeConverter<InputFilesGroup<String>> {
        RelationsipFilesConverter() {
        }

        public InputFilesGroup<String> convert(String value) {
            try {
                return ImportCommand.parseRelationshipFilesGroup(value);
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("Invalid relationships file: %s (%s)", value, e));
            }
        }
    }

    static class NodeFilesConverter
    implements CommandLine.ITypeConverter<NodeFilesGroup> {
        NodeFilesConverter() {
        }

        public NodeFilesGroup convert(String value) {
            try {
                return ImportCommand.parseNodeFilesGroup(value);
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("Invalid nodes file: %s (%s)", value, e));
            }
        }
    }

    static class EscapedCharacterConverter
    implements CommandLine.ITypeConverter<Character> {
        EscapedCharacterConverter() {
        }

        public Character convert(String value) {
            return CHARACTER_CONVERTER.apply(value);
        }
    }

    static class MemoryConverter
    implements CommandLine.ITypeConverter<Long> {
        MemoryConverter() {
        }

        public Long convert(String value) {
            if ((value = value.trim()).endsWith("%")) {
                int percent = Integer.parseInt(value.substring(0, value.length() - 1));
                long result = org.neo4j.internal.batchimport.Configuration.calculateMaxMemoryFromPercent((int)percent);
                if (!org.neo4j.internal.batchimport.Configuration.canDetectFreeMemory()) {
                    System.err.println("WARNING: amount of free memory couldn't be detected so defaults to " + ByteUnit.bytesToString((long)result) + ". For optimal performance instead explicitly specify amount of memory that importer is allowed to use using --max-memory");
                }
                return result;
            }
            return SettingValueParsers.parseLongWithUnit((String)value);
        }
    }
}

