/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.IllegalMultilineFieldException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.OsBeanUtil;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.tooling.CharacterConverter;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.MissingRelationshipDataException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class ImportTool {
    private static final String INPUT_FILES_DESCRIPTION = "Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks. Each file can be a regular expression and will then include all matching files. The file matching is done with number awareness such that e.g. files:'File1Part_001.csv', 'File12Part_003' will be ordered in that order for a pattern like: 'File.*'";
    private static final String UNLIMITED = "true";
    static final String MULTI_FILE_DELIMITER = ",";
    private static final Function<String, IdType> TO_ID_TYPE = from -> IdType.valueOf((String)from.toUpperCase());
    private static final Function<String, Character> CHARACTER_CONVERTER = new CharacterConverter();

    private ImportTool() {
    }

    public static void main(String[] incomingArguments) throws IOException {
        ImportTool.main(incomingArguments, false);
    }

    public static void main(String[] incomingArguments, boolean defaultSettingsSuitableForTests) throws IOException {
        System.err.println("WARNING: neo4j-import is deprecated and support for it will be removed in a future\nversion of Neo4j; please use neo4j-admin import instead.\n");
        PrintStream out = System.out;
        PrintStream err = System.err;
        Args args = Args.parse((String[])incomingArguments);
        if (ArrayUtil.isEmpty((Object[])incomingArguments) || ImportTool.asksForUsage(args)) {
            ImportTool.printUsage(out);
            return;
        }
        Number processors = null;
        CsvInput input = null;
        OutputStream badOutput = null;
        IdType idType = null;
        org.neo4j.unsafe.impl.batchimport.Configuration configuration = null;
        File badFile = null;
        Long maxMemory = null;
        boolean success = false;
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();){
            File storeDir = (File)args.interpretOption(Options.STORE_DIR.key(), Converters.mandatory(), Converters.toFile(), new Validator[]{Validators.DIRECTORY_IS_WRITABLE, Validators.CONTAINS_NO_EXISTING_DATABASE});
            Config config = Config.defaults();
            config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.neo4j_home.name(), storeDir.getAbsolutePath()}));
            File logsDir = (File)config.get(GraphDatabaseSettings.logs_directory);
            fs.mkdirs(logsDir);
            boolean skipBadEntriesLogging = args.getBoolean(Options.SKIP_BAD_ENTRIES_LOGGING.key(), (Boolean)Options.SKIP_BAD_ENTRIES_LOGGING.defaultValue(), Boolean.valueOf(false));
            if (!skipBadEntriesLogging) {
                badFile = new File(storeDir, "bad.log");
                badOutput = new BufferedOutputStream(fs.openAsOutputStream(badFile, false));
            }
            Collection<Args.Option<File[]>> nodesFiles = ImportTool.extractInputFiles(args, Options.NODE_DATA.key(), err);
            Collection<Args.Option<File[]>> relationshipsFiles = ImportTool.extractInputFiles(args, Options.RELATIONSHIP_DATA.key(), err);
            String maxMemoryString = args.get(Options.MAX_MEMORY.key(), null);
            maxMemory = ImportTool.parseMaxMemory(maxMemoryString);
            ImportTool.validateInputFiles(nodesFiles, relationshipsFiles);
            boolean enableStacktrace = args.getBoolean(Options.STACKTRACE.key(), Boolean.FALSE, Boolean.TRUE);
            processors = args.getNumber(Options.PROCESSORS.key(), null);
            idType = (IdType)args.interpretOption(Options.ID_TYPE.key(), Converters.withDefault((Object)((IdType)Options.ID_TYPE.defaultValue())), TO_ID_TYPE, new Validator[0]);
            int badTolerance = ImportTool.parseNumberOrUnlimited(args, Options.BAD_TOLERANCE);
            Charset inputEncoding = Charset.forName(args.get(Options.INPUT_ENCODING.key(), Charset.defaultCharset().name()));
            boolean skipBadRelationships = args.getBoolean(Options.SKIP_BAD_RELATIONSHIPS.key(), (Boolean)Options.SKIP_BAD_RELATIONSHIPS.defaultValue(), Boolean.valueOf(true));
            boolean skipDuplicateNodes = args.getBoolean(Options.SKIP_DUPLICATE_NODES.key(), (Boolean)Options.SKIP_DUPLICATE_NODES.defaultValue(), Boolean.valueOf(true));
            boolean ignoreExtraColumns = args.getBoolean(Options.IGNORE_EXTRA_COLUMNS.key(), (Boolean)Options.IGNORE_EXTRA_COLUMNS.defaultValue(), Boolean.valueOf(true));
            Collector badCollector = ImportTool.getBadCollector(badTolerance, skipBadRelationships, skipDuplicateNodes, ignoreExtraColumns, skipBadEntriesLogging, badOutput);
            Config dbConfig = ImportTool.loadDbConfig((File)args.interpretOption(Options.DATABASE_CONFIG.key(), Converters.optional(), Converters.toFile(), new Validator[]{Validators.REGEX_FILE_EXISTS}));
            configuration = ImportTool.importConfiguration(processors, defaultSettingsSuitableForTests, dbConfig, maxMemory);
            input = new CsvInput(ImportTool.nodeData(inputEncoding, nodesFiles), DataFactories.defaultFormatNodeFileHeader(), ImportTool.relationshipData(inputEncoding, relationshipsFiles), DataFactories.defaultFormatRelationshipFileHeader(), idType, ImportTool.csvConfiguration(args, defaultSettingsSuitableForTests), badCollector, configuration.maxNumberOfProcessors());
            ImportTool.doImport(out, err, storeDir, logsDir, badFile, (FileSystemAbstraction)fs, nodesFiles, relationshipsFiles, enableStacktrace, (Input)input, dbConfig, badOutput, configuration);
            success = true;
        }
        catch (IllegalArgumentException e) {
            throw ImportTool.andPrintError("Input error", e, false, err);
        }
        catch (IOException e) {
            throw ImportTool.andPrintError("File error", e, false, err);
        }
        finally {
            if (!success && badOutput != null) {
                badOutput.close();
            }
        }
    }

    private static Long parseMaxMemory(String maxMemoryString) {
        if (maxMemoryString != null) {
            if ((maxMemoryString = maxMemoryString.trim()).endsWith("%")) {
                int percent = Integer.parseInt(maxMemoryString.substring(0, maxMemoryString.length() - 1));
                long result = org.neo4j.unsafe.impl.batchimport.Configuration.calculateMaxMemoryFromPercent((int)percent);
                if (!org.neo4j.unsafe.impl.batchimport.Configuration.canDetectFreeMemory()) {
                    System.err.println("WARNING: amount of free memory couldn't be detected so defaults to " + Format.bytes((long)result) + ". For optimal performance instead explicitly specify amount of memory that importer is allowed to use using " + Options.MAX_MEMORY.argument());
                }
                return result;
            }
            return Settings.parseLongWithUnit((String)maxMemoryString);
        }
        return null;
    }

    public static void doImport(PrintStream out, PrintStream err, File storeDir, File logsDir, File badFile, FileSystemAbstraction fs, Collection<Args.Option<File[]>> nodesFiles, Collection<Args.Option<File[]>> relationshipsFiles, boolean enableStacktrace, Input input, Config dbConfig, OutputStream badOutput, org.neo4j.unsafe.impl.batchimport.Configuration configuration) throws IOException {
        LifeSupport life = new LifeSupport();
        File internalLogFile = (File)dbConfig.get(GraphDatabaseSettings.store_internal_log_path);
        LogService logService = (LogService)life.add((Lifecycle)StoreLogService.withInternalLog((File)internalLogFile).build(fs));
        life.start();
        ParallelBatchImporter importer = new ParallelBatchImporter(storeDir, fs, configuration, logService, ExecutionMonitors.defaultVisible(), dbConfig);
        ImportTool.printOverview(storeDir, nodesFiles, relationshipsFiles, configuration, out);
        boolean success = false;
        try {
            importer.doImport(input);
            success = true;
        }
        catch (Exception e) {
            try {
                throw ImportTool.andPrintError("Import error", e, enableStacktrace, err);
            }
            catch (Throwable throwable) {
                block13: {
                    Collector collector = input.badCollector();
                    int numberOfBadEntries = collector.badEntries();
                    collector.close();
                    IOUtils.closeAll((AutoCloseable[])new OutputStream[]{badOutput});
                    if (badFile != null && numberOfBadEntries > 0) {
                        System.out.println("There were bad entries which were skipped and logged into " + badFile.getAbsolutePath());
                    }
                    life.shutdown();
                    if (!success) {
                        try {
                            StoreFile.fileOperation((FileOperation)FileOperation.DELETE, (FileSystemAbstraction)fs, (File)storeDir, null, (Iterable)Iterables.iterable((Object[])StoreFile.values()), (boolean)false, (ExistingTargetStrategy)ExistingTargetStrategy.FAIL, (StoreFileType[])StoreFileType.values());
                        }
                        catch (IOException e2) {
                            err.println("Unable to delete store files after an aborted import " + e2);
                            if (!enableStacktrace) break block13;
                            e2.printStackTrace();
                        }
                    }
                }
                throw throwable;
            }
        }
        Collector collector = input.badCollector();
        int numberOfBadEntries = collector.badEntries();
        collector.close();
        IOUtils.closeAll((AutoCloseable[])new OutputStream[]{badOutput});
        if (badFile != null && numberOfBadEntries > 0) {
            System.out.println("There were bad entries which were skipped and logged into " + badFile.getAbsolutePath());
        }
        life.shutdown();
        if (!success) {
            try {
                StoreFile.fileOperation((FileOperation)FileOperation.DELETE, (FileSystemAbstraction)fs, (File)storeDir, null, (Iterable)Iterables.iterable((Object[])StoreFile.values()), (boolean)false, (ExistingTargetStrategy)ExistingTargetStrategy.FAIL, (StoreFileType[])StoreFileType.values());
            }
            catch (IOException e) {
                err.println("Unable to delete store files after an aborted import " + e);
                if (enableStacktrace) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Collection<Args.Option<File[]>> extractInputFiles(Args args, String key, PrintStream err) {
        return args.interpretOptionsWithMetadata(key, Converters.optional(), Converters.toFiles((String)MULTI_FILE_DELIMITER, (Function)Converters.regexFiles((boolean)true)), new Validator[]{ImportTool.filesExist(err), Validators.atLeast((String)("--" + key), (int)1)});
    }

    private static Validator<File[]> filesExist(PrintStream err) {
        return files -> {
            for (File file : files) {
                if (file.getName().startsWith(":")) {
                    err.println("It looks like you're trying to specify default label or relationship type (" + file.getName() + "). Please put such directly on the key, f.ex. " + Options.NODE_DATA.argument() + ":MyLabel");
                }
                Validators.REGEX_FILE_EXISTS.validate((Object)file);
            }
        };
    }

    private static Collector getBadCollector(int badTolerance, boolean skipBadRelationships, boolean skipDuplicateNodes, boolean ignoreExtraColumns, boolean skipBadEntriesLogging, OutputStream badOutput) {
        int collect = Collectors.collect((boolean)skipBadRelationships, (boolean)skipDuplicateNodes, (boolean)ignoreExtraColumns);
        return skipBadEntriesLogging ? Collectors.silentBadCollector((int)badTolerance, (int)collect) : Collectors.badCollector((OutputStream)badOutput, (int)badTolerance, (int)collect);
    }

    private static Integer parseNumberOrUnlimited(Args args, Options option) {
        String value = args.get(option.key(), option.defaultValue().toString());
        return UNLIMITED.equals(value) ? -1 : Integer.parseInt(value);
    }

    private static Config loadDbConfig(File file) throws IOException {
        return file != null && file.exists() ? Config.embeddedDefaults((Map)MapUtil.load((File)file)) : Config.defaults();
    }

    private static void printOverview(File storeDir, Collection<Args.Option<File[]>> nodesFiles, Collection<Args.Option<File[]>> relationshipsFiles, org.neo4j.unsafe.impl.batchimport.Configuration configuration, PrintStream out) {
        out.println("Neo4j version: " + Version.getNeo4jVersion());
        out.println("Importing the contents of these files into " + storeDir + ":");
        ImportTool.printInputFiles("Nodes", nodesFiles, out);
        ImportTool.printInputFiles("Relationships", relationshipsFiles, out);
        out.println();
        out.println("Available resources:");
        ImportTool.printIndented("Total machine memory: " + Format.bytes((long)OsBeanUtil.getTotalPhysicalMemory()), out);
        ImportTool.printIndented("Free machine memory: " + Format.bytes((long)OsBeanUtil.getFreePhysicalMemory()), out);
        ImportTool.printIndented("Max heap memory : " + Format.bytes((long)Runtime.getRuntime().maxMemory()), out);
        ImportTool.printIndented("Processors: " + configuration.maxNumberOfProcessors(), out);
        ImportTool.printIndented("Configured max memory: " + Format.bytes((long)configuration.maxMemoryUsage()), out);
        out.println();
    }

    private static void printInputFiles(String name, Collection<Args.Option<File[]>> files, PrintStream out) {
        if (files.isEmpty()) {
            return;
        }
        out.println(name + ":");
        int i = 0;
        for (Args.Option<File[]> group : files) {
            if (i++ > 0) {
                out.println();
            }
            if (group.metadata() != null) {
                ImportTool.printIndented(":" + group.metadata(), out);
            }
            for (File file : (File[])group.value()) {
                ImportTool.printIndented(file, out);
            }
        }
    }

    private static void printIndented(Object value, PrintStream out) {
        out.println("  " + value);
    }

    public static void validateInputFiles(Collection<Args.Option<File[]>> nodesFiles, Collection<Args.Option<File[]>> relationshipsFiles) {
        if (nodesFiles.isEmpty()) {
            if (relationshipsFiles.isEmpty()) {
                throw new IllegalArgumentException("No input specified, nothing to import");
            }
            throw new IllegalArgumentException("No node input specified, cannot import relationships without nodes");
        }
    }

    public static org.neo4j.unsafe.impl.batchimport.Configuration importConfiguration(Number processors, boolean defaultSettingsSuitableForTests, Config dbConfig) {
        return ImportTool.importConfiguration(processors, defaultSettingsSuitableForTests, dbConfig, null);
    }

    public static org.neo4j.unsafe.impl.batchimport.Configuration importConfiguration(final Number processors, final boolean defaultSettingsSuitableForTests, final Config dbConfig, final Long maxMemory) {
        return new org.neo4j.unsafe.impl.batchimport.Configuration(){

            public long pageCacheMemory() {
                return defaultSettingsSuitableForTests ? ByteUnit.mebiBytes((long)8L) : DEFAULT.pageCacheMemory();
            }

            public int maxNumberOfProcessors() {
                return processors != null ? processors.intValue() : DEFAULT.maxNumberOfProcessors();
            }

            public int denseNodeThreshold() {
                return (Integer)dbConfig.get(GraphDatabaseSettings.dense_node_threshold);
            }

            public long maxMemoryUsage() {
                return maxMemory != null ? maxMemory.longValue() : DEFAULT.maxMemoryUsage();
            }
        };
    }

    private static String manualReference(ManualPage page, Anchor anchor) {
        CharSequence[] versionParts = Version.getNeo4jVersion().split("-");
        versionParts[0] = versionParts[0].substring(0, 3);
        String docsVersion = String.join((CharSequence)"-", versionParts);
        return " https://neo4j.com/docs/operations-manual/" + docsVersion + "/" + page.getReference(anchor);
    }

    private static RuntimeException andPrintError(String typeOfError, Exception e, boolean stackTrace, PrintStream err) {
        if (DuplicateInputIdException.class.equals(e.getClass())) {
            ImportTool.printErrorMessage("Duplicate input ids that would otherwise clash can be put into separate id space, read more about how to use id spaces in the manual:" + ImportTool.manualReference(ManualPage.IMPORT_TOOL_FORMAT, Anchor.ID_SPACES), e, stackTrace, err);
        } else if (MissingRelationshipDataException.class.equals(e.getClass())) {
            ImportTool.printErrorMessage("Relationship missing mandatory field '" + ((MissingRelationshipDataException)e).getFieldType() + "', read more about relationship format in the manual: " + ImportTool.manualReference(ManualPage.IMPORT_TOOL_FORMAT, Anchor.RELATIONSHIP), e, stackTrace, err);
        } else if (Exceptions.contains((Throwable)e, (Class[])new Class[]{IllegalMultilineFieldException.class})) {
            ImportTool.printErrorMessage("Detected field which spanned multiple lines for an import where " + Options.MULTILINE_FIELDS.argument() + "=false. If you know that your input data include fields containing new-line characters then import with this option set to true.", e, stackTrace, err);
        } else if (Exceptions.contains((Throwable)e, (Class[])new Class[]{InputException.class})) {
            ImportTool.printErrorMessage("Error in input data", e, stackTrace, err);
        } else {
            ImportTool.printErrorMessage(typeOfError + ": " + e.getMessage(), e, true, err);
        }
        err.println();
        Thread.currentThread().setUncaughtExceptionHandler((t, e1) -> {});
        return Exceptions.launderedException((Throwable)e);
    }

    private static void printErrorMessage(String string, Exception e, boolean stackTrace, PrintStream err) {
        err.println(string);
        err.println("Caused by:" + e.getMessage());
        if (stackTrace) {
            e.printStackTrace(err);
        }
    }

    public static Iterable<DataFactory<InputRelationship>> relationshipData(final Charset encoding, Collection<Args.Option<File[]>> relationshipsFiles) {
        return new IterableWrapper<DataFactory<InputRelationship>, Args.Option<File[]>>(relationshipsFiles){

            protected DataFactory<InputRelationship> underlyingObjectToObject(Args.Option<File[]> group) {
                return DataFactories.data((Decorator)InputEntityDecorators.defaultRelationshipType((String)group.metadata()), (Charset)encoding, (File[])((File[])group.value()));
            }
        };
    }

    public static Iterable<DataFactory<InputNode>> nodeData(final Charset encoding, Collection<Args.Option<File[]>> nodesFiles) {
        return new IterableWrapper<DataFactory<InputNode>, Args.Option<File[]>>(nodesFiles){

            protected DataFactory<InputNode> underlyingObjectToObject(Args.Option<File[]> input) {
                Decorator decorator = input.metadata() != null ? InputEntityDecorators.additiveLabels((String[])input.metadata().split(":")) : InputEntityDecorators.NO_NODE_DECORATOR;
                return DataFactories.data((Decorator)decorator, (Charset)encoding, (File[])((File[])input.value()));
            }
        };
    }

    private static void printUsage(PrintStream out) {
        out.println("Neo4j Import Tool");
        for (String string : Args.splitLongLine((String)"neo4j-import is used to create a new Neo4j database from data in CSV files. See the chapter \"Import Tool\" in the Neo4j Manual for details on the CSV file format - a special kind of header is required.", (int)80)) {
            out.println("\t" + string);
        }
        out.println("Usage:");
        for (Options options : Options.values()) {
            options.printUsage(out);
        }
        out.println("Example:");
        out.print(Strings.joinAsLines((String[])new String[]{"\tbin/neo4j-import --into retail.db --id-type string --nodes:Customer customers.csv ", "\t--nodes products.csv --nodes orders_header.csv,orders1.csv,orders2.csv ", "\t--relationships:CONTAINS order_details.csv ", "\t--relationships:ORDERED customer_orders_header.csv,orders1.csv,orders2.csv"}));
    }

    private static boolean asksForUsage(Args args) {
        for (String string : args.orphans()) {
            if (!ImportTool.isHelpKey(string)) continue;
            return true;
        }
        for (Map.Entry entry : args.asMap().entrySet()) {
            if (!ImportTool.isHelpKey((String)entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static boolean isHelpKey(String key) {
        return key.equals("?") || key.equals("help");
    }

    public static org.neo4j.unsafe.impl.batchimport.input.csv.Configuration csvConfiguration(Args args, final boolean defaultSettingsSuitableForTests) {
        final org.neo4j.unsafe.impl.batchimport.input.csv.Configuration defaultConfiguration = org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS;
        final Character specificDelimiter = (Character)args.interpretOption(Options.DELIMITER.key(), Converters.optional(), CHARACTER_CONVERTER, new Validator[0]);
        final Character specificArrayDelimiter = (Character)args.interpretOption(Options.ARRAY_DELIMITER.key(), Converters.optional(), CHARACTER_CONVERTER, new Validator[0]);
        final Character specificQuote = (Character)args.interpretOption(Options.QUOTE.key(), Converters.optional(), CHARACTER_CONVERTER, new Validator[0]);
        final Boolean multiLineFields = args.getBoolean(Options.MULTILINE_FIELDS.key(), null);
        final Boolean emptyStringsAsNull = args.getBoolean(Options.IGNORE_EMPTY_STRINGS.key(), null);
        final Boolean trimStrings = args.getBoolean(Options.TRIM_STRINGS.key(), null);
        final Boolean legacyStyleQuoting = args.getBoolean(Options.LEGACY_STYLE_QUOTING.key(), null);
        final Long bufferSize = args.has(Options.READ_BUFFER_SIZE.key()) ? Long.valueOf(Settings.parseLongWithUnit((String)args.get(Options.READ_BUFFER_SIZE.key(), null))) : null;
        return new Configuration.Default(){

            public char delimiter() {
                return specificDelimiter != null ? specificDelimiter.charValue() : defaultConfiguration.delimiter();
            }

            public char arrayDelimiter() {
                return specificArrayDelimiter != null ? specificArrayDelimiter.charValue() : defaultConfiguration.arrayDelimiter();
            }

            public char quotationCharacter() {
                return specificQuote != null ? specificQuote.charValue() : defaultConfiguration.quotationCharacter();
            }

            public boolean multilineFields() {
                return multiLineFields != null ? multiLineFields.booleanValue() : defaultConfiguration.multilineFields();
            }

            public boolean emptyQuotedStringsAsNull() {
                return emptyStringsAsNull != null ? emptyStringsAsNull.booleanValue() : defaultConfiguration.emptyQuotedStringsAsNull();
            }

            public int bufferSize() {
                return bufferSize != null ? bufferSize.intValue() : (defaultSettingsSuitableForTests ? 10000 : super.bufferSize());
            }

            public boolean trimStrings() {
                return trimStrings != null ? trimStrings.booleanValue() : defaultConfiguration.trimStrings();
            }

            public boolean legacyStyleQuoting() {
                return legacyStyleQuoting != null ? legacyStyleQuoting.booleanValue() : defaultConfiguration.legacyStyleQuoting();
            }
        };
    }

    private static enum Anchor {
        ID_SPACES("import-tool-id-spaces"),
        RELATIONSHIP("import-tool-header-format-rels");

        private final String anchor;

        private Anchor(String anchor) {
            this.anchor = anchor;
        }
    }

    private static enum ManualPage {
        IMPORT_TOOL_FORMAT("tools/import/file-header-format/");

        private final String page;

        private ManualPage(String page) {
            this.page = page;
        }

        public String getReference(Anchor anchor) {
            return this.page + "#" + anchor.anchor;
        }
    }

    static enum Options {
        STORE_DIR("into", null, "<store-dir>", "Database directory to import into. Must not contain existing database."),
        DB_NAME("database", null, "<database-name>", "Database name to import into. Must not contain existing database.", true),
        NODE_DATA("nodes", null, "[:Label1:Label2] \"<file1>,<file2>,...\"", "Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks. Each file can be a regular expression and will then include all matching files. The file matching is done with number awareness such that e.g. files:'File1Part_001.csv', 'File12Part_003' will be ordered in that order for a pattern like: 'File.*'", true, true),
        RELATIONSHIP_DATA("relationships", null, "[:RELATIONSHIP_TYPE] \"<file1>,<file2>,...\"", "Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks. Each file can be a regular expression and will then include all matching files. The file matching is done with number awareness such that e.g. files:'File1Part_001.csv', 'File12Part_003' will be ordered in that order for a pattern like: 'File.*'", true, true),
        DELIMITER("delimiter", null, "<delimiter-character>", "Delimiter character, or 'TAB', between values in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.delimiter() + "`."),
        ARRAY_DELIMITER("array-delimiter", null, "<array-delimiter-character>", "Delimiter character, or 'TAB', between array elements within a value in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.arrayDelimiter() + "`."),
        QUOTE("quote", null, "<quotation-character>", "Character to treat as quotation character for values in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.quotationCharacter() + "`. Quotes inside quotes escaped like `\"\"\"Go away\"\", he said.\"` and `\"\\\"Go away\\\", he said.\"` are supported. If you have set \"`'`\" to be used as the quotation character, you could write the previous example like this instead: `'\"Go away\", he said.'`"),
        MULTILINE_FIELDS("multiline-fields", Configuration.DEFAULT.multilineFields(), "<true/false>", "Whether or not fields from input source can span multiple lines, i.e. contain newline characters."),
        TRIM_STRINGS("trim-strings", Configuration.DEFAULT.trimStrings(), "<true/false>", "Whether or not strings should be trimmed for whitespaces."),
        INPUT_ENCODING("input-encoding", null, "<character set>", "Character set that input data is encoded in. Provided value must be one out of the available character sets in the JVM, as provided by Charset#availableCharsets(). If no input encoding is provided, the default character set of the JVM will be used.", true),
        IGNORE_EMPTY_STRINGS("ignore-empty-strings", Configuration.DEFAULT.emptyQuotedStringsAsNull(), "<true/false>", "Whether or not empty string fields, i.e. \"\" from input source are ignored, i.e. treated as null."),
        ID_TYPE("id-type", IdType.STRING, "<id-type>", "One out of " + Arrays.toString(IdType.values()) + " and specifies how ids in node/relationship input files are treated.\n" + IdType.STRING + ": arbitrary strings for identifying nodes.\n" + IdType.INTEGER + ": arbitrary integer values for identifying nodes.\n" + IdType.ACTUAL + ": (advanced) actual node ids. The default option is `" + IdType.STRING + "`.", true),
        PROCESSORS("processors", null, "<max processor count>", "(advanced) Max number of processors used by the importer. Defaults to the number of available processors reported by the JVM" + Options.availableProcessorsHint() + ". There is a certain amount of minimum threads needed so for that reason there is no lower bound for this value. For optimal performance this value shouldn't be greater than the number of available processors."),
        STACKTRACE("stacktrace", false, "<true/false>", "Enable printing of error stack traces."),
        BAD_TOLERANCE("bad-tolerance", 1000, "<max number of bad entries, or true for unlimited>", "Number of bad entries before the import is considered failed. This tolerance threshold is about relationships refering to missing nodes. Format errors in input data are still treated as errors"),
        SKIP_BAD_ENTRIES_LOGGING("skip-bad-entries-logging", Boolean.FALSE, "<true/false>", "Whether or not to skip logging bad entries detected during import."),
        SKIP_BAD_RELATIONSHIPS("skip-bad-relationships", Boolean.TRUE, "<true/false>", "Whether or not to skip importing relationships that refers to missing node ids, i.e. either start or end node id/group referring to node that wasn't specified by the node input data. Skipped nodes will be logged, containing at most number of entites specified by " + BAD_TOLERANCE.key() + ", unless otherwise specified by " + SKIP_BAD_ENTRIES_LOGGING.key() + " option."),
        SKIP_DUPLICATE_NODES("skip-duplicate-nodes", Boolean.FALSE, "<true/false>", "Whether or not to skip importing nodes that have the same id/group. In the event of multiple nodes within the same group having the same id, the first encountered will be imported whereas consecutive such nodes will be skipped. Skipped nodes will be logged, containing at most number of entities specified by " + BAD_TOLERANCE.key() + ", unless otherwise specified by " + SKIP_BAD_ENTRIES_LOGGING.key() + "option."),
        IGNORE_EXTRA_COLUMNS("ignore-extra-columns", Boolean.FALSE, "<true/false>", "Whether or not to ignore extra columns in the data not specified by the header. Skipped columns will be logged, containing at most number of entities specified by " + BAD_TOLERANCE.key() + ", unless otherwise specified by " + SKIP_BAD_ENTRIES_LOGGING.key() + "option."),
        DATABASE_CONFIG("db-config", null, "<path/to/neo4j.conf>", "(advanced) File specifying database-specific configuration. For more information consult manual about available configuration options for a neo4j configuration file. Only configuration affecting store at time of creation will be read. Examples of supported config are:\n" + GraphDatabaseSettings.dense_node_threshold.name() + "\n" + GraphDatabaseSettings.string_block_size.name() + "\n" + GraphDatabaseSettings.array_block_size.name()),
        ADDITIONAL_CONFIG("additional-config", null, "<path/to/neo4j.conf>", "(advanced) File specifying database-specific configuration. For more information consult manual about available configuration options for a neo4j configuration file. Only configuration affecting store at time of creation will be read. Examples of supported config are:\n" + GraphDatabaseSettings.dense_node_threshold.name() + "\n" + GraphDatabaseSettings.string_block_size.name() + "\n" + GraphDatabaseSettings.array_block_size.name(), true),
        LEGACY_STYLE_QUOTING("legacy-style-quoting", true, "<true/false>", "Whether or not backslash-escaped quote e.g. \\\" is interpreted as inner quote."),
        READ_BUFFER_SIZE("read-buffer-size", Configuration.DEFAULT.bufferSize(), "<bytes, e.g. 10k, 4M>", "Size of each buffer for reading input data. It has to at least be large enough to hold the biggest single value in the input data."),
        MAX_MEMORY("max-memory", null, "<max memory that importer can use>", "(advanced) Maximum memory that importer can use for various data structures and caching to improve performance. If left as unspecified (null) it is set to 90% of (free memory on machine - max JVM memory). Values can be plain numbers, like 10000000 or e.g. 20G for 20 gigabyte, or even e.g. 70%.");

        private final String key;
        private final Object defaultValue;
        private final String usage;
        private final String description;
        private final boolean keyAndUsageGoTogether;
        private final boolean supported;

        private Options(String key, Object defaultValue, String usage, String description) {
            this(key, defaultValue, usage, description, false, false);
        }

        private Options(String key, Object defaultValue, String usage, String description, boolean supported) {
            this(key, defaultValue, usage, description, supported, false);
        }

        private Options(String key, Object defaultValue, String usage, String description, boolean supported, boolean keyAndUsageGoTogether) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.usage = usage;
            this.description = description;
            this.supported = supported;
            this.keyAndUsageGoTogether = keyAndUsageGoTogether;
        }

        String key() {
            return this.key;
        }

        String argument() {
            return "--" + this.key();
        }

        void printUsage(PrintStream out) {
            out.println(this.argument() + this.spaceInBetweenArgumentAndUsage() + this.usage);
            for (String line : Args.splitLongLine((String)this.descriptionWithDefaultValue().replace("`", ""), (int)80)) {
                out.println("\t" + line);
            }
        }

        private String spaceInBetweenArgumentAndUsage() {
            return this.keyAndUsageGoTogether ? "" : " ";
        }

        String descriptionWithDefaultValue() {
            String result = this.description;
            if (this.defaultValue != null) {
                if (!result.endsWith(".")) {
                    result = result + ".";
                }
                result = result + " Default value: " + this.defaultValue;
            }
            return result;
        }

        String manPageEntry() {
            String filteredDescription = this.descriptionWithDefaultValue().replace(Options.availableProcessorsHint(), "");
            String usageString = this.usage.length() > 0 ? this.spaceInBetweenArgumentAndUsage() + this.usage : "";
            return "*" + this.argument() + usageString + "*::\n" + filteredDescription + "\n\n";
        }

        String manualEntry() {
            return "[[import-tool-option-" + this.key() + "]]\n" + this.manPageEntry() + "//^\n\n";
        }

        Object defaultValue() {
            return this.defaultValue;
        }

        private static String availableProcessorsHint() {
            return " (in your case " + Runtime.getRuntime().availableProcessors() + ")";
        }

        public boolean isSupportedOption() {
            return this.supported;
        }
    }
}

