/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import org.neo4j.function.Function;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;

class DelimiterConverter
implements Function<String, Character> {
    private final Function<String, Character> fallback = Converters.toCharacter();

    DelimiterConverter() {
    }

    public Character apply(String value) throws RuntimeException {
        if (value.startsWith("\\") && value.length() > 1) {
            String raw = value.substring(1);
            try {
                return Character.valueOf((char)Integer.parseInt(raw));
            }
            catch (NumberFormatException e) {
                if (raw.equals("t")) {
                    return Character.valueOf(Configuration.TABS.delimiter());
                }
                throw new IllegalArgumentException("Invalid delimiter character '" + value + "'");
            }
        }
        if (value.equals("TAB")) {
            return Character.valueOf(Configuration.TABS.delimiter());
        }
        return (Character)this.fallback.apply((Object)value);
    }
}

