/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.neo4j.function.Function;
import org.neo4j.function.Function2;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.ClassicLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class ImportTool {
    static final String MULTI_FILE_DELIMITER = ",";
    private static final Function<String, IdType> TO_ID_TYPE = new Function<String, IdType>(){

        public IdType apply(String from) {
            return IdType.valueOf((String)from.toUpperCase());
        }
    };
    private static final Function<String, Character> DELIMITER_CONVERTER = new Function<String, Character>(){
        private final Function<String, Character> fallback = Converters.toCharacter();

        public Character apply(String value) throws RuntimeException {
            if (value.equals("TAB")) {
                return Character.valueOf('\t');
            }
            return (Character)this.fallback.apply((Object)value);
        }
    };
    private static final Function2<Args, String, Collection<Args.Option<File[]>>> INPUT_FILES_EXTRACTOR = new Function2<Args, String, Collection<Args.Option<File[]>>>(){

        public Collection<Args.Option<File[]>> apply(Args args, String key) {
            return args.interpretOptionsWithMetadata(key, Converters.optional(), Converters.toFiles((String)ImportTool.MULTI_FILE_DELIMITER), new Validator[]{Validators.FILES_EXISTS, Validators.atLeast((int)1)});
        }
    };

    public static void main(String[] incomingArguments) {
        ImportTool.main(incomingArguments, false);
    }

    public static void main(String[] incomingArguments, boolean defaultSettingsSuitableForTests) {
        String badFileName;
        boolean enableStacktrace;
        File storeDir;
        Args args = Args.parse((String[])incomingArguments);
        if (ImportTool.asksForUsage(args)) {
            ImportTool.printUsage(System.out);
            return;
        }
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        Number processors = null;
        CsvInput input = null;
        try {
            storeDir = (File)args.interpretOption(Options.STORE_DIR.key(), Converters.mandatory(), Converters.toFile(), new Validator[]{Validators.DIRECTORY_IS_WRITABLE, Validators.CONTAINS_NO_EXISTING_DATABASE});
            Collection nodesFiles = (Collection)INPUT_FILES_EXTRACTOR.apply((Object)args, (Object)Options.NODE_DATA.key());
            Collection relationshipsFiles = (Collection)INPUT_FILES_EXTRACTOR.apply((Object)args, (Object)Options.RELATIONSHIP_DATA.key());
            enableStacktrace = args.getBoolean(Options.STACKTRACE.key(), Boolean.FALSE, Boolean.TRUE);
            processors = args.getNumber(Options.PROCESSORS.key(), null);
            IdType idType = (IdType)args.interpretOption(Options.ID_TYPE.key(), Converters.withDefault((Object)((IdType)Options.ID_TYPE.defaultValue())), TO_ID_TYPE, new Validator[0]);
            int badTolerance = args.getNumber(Options.BAD_TOLERANCE.key, (Number)Options.BAD_TOLERANCE.defaultValue()).intValue();
            badFileName = args.get(Options.BAD.key);
            input = new CsvInput(ImportTool.nodeData(nodesFiles), DataFactories.defaultFormatNodeFileHeader(), ImportTool.relationshipData(relationshipsFiles), DataFactories.defaultFormatRelationshipFileHeader(), idType, ImportTool.csvConfiguration(args, defaultSettingsSuitableForTests), Collectors.badRelationships((int)badTolerance));
        }
        catch (IllegalArgumentException e) {
            throw ImportTool.andPrintError("Input error", e, false);
        }
        LifeSupport life = new LifeSupport();
        Logging logging = (Logging)life.add((Object)new ClassicLoggingService(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), storeDir.getAbsolutePath()}))));
        life.start();
        Configuration config = ImportTool.importConfiguration(processors, badFileName, defaultSettingsSuitableForTests);
        ParallelBatchImporter importer = new ParallelBatchImporter(storeDir.getPath(), config, logging, ExecutionMonitors.defaultVisible());
        boolean success = false;
        try {
            importer.doImport((Input)input);
            success = true;
        }
        catch (Exception e) {
            throw ImportTool.andPrintError("Import error", e, enableStacktrace);
        }
        finally {
            block15: {
                File badRelationships = config.badFile(storeDir);
                if (badRelationships.exists()) {
                    System.out.println("There were bad relationships which were skipped and logged into " + badRelationships.getAbsolutePath());
                }
                life.shutdown();
                if (!success) {
                    try {
                        StoreFile.fileOperation((FileOperation)FileOperation.DELETE, (FileSystemAbstraction)fs, (File)storeDir, null, (Iterable)Iterables.iterable((Object[])StoreFile.values()), (boolean)false, (boolean)false, (StoreFileType[])StoreFileType.values());
                    }
                    catch (IOException e) {
                        System.err.println("Unable to delete store files after an aborted import " + e);
                        if (!enableStacktrace) break block15;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static Configuration importConfiguration(final Number processors, final String badFileName, final boolean defaultSettingsSuitableForTests) {
        return new Configuration.Default(){

            public int maxNumberOfProcessors() {
                return processors != null ? processors.intValue() : super.maxNumberOfProcessors();
            }

            public File badFile(File storeDirectory) {
                if (badFileName == null) {
                    return super.badFile(storeDirectory);
                }
                File part = new File(badFileName);
                return part.isAbsolute() ? part : new File(storeDirectory, badFileName);
            }

            public int bigFileChannelBufferSizeMultiplier() {
                return defaultSettingsSuitableForTests ? 1 : super.bigFileChannelBufferSizeMultiplier();
            }
        };
    }

    private static RuntimeException andPrintError(String typeOfError, Exception e, boolean stackTrace) {
        System.err.println(typeOfError + ": " + e.getMessage());
        if (stackTrace) {
            e.printStackTrace(System.err);
        }
        System.err.println();
        ImportTool.printUsage(System.err);
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
            }
        });
        return Exceptions.launderedException((Throwable)e);
    }

    private static Iterable<DataFactory<InputRelationship>> relationshipData(Collection<Args.Option<File[]>> relationshipsFiles) {
        return new IterableWrapper<DataFactory<InputRelationship>, Args.Option<File[]>>(relationshipsFiles){

            protected DataFactory<InputRelationship> underlyingObjectToObject(Args.Option<File[]> group) {
                return DataFactories.data((Function)InputEntityDecorators.defaultRelationshipType((String)group.metadata()), (File[])((File[])group.value()));
            }
        };
    }

    private static Iterable<DataFactory<InputNode>> nodeData(Collection<Args.Option<File[]>> nodesFiles) {
        return new IterableWrapper<DataFactory<InputNode>, Args.Option<File[]>>(nodesFiles){

            protected DataFactory<InputNode> underlyingObjectToObject(Args.Option<File[]> input) {
                Function decorator = input.metadata() != null ? InputEntityDecorators.additiveLabels((String[])input.metadata().split(":")) : InputEntityDecorators.NO_NODE_DECORATOR;
                return DataFactories.data((Function)decorator, (File[])((File[])input.value()));
            }
        };
    }

    private static void printUsage(PrintStream out) {
        out.println("Neo4j Import Tool");
        for (String string : Args.splitLongLine((String)"neo4j-import is used to create a new Neo4j database from data in CSV files. See the chapter \"Import Tool\" in the Neo4j Manual for details on the CSV file format - a special kind of header is required.", (int)80)) {
            out.println("\t" + string);
        }
        out.println("Usage:");
        for (Options options : Options.values()) {
            options.printUsage(out);
        }
    }

    private static boolean asksForUsage(Args args) {
        for (String string : args.orphans()) {
            if (!ImportTool.isHelpKey(string)) continue;
            return true;
        }
        for (Map.Entry entry : args.asMap().entrySet()) {
            if (!ImportTool.isHelpKey((String)entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static boolean isHelpKey(String key) {
        return key.equals("?") || key.equals("help");
    }

    private static org.neo4j.unsafe.impl.batchimport.input.csv.Configuration csvConfiguration(Args args, final boolean defaultSettingsSuitableForTests) {
        final org.neo4j.unsafe.impl.batchimport.input.csv.Configuration defaultConfiguration = org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS;
        final Character specificDelimiter = (Character)args.interpretOption(Options.DELIMITER.key(), Converters.optional(), DELIMITER_CONVERTER, new Validator[0]);
        final Character specificArrayDelimiter = (Character)args.interpretOption(Options.ARRAY_DELIMITER.key(), Converters.optional(), DELIMITER_CONVERTER, new Validator[0]);
        final Character specificQuote = (Character)args.interpretOption(Options.QUOTE.key(), Converters.optional(), Converters.toCharacter(), new Validator[0]);
        return new Configuration.Default(){

            public char delimiter() {
                return specificDelimiter != null ? specificDelimiter.charValue() : defaultConfiguration.delimiter();
            }

            public char arrayDelimiter() {
                return specificArrayDelimiter != null ? specificArrayDelimiter.charValue() : defaultConfiguration.arrayDelimiter();
            }

            public char quotationCharacter() {
                return specificQuote != null ? specificQuote.charValue() : defaultConfiguration.quotationCharacter();
            }

            public int bufferSize() {
                return defaultSettingsSuitableForTests ? 10000 : super.bufferSize();
            }
        };
    }

    static enum Options {
        STORE_DIR("into", null, "<store-dir>", "Database directory to import into. Must not contain existing database."),
        NODE_DATA("nodes", null, "[:Label1:Label2] \"<file1>,<file2>,...\"", "Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks."),
        RELATIONSHIP_DATA("relationships", null, "[:RELATIONSHIP_TYPE] \"<file1>,<file2>,...\"", "Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks."),
        DELIMITER("delimiter", null, "<delimiter-character>", "Delimiter character, or 'TAB', between values in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.delimiter() + "`."),
        ARRAY_DELIMITER("array-delimiter", null, "<array-delimiter-character>", "Delimiter character, or 'TAB', between array elements within a value in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.arrayDelimiter() + "`."),
        QUOTE("quote", null, "<quotation-character>", "Character to treat as quotation character for values in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.quotationCharacter() + "`. " + "Quotes inside quotes escaped like `\"\"\"Go away\"\", he said.\"` and " + "`\"\\\"Go away\\\", he said.\"` are supported. " + "If you have set \"`'`\" to be used as the quotation character, " + "you could write the previous example like this instead: " + "`'\"Go away\", he said.'`"),
        ID_TYPE("id-type", IdType.STRING, "<id-type>", "One out of " + Arrays.toString(IdType.values()) + " and specifies how ids in node/relationship " + "input files are treated.\n" + IdType.STRING + ": arbitrary strings for identifying nodes.\n" + IdType.INTEGER + ": arbitrary integer values for identifying nodes.\n" + IdType.ACTUAL + ": (advanced) actual node ids. The default option is `" + IdType.STRING + "`."),
        PROCESSORS("processors", null, "<max processor count>", "(advanced) Max number of processors used by the importer. Defaults to the number of available processors reported by the JVM" + Options.availableProcessorsHint() + ". There is a certain amount of minimum threads needed so for that reason there " + "is no lower bound for this value. For optimal performance this value shouldn't be " + "greater than the number of available processors."),
        STACKTRACE("stacktrace", null, "", "Enable printing of error stack traces."),
        BAD("bad", null, "<file name>", "Relationships that refer to nodes that cannot be found can, instead of making the import fail, be logged to a file specified by this option. Can be relative (to store directory) or absolute"),
        BAD_TOLERANCE("bad-tolerance", 1000, "<max number of bad entries>", "Number of bad entries before the import is considered failed. This tolerance threshold is about relationships refering to missing nodes. Format errors in input data are still treated as errors");

        private final String key;
        private final Object defaultValue;
        private final String usage;
        private final String description;

        private Options(String key, Object defaultValue, String usage, String description) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.usage = usage;
            this.description = description;
        }

        String key() {
            return this.key;
        }

        String argument() {
            return "--" + this.key();
        }

        void printUsage(PrintStream out) {
            out.println(this.argument() + " " + this.usage);
            for (String line : Args.splitLongLine((String)this.descriptionWithDefaultValue().replace("`", ""), (int)80)) {
                out.println("\t" + line);
            }
        }

        String descriptionWithDefaultValue() {
            String result = this.description;
            if (this.defaultValue != null) {
                if (!result.endsWith(".")) {
                    result = result + ". ";
                }
                result = result + "Default value: " + this.defaultValue;
            }
            return result;
        }

        String manPageEntry() {
            String filteredDescription = this.descriptionWithDefaultValue().replace(Options.availableProcessorsHint(), "");
            String usageString = this.usage.length() > 0 ? " " + this.usage : "";
            return "*" + this.argument() + usageString + "*::\n" + filteredDescription + "\n\n";
        }

        Object defaultValue() {
            return this.defaultValue;
        }

        private static String availableProcessorsHint() {
            return " (in your case " + Runtime.getRuntime().availableProcessors() + ")";
        }
    }
}

