/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;

class DynamicConcurrentLongQueue
implements ConcurrentLongQueue {
    private final AtomicReference<Chunk> head;
    private final AtomicReference<Chunk> tail;
    private final AtomicInteger numChunks = new AtomicInteger(1);
    private final int chunkSize;
    private final int maxNumChunks;

    DynamicConcurrentLongQueue(int chunkSize, int maxNumChunks) {
        this.chunkSize = chunkSize;
        this.maxNumChunks = maxNumChunks;
        Chunk chunk = new Chunk(chunkSize);
        this.head = new AtomicReference<Chunk>(chunk);
        this.tail = new AtomicReference<Chunk>(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(long v) {
        Chunk chunk = this.tail.get();
        if (!chunk.offer(v)) {
            DynamicConcurrentLongQueue dynamicConcurrentLongQueue = this;
            synchronized (dynamicConcurrentLongQueue) {
                chunk = this.tail.get();
                if (!chunk.offer(v)) {
                    if (this.numChunks.get() >= this.maxNumChunks) {
                        return false;
                    }
                    Chunk next = new Chunk(this.chunkSize);
                    boolean accepted = next.offer(v);
                    assert (accepted);
                    chunk.next.set(next);
                    this.tail.set(next);
                    this.numChunks.incrementAndGet();
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public long takeOrDefault(long defaultValue) {
        Chunk next;
        do {
            Chunk chunk = this.head.get();
            next = chunk.next.get();
            long candidate = chunk.takeOrDefault(defaultValue);
            if (candidate != defaultValue) {
                return candidate;
            }
            if (next == null || !this.head.compareAndSet(chunk, next)) continue;
            this.numChunks.decrementAndGet();
        } while (next != null);
        return defaultValue;
    }

    @Override
    public long takeInRange(long minBoundary, long maxBoundary) {
        Chunk next;
        do {
            Chunk chunk = this.head.get();
            next = chunk.next.get();
            long candidate = chunk.takeInRange(minBoundary, maxBoundary);
            if (candidate >= 0L && candidate < maxBoundary) {
                return candidate;
            }
            if (candidate > maxBoundary) {
                return Long.MAX_VALUE;
            }
            if (candidate != -1L || next == null || !this.head.compareAndSet(chunk, next)) continue;
            this.numChunks.decrementAndGet();
        } while (next != null);
        return Long.MAX_VALUE;
    }

    private int capacity() {
        return this.chunkSize * this.maxNumChunks;
    }

    @Override
    public int size() {
        int size;
        Chunk firstChunk;
        do {
            firstChunk = this.head.get();
            size = firstChunk.size();
            int numChunks = this.numChunks.get();
            if (numChunks <= 1) continue;
            size += (numChunks - 2) * this.chunkSize;
            size += this.tail.get().size();
        } while (firstChunk != this.head.get());
        return size;
    }

    @Override
    public int availableSpace() {
        int capacity = this.capacity();
        Chunk lastChunk = this.tail.get();
        int occupied = (this.numChunks.get() - 1) * this.chunkSize + lastChunk.occupied();
        return capacity - occupied;
    }

    @Override
    public void clear() {
        Chunk chunk = new Chunk(this.chunkSize);
        this.head.set(chunk);
        this.tail.set(chunk);
    }

    private static class Chunk {
        private static final long EMPTY_VALUE = -1L;
        private final AtomicLongArray array;
        private final int capacity;
        private final AtomicInteger readSeq = new AtomicInteger();
        private final AtomicInteger writeSeq = new AtomicInteger();
        private final AtomicReference<Chunk> next = new AtomicReference();

        Chunk(int capacity) {
            long[] internalArray = new long[capacity];
            Arrays.fill(internalArray, -1L);
            this.array = new AtomicLongArray(internalArray);
            this.capacity = capacity;
        }

        boolean offer(long v) {
            int currentWriteSeq;
            assert (v != -1L);
            do {
                if ((currentWriteSeq = this.writeSeq.get()) != this.capacity) continue;
                return false;
            } while (!this.writeSeq.compareAndSet(currentWriteSeq, currentWriteSeq + 1));
            this.array.set(currentWriteSeq, v);
            return true;
        }

        long takeInRange(long minBoundary, long maxBoundary) {
            long value;
            int currentReadSeq;
            do {
                int currentWriteSeq;
                if ((currentReadSeq = this.readSeq.get()) == (currentWriteSeq = this.writeSeq.get())) {
                    return -1L;
                }
                value = this.array.get(currentReadSeq);
                if (value < maxBoundary && value >= minBoundary) continue;
                return Long.MAX_VALUE;
            } while (!this.readSeq.compareAndSet(currentReadSeq, currentReadSeq + 1));
            return value;
        }

        long takeOrDefault(long defaultValue) {
            int currentReadSeq;
            long value;
            do {
                int currentWriteSeq;
                if ((currentReadSeq = this.readSeq.get()) != (currentWriteSeq = this.writeSeq.get())) continue;
                return defaultValue;
            } while ((value = this.array.get(currentReadSeq)) == -1L || !this.readSeq.compareAndSet(currentReadSeq, currentReadSeq + 1));
            return value;
        }

        int size() {
            return Math.max(0, this.writeSeq.intValue() - this.readSeq.intValue());
        }

        int occupied() {
            return this.writeSeq.intValue();
        }
    }
}

