/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.internal.id.indexed.IdCache;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.MarkerProvider;
import org.neo4j.internal.id.indexed.ScanLock;
import org.neo4j.io.pagecache.context.CursorContext;

class FreeIdScanner {
    private static final IdRangeKey LOW_KEY = new IdRangeKey(0L);
    private static final IdRangeKey HIGH_KEY = new IdRangeKey(Long.MAX_VALUE);
    static final int MAX_SLOT_SIZE = 128;
    private final int idsPerEntry;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final IdRangeLayout layout;
    private final IdCache cache;
    private final AtomicBoolean atLeastOneIdOnFreelist;
    private final MarkerProvider markerProvider;
    private final long generation;
    private final ScanLock lock;
    private final IndexedIdGenerator.Monitor monitor;
    private final ConcurrentLinkedQueue<Long> queuedSkippedHighIds = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Long> queuedWastedCachedIds = new ConcurrentLinkedQueue();
    private volatile Long ongoingScanRangeIndex;
    private final AtomicLong numBufferedIds = new AtomicLong();
    private volatile boolean allocationEnabled;
    private final boolean useDirectToCache;

    FreeIdScanner(int idsPerEntry, GBPTree<IdRangeKey, IdRange> tree, IdRangeLayout layout, IdCache cache, AtomicBoolean atLeastOneIdOnFreelist, MarkerProvider markerProvider, long generation, boolean strictlyPrioritizeFreelistOverHighId, IndexedIdGenerator.Monitor monitor, boolean allocationEnabled, boolean useDirectToCache) {
        this.idsPerEntry = idsPerEntry;
        this.tree = tree;
        this.layout = layout;
        this.cache = cache;
        this.atLeastOneIdOnFreelist = atLeastOneIdOnFreelist;
        this.markerProvider = markerProvider;
        this.generation = generation;
        this.lock = strictlyPrioritizeFreelistOverHighId ? ScanLock.lockyAndPessimistic() : ScanLock.lockFreeAndOptimistic();
        this.monitor = monitor;
        this.allocationEnabled = allocationEnabled;
        this.useDirectToCache = useDirectToCache;
    }

    void tryLoadFreeIdsIntoCache(boolean blocking, boolean maintenance, CursorContext cursorContext) {
        if (!this.hasMoreFreeIds(maintenance)) {
            return;
        }
        if (this.scanLock(blocking)) {
            try {
                MutableLongList pendingIdQueue;
                MutableInt availableSpaceById;
                if (!this.allocationEnabled) {
                    return;
                }
                this.handleQueuedIds(cursorContext);
                if (this.shouldFindFreeIdsByScan() && (availableSpaceById = new MutableInt(this.cache.availableSpaceById())).intValue() > 0 && this.findSomeIdsToCache(pendingIdQueue = LongLists.mutable.empty(), availableSpaceById, cursorContext)) {
                    this.reserveAndOfferToCache(pendingIdQueue, cursorContext);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void handleQueuedIds(CursorContext cursorContext) {
        if (!this.queuedSkippedHighIds.isEmpty() || !this.queuedWastedCachedIds.isEmpty()) {
            try (IdGenerator.ContextualMarker marker = this.markerProvider.getMarker(cursorContext);){
                this.handleQueuedIds(marker, cursorContext);
            }
        }
    }

    private void handleQueuedIds(IdGenerator.ContextualMarker marker, CursorContext cursorContext) {
        this.consumeQueuedIds(this.queuedSkippedHighIds, marker, IdGenerator.ContextualMarker::markFree, cursorContext);
        this.consumeQueuedIds(this.queuedWastedCachedIds, marker, (mark, id, size) -> {
            int accepted = this.cache.offer(id, size, this.monitor);
            if (accepted < size) {
                mark.markUncached(id + (long)accepted, size - accepted);
            }
        }, cursorContext);
    }

    private void consumeQueuedIds(ConcurrentLinkedQueue<Long> queue, IdGenerator.ContextualMarker marker, QueueConsumer consumer, CursorContext cursorContext) {
        if (!queue.isEmpty()) {
            Long idAndSize;
            while ((idAndSize = queue.poll()) != null) {
                long id = IdUtils.idFromCombinedId(idAndSize);
                int size = IdUtils.numberOfIdsFromCombinedId(idAndSize);
                consumer.accept(marker, id, size);
            }
        }
    }

    boolean hasMoreFreeIds(boolean maintenance) {
        if (!this.allocationEnabled) {
            return false;
        }
        int numBufferedIdsThreshold = maintenance ? 1 : 1000;
        return this.shouldFindFreeIdsByScan() || this.numBufferedIds.get() >= (long)numBufferedIdsThreshold;
    }

    private boolean shouldFindFreeIdsByScan() {
        return this.ongoingScanRangeIndex != null || this.atLeastOneIdOnFreelist.get();
    }

    private boolean scanLock(boolean blocking) {
        if (blocking) {
            this.lock.lock();
            return true;
        }
        return this.lock.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(boolean allocationWillBeEnabled, CursorContext cursorContext) {
        this.lock.lock();
        try {
            this.ongoingScanRangeIndex = null;
            if (this.allocationEnabled) {
                try (IdGenerator.ContextualMarker marker = this.markerProvider.getMarker(cursorContext);){
                    this.handleQueuedIds(marker, cursorContext);
                    this.cache.drain(marker::markUncached);
                }
                this.atLeastOneIdOnFreelist.set(true);
            } else {
                this.queuedSkippedHighIds.clear();
                this.queuedWastedCachedIds.clear();
                this.cache.drain((id, size) -> {});
            }
            this.allocationEnabled = allocationWillBeEnabled;
        }
        finally {
            this.lock.unlock();
        }
    }

    void queueSkippedHighId(long id, int numberOfIds) {
        this.queuedSkippedHighIds.offer(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
        this.numBufferedIds.incrementAndGet();
    }

    void queueWastedCachedId(long id, int numberOfIds) {
        this.queuedWastedCachedIds.offer(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
        this.numBufferedIds.incrementAndGet();
    }

    private void reserveAndOfferToCache(MutableLongList pendingIdQueue, CursorContext cursorContext) {
        try (IdGenerator.ContextualMarker marker = this.markerProvider.getMarker(cursorContext);){
            MutableLongIterator iterator = pendingIdQueue.longIterator();
            while (iterator.hasNext()) {
                long combinedId = iterator.next();
                long id = IdUtils.idFromCombinedId(combinedId);
                int numberOfIds = IdUtils.numberOfIdsFromCombinedId(combinedId);
                marker.markReserved(id, numberOfIds);
                int accepted = this.cache.offer(id, numberOfIds, this.monitor);
                if (accepted >= numberOfIds) continue;
                long idToUndo = id + (long)accepted;
                int numberOfIdsToUndo = numberOfIds - accepted;
                if (this.useDirectToCache) {
                    marker.markUncached(idToUndo, numberOfIdsToUndo);
                    continue;
                }
                marker.markUnreserved(idToUndo, numberOfIdsToUndo);
            }
        }
    }

    private boolean findSomeIdsToCache(MutableLongList pendingIdQueue, MutableInt availableSpaceById, CursorContext cursorContext) throws IOException {
        boolean somethingWasCached;
        boolean startedNow = this.ongoingScanRangeIndex == null;
        IdRangeKey from = this.ongoingScanRangeIndex == null ? LOW_KEY : new IdRangeKey(this.ongoingScanRangeIndex);
        boolean seekerExhausted = false;
        IdRange.FreeIdVisitor visitor = (id, numberOfIds) -> this.queueId(pendingIdQueue, availableSpaceById, id, numberOfIds);
        try (Seeker scanner = this.tree.seek((Object)from, (Object)HIGH_KEY, cursorContext);){
            while (availableSpaceById.intValue() > 0) {
                if (!scanner.next()) {
                    seekerExhausted = true;
                    break;
                }
                long baseId = ((IdRangeKey)scanner.key()).getIdRangeIdx() * (long)this.idsPerEntry;
                ((IdRange)scanner.value()).visitFreeIds(baseId, this.generation, visitor);
            }
            this.ongoingScanRangeIndex = seekerExhausted ? null : Long.valueOf(((IdRangeKey)scanner.key()).getIdRangeIdx());
        }
        boolean bl = somethingWasCached = !pendingIdQueue.isEmpty();
        if (seekerExhausted && !somethingWasCached && startedNow) {
            this.atLeastOneIdOnFreelist.set(false);
        }
        return somethingWasCached;
    }

    private boolean queueId(MutableLongList pendingIdQueue, MutableInt availableSpaceById, long id, int numberOfIds) {
        assert (this.layout.idRangeIndex(id) == this.layout.idRangeIndex(id + (long)numberOfIds - 1L));
        pendingIdQueue.add(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
        return availableSpaceById.addAndGet(-numberOfIds) > 0;
    }

    boolean allocationEnabled() {
        return this.allocationEnabled;
    }

    private static interface QueueConsumer {
        public void accept(IdGenerator.ContextualMarker var1, long var2, int var4);
    }
}

