/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.id.indexed.FreeIdScanner;
import org.neo4j.internal.id.indexed.HeaderReader;
import org.neo4j.internal.id.indexed.HeaderWriter;
import org.neo4j.internal.id.indexed.IdCache;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.internal.id.indexed.IdRangeMarker;
import org.neo4j.internal.id.indexed.IdRangeMerger;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class IndexedIdGenerator
implements IdGenerator {
    public static final Monitor NO_MONITOR = new Monitor.Adapter();
    static final long NO_ID = -1L;
    public static final int IDS_PER_ENTRY = 128;
    static final int SMALL_CACHE_CAPACITY = 256;
    static final int LARGE_CACHE_CAPACITY = 16384;
    private static final long STARTING_GENERATION = 1L;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final IdCache cache;
    private final IdType idType;
    private final int idsPerEntry;
    private final int cacheOptimisticRefillThreshold;
    private final Lock commitAndReuseLock = new ReentrantLock();
    private final IdRangeLayout layout;
    private final FreeIdScanner scanner;
    private final AtomicLong highId = new AtomicLong();
    private final long maxId;
    private final AtomicBoolean atLeastOneIdOnFreelist = new AtomicBoolean();
    private final long generation;
    private final boolean needsRebuild;
    private final AtomicLong highestWrittenId = new AtomicLong();
    private final Path path;
    private volatile boolean started;
    private final IdRangeMerger defaultMerger;
    private final IdRangeMerger recoveryMerger;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final Monitor monitor;
    private final boolean strictlyPrioritizeFreelist;
    private final int biggestSlotSize;

    public IndexedIdGenerator(PageCache pageCache, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdType idType, boolean allowLargeIdCaches, LongSupplier initialHighId, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, String databaseName, CursorContext cursorContext, Monitor monitor, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) {
        this.path = path;
        this.readOnlyChecker = readOnlyChecker;
        int cacheCapacity = idType.highActivity() && allowLargeIdCaches ? 16384 : 256;
        this.idType = idType;
        IdSlotDistribution.Slot[] slots = slotDistribution.slots(cacheCapacity);
        this.cache = new IdCache(slots);
        this.biggestSlotSize = Arrays.stream(slots).map(IdSlotDistribution.Slot::slotSize).max((Comparator<Integer>)Comparators.naturalOrder()).orElseThrow();
        this.maxId = maxId;
        this.monitor = monitor;
        this.defaultMerger = new IdRangeMerger(false, monitor);
        this.recoveryMerger = new IdRangeMerger(true, monitor);
        Optional<HeaderReader> header = IndexedIdGenerator.readHeader(pageCache, path, databaseName, cursorContext);
        boolean bl = this.needsRebuild = header.isEmpty() || header.get().generation == 1L;
        if (!this.needsRebuild) {
            this.highId.set(header.get().highId);
            this.highestWrittenId.set(header.get().highestWrittenId);
            this.generation = header.get().generation + 1L;
            this.idsPerEntry = header.get().idsPerEntry;
            this.atLeastOneIdOnFreelist.set(true);
        } else {
            this.highId.set(initialHighId.getAsLong());
            this.highestWrittenId.set(this.highId.get() - 1L);
            this.generation = 2L;
            this.idsPerEntry = slotDistribution.idsPerEntry();
        }
        monitor.opened(this.highestWrittenId.get(), this.highId.get());
        this.layout = new IdRangeLayout(this.idsPerEntry);
        this.tree = this.instantiateTree(pageCache, path, recoveryCleanupWorkCollector, readOnlyChecker, databaseName, openOptions);
        this.strictlyPrioritizeFreelist = (Boolean)config.get(GraphDatabaseInternalSettings.strictly_prioritize_id_freelist);
        this.cacheOptimisticRefillThreshold = this.strictlyPrioritizeFreelist ? 0 : cacheCapacity / 4;
        this.scanner = new FreeIdScanner(this.idsPerEntry, this.tree, this.layout, this.cache, this.atLeastOneIdOnFreelist, context -> this.lockAndInstantiateMarker(true, context), this.generation, this.strictlyPrioritizeFreelist, monitor);
    }

    private GBPTree<IdRangeKey, IdRange> instantiateTree(PageCache pageCache, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseReadOnlyChecker readOnlyChecker, String databaseName, ImmutableSet<OpenOption> openOptions) {
        try {
            HeaderWriter headerWriter = new HeaderWriter(this.highId::get, this.highestWrittenId::get, 1L, this.idsPerEntry);
            return new GBPTree(pageCache, path, (Layout)this.layout, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, (Consumer)headerWriter, recoveryCleanupWorkCollector, readOnlyChecker, PageCacheTracer.NULL, openOptions, databaseName, "Indexed ID generator");
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Id generator file could not be found, most likely this database needs to be recovered, file:" + path, e);
        }
    }

    @Override
    public long nextId(CursorContext cursorContext) {
        long id;
        do {
            this.checkRefillCache(cursorContext);
            id = this.cache.takeOrDefault(-1L);
            if (id == -1L) continue;
            this.monitor.allocatedFromReused(id, 1);
            return id;
        } while (this.strictlyPrioritizeFreelist && this.scanner.hasMoreFreeIds(false));
        do {
            id = this.highId.getAndIncrement();
            IdValidator.assertIdWithinMaxCapacity(this.idType, id, this.maxId);
        } while (IdValidator.isReservedId(id));
        this.monitor.allocatedFromHigh(id, 1);
        return id;
    }

    @Override
    public long nextConsecutiveIdRange(int numberOfIds, boolean favorSamePage, CursorContext cursorContext) {
        int skipped;
        long id;
        long endId;
        long readHighId;
        if (numberOfIds <= this.biggestSlotSize) {
            this.checkRefillCache(cursorContext);
            long id2 = this.cache.takeOrDefault(-1L, numberOfIds, this.scanner::queueWastedCachedId);
            if (id2 != -1L) {
                this.monitor.allocatedFromReused(id2, numberOfIds);
                return id2;
            }
        }
        do {
            id = readHighId = this.highId.get();
            endId = readHighId + (long)numberOfIds - 1L;
            skipped = 0;
            if (favorSamePage && this.layout.idRangeIndex(readHighId) != this.layout.idRangeIndex(endId)) {
                long newId = this.layout.idRangeIndex(endId) * (long)this.idsPerEntry;
                skipped = (int)(newId - id);
                id = newId;
                endId = id + (long)numberOfIds - 1L;
            }
            IdValidator.assertIdWithinMaxCapacity(this.idType, endId, this.maxId);
        } while (!this.highId.compareAndSet(readHighId, endId + 1L) || IdValidator.hasReservedIdInRange(id, endId + 1L));
        this.monitor.allocatedFromHigh(id, numberOfIds);
        if (skipped > 0) {
            this.scanner.queueSkippedHighId(readHighId, skipped);
            this.monitor.skippedIdsAtHighId(id, numberOfIds);
        }
        return id;
    }

    @Override
    public IdGenerator.Marker marker(CursorContext cursorContext) {
        if (!this.started && this.needsRebuild) {
            return NOOP_MARKER;
        }
        return this.lockAndInstantiateMarker(true, cursorContext);
    }

    IdRangeMarker lockAndInstantiateMarker(boolean bridgeIdGaps, CursorContext cursorContext) {
        this.commitAndReuseLock.lock();
        try {
            return new IdRangeMarker(this.idsPerEntry, (Layout<IdRangeKey, IdRange>)this.layout, (Writer<IdRangeKey, IdRange>)this.tree.unsafeWriter(cursorContext), this.commitAndReuseLock, this.started ? this.defaultMerger : this.recoveryMerger, this.started, this.atLeastOneIdOnFreelist, this.generation, this.highestWrittenId, bridgeIdGaps, this.monitor);
        }
        catch (Exception e) {
            this.commitAndReuseLock.unlock();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.scanner, this.tree, this.monitor});
    }

    @Override
    public long getHighId() {
        return this.highId.get();
    }

    @Override
    public void setHighId(long newHighId) {
        long expect;
        while (newHighId > (expect = this.highId.get()) && !this.highId.compareAndSet(expect, newHighId)) {
        }
    }

    @Override
    public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) throws IOException {
        if (this.needsRebuild) {
            this.assertNotReadOnly();
            try (IdRangeMarker idRangeMarker = this.lockAndInstantiateMarker(false, cursorContext);){
                long highestId = freeIdsForRebuild.accept(id -> {
                    idRangeMarker.markDeleted(id, 1);
                    idRangeMarker.markFree(id, 1);
                });
                this.highId.set(highestId + 1L);
                this.highestWrittenId.set(highestId);
            }
            this.checkpoint(cursorContext);
            this.atLeastOneIdOnFreelist.set(true);
        }
        this.started = true;
        this.maintenance(cursorContext);
    }

    @Override
    public void checkpoint(CursorContext cursorContext) {
        this.tree.checkpoint((Consumer)new HeaderWriter(this.highId::get, this.highestWrittenId::get, this.generation, this.idsPerEntry), cursorContext);
        this.monitor.checkpoint(this.highestWrittenId.get(), this.highId.get());
    }

    @Override
    public void maintenance(CursorContext cursorContext) {
        if (!this.cache.isFull() && !this.readOnlyChecker.isReadOnly()) {
            this.scanner.tryLoadFreeIdsIntoCache(true, cursorContext);
        }
    }

    private void checkRefillCache(CursorContext cursorContext) {
        if (this.cache.size() <= this.cacheOptimisticRefillThreshold) {
            this.scanner.tryLoadFreeIdsIntoCache(this.strictlyPrioritizeFreelist, cursorContext);
        }
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
        if (!this.readOnlyChecker.isReadOnly()) {
            this.monitor.clearingCache();
            this.scanner.clearCache(cursorContext);
            this.monitor.clearedCache();
        }
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.getHighId() - 1L;
    }

    @Override
    public long getNumberOfIdsInUse() {
        return this.getHighId();
    }

    @Override
    public long getDefragCount() {
        return this.cache.size();
    }

    @Override
    public void markHighestWrittenAtHighId() {
        this.assertNotReadOnly();
        this.highestWrittenId.set(this.highId.get() - 1L);
    }

    @Override
    public long getHighestWritten() {
        return this.highestWrittenId.get();
    }

    public Path path() {
        return this.path;
    }

    private static Optional<HeaderReader> readHeader(PageCache pageCache, Path path, String databaseName, CursorContext cursorContext) {
        try {
            HeaderReader headerReader = new HeaderReader();
            GBPTree.readHeader((PageCache)pageCache, (Path)path, (Header.Reader)headerReader, (String)databaseName, (CursorContext)cursorContext);
            return Optional.of(headerReader);
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void dump(PageCache pageCache, Path path, PageCacheTracer cacheTracer, boolean onlySummary) throws IOException {
        try (CursorContext cursorContext = new CursorContext(cacheTracer.createPageCursorTracer("IndexDump"));){
            final HeaderReader header = IndexedIdGenerator.readHeader(pageCache, path, "neo4j", cursorContext).orElseThrow(() -> new NoSuchFileException(path.toAbsolutePath().toString()));
            final IdRangeLayout layout = new IdRangeLayout(header.idsPerEntry);
            try (GBPTree tree = new GBPTree(pageCache, path, (Layout)layout, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.immediate(), DatabaseReadOnlyChecker.readOnly(), cacheTracer, Sets.immutable.empty(), "neo4j", "Indexed ID generator");){
                System.out.println(header);
                if (onlySummary) {
                    final MutableLong numDeletedNotFreed = new MutableLong();
                    final MutableLong numDeletedAndFreed = new MutableLong();
                    System.out.println("Calculating summary...");
                    tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<IdRangeKey, IdRange>(){

                        public void value(IdRange value) {
                            for (int i = 0; i < header.idsPerEntry; ++i) {
                                IdRange.IdState state = value.getState(i);
                                if (state == IdRange.IdState.FREE) {
                                    numDeletedAndFreed.increment();
                                    continue;
                                }
                                if (state != IdRange.IdState.DELETED) continue;
                                numDeletedNotFreed.increment();
                            }
                        }
                    }, cursorContext);
                    System.out.println();
                    System.out.println("Number of IDs deleted and available for reuse: " + numDeletedAndFreed);
                    System.out.println("Number of IDs deleted, but not yet available for reuse: " + numDeletedNotFreed);
                    System.out.printf("NOTE: A deleted ID not yet available for reuse is buffered until all transactions that were open%nat the time of its deletion have been closed, or the database is restarted", new Object[0]);
                } else {
                    tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<IdRangeKey, IdRange>(){
                        private IdRangeKey key;

                        public void key(IdRangeKey key, boolean isLeaf, long offloadId) {
                            this.key = key;
                        }

                        public void value(IdRange value) {
                            long rangeIndex = this.key.getIdRangeIdx();
                            int idsPerEntry = layout.idsPerEntry();
                            System.out.printf("%s [rangeIndex: %d, i.e. IDs:%d-%d]%n", value, rangeIndex, rangeIndex * (long)idsPerEntry, (rangeIndex + 1L) * (long)idsPerEntry - 1L);
                        }
                    }, cursorContext);
                }
                System.out.println(header);
            }
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<IdRangeKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)), cursorContext);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<IdRangeKey> visitor, CursorContext cursorContext) {
        try {
            return this.tree.consistencyCheck(visitor, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void assertNotReadOnly() {
        this.readOnlyChecker.check();
    }

    static interface InternalMarker
    extends IdGenerator.Marker {
        default public void markReserved(long id) {
            this.markReserved(id, 1);
        }

        public void markReserved(long var1, int var3);

        public void markUnreserved(long var1, int var3);
    }

    public static interface Monitor
    extends AutoCloseable {
        public void opened(long var1, long var3);

        @Override
        public void close();

        public void allocatedFromHigh(long var1, int var3);

        public void allocatedFromReused(long var1, int var3);

        public void cached(long var1, int var3);

        public void markedAsUsed(long var1, int var3);

        public void markedAsDeleted(long var1, int var3);

        public void markedAsFree(long var1, int var3);

        public void markedAsReserved(long var1, int var3);

        public void markedAsUnreserved(long var1);

        public void markedAsDeletedAndFree(long var1);

        public void markSessionDone();

        public void normalized(long var1);

        public void bridged(long var1);

        public void checkpoint(long var1, long var3);

        public void clearingCache();

        public void clearedCache();

        public void skippedIdsAtHighId(long var1, int var3);

        public static class Adapter
        implements Monitor {
            @Override
            public void opened(long highestWrittenId, long highId) {
            }

            @Override
            public void allocatedFromHigh(long allocatedId, int numberOfIds) {
            }

            @Override
            public void allocatedFromReused(long allocatedId, int numberOfIds) {
            }

            @Override
            public void cached(long cachedId, int numberOfIds) {
            }

            @Override
            public void markedAsUsed(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsDeleted(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsFree(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsReserved(long markedId, int numberOfIds) {
            }

            @Override
            public void markedAsUnreserved(long markedId) {
            }

            @Override
            public void markedAsDeletedAndFree(long markedId) {
            }

            @Override
            public void markSessionDone() {
            }

            @Override
            public void normalized(long idRange) {
            }

            @Override
            public void bridged(long bridgedId) {
            }

            @Override
            public void checkpoint(long highestWrittenId, long highId) {
            }

            @Override
            public void clearingCache() {
            }

            @Override
            public void clearedCache() {
            }

            @Override
            public void skippedIdsAtHighId(long firstSkippedId, int numberOfIds) {
            }

            @Override
            public void close() {
            }
        }
    }
}

