/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.Arrays;
import org.neo4j.internal.id.IdRange;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.io.pagecache.context.CursorContext;

public class IdRangeIterator
implements IdSequence {
    public static final long VALUE_REPRESENTING_NULL = -1L;
    private int position;
    private final long[] defrag;
    private final long start;
    private final int length;

    public IdRangeIterator(IdRange idRange) {
        this.defrag = idRange.getDefragIds();
        this.start = idRange.getRangeStart();
        this.length = idRange.getRangeLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextId(CursorContext ignored) {
        try {
            if (this.position < this.defrag.length) {
                long l = this.defrag[this.position];
                return l;
            }
            long candidate = this.nextRangeCandidate();
            if (IdValidator.isReservedId(candidate)) {
                ++this.position;
                candidate = this.nextRangeCandidate();
            }
            long l = candidate;
            return l;
        }
        finally {
            ++this.position;
        }
    }

    private long nextRangeCandidate() {
        int offset = this.currentRangeOffset();
        return offset < this.length ? this.start + (long)offset : -1L;
    }

    private int currentRangeOffset() {
        return this.position - this.defrag.length;
    }

    public String toString() {
        return "IdRangeIterator[start:" + this.start + ", length:" + this.length + ", position:" + this.position + ", defrag:" + Arrays.toString(this.defrag) + "]";
    }
}

