/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.function.LongConsumer;

class LinkedChunkLongArray {
    private Chunk first;
    private Chunk current;
    private int size;

    LinkedChunkLongArray(int initialChunkSize) {
        this.current = this.first = new Chunk(initialChunkSize);
    }

    void add(long id) {
        if (!this.current.add(id)) {
            Chunk newChunk;
            this.current.next = newChunk = new Chunk(this.current.ids.length * 2);
            this.current = newChunk;
            this.current.add(id);
        }
        ++this.size;
    }

    int size() {
        return this.size;
    }

    void accept(LongConsumer visitor) {
        Chunk chunk = this.first;
        while (chunk != null) {
            for (int i = 0; i < chunk.cursor; ++i) {
                visitor.accept(chunk.ids[i]);
            }
            chunk = chunk.next;
        }
    }

    private static class Chunk {
        private final long[] ids;
        private int cursor;
        private Chunk next;

        Chunk(int size) {
            this.ids = new long[size];
        }

        boolean add(long id) {
            if (this.cursor < this.ids.length) {
                this.ids[this.cursor++] = id;
                return true;
            }
            return false;
        }
    }
}

