/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

public class BufferedIdController
extends LifecycleAdapter
implements IdController {
    private static final String BUFFERED_ID_CONTROLLER = "idController";
    private final BufferingIdGeneratorFactory bufferingIdGeneratorFactory;
    private final JobScheduler scheduler;
    private final PageCacheTracer pageCacheTracer;
    private final String databaseName;
    private JobHandle<?> jobHandle;

    public BufferedIdController(BufferingIdGeneratorFactory bufferingIdGeneratorFactory, JobScheduler scheduler, PageCacheTracer pageCacheTracer, String databaseName) {
        this.bufferingIdGeneratorFactory = bufferingIdGeneratorFactory;
        this.scheduler = scheduler;
        this.pageCacheTracer = pageCacheTracer;
        this.databaseName = databaseName;
    }

    public void start() {
        JobMonitoringParams monitoringParams = JobMonitoringParams.systemJob((String)this.databaseName, (String)"ID generator maintenance");
        this.jobHandle = this.scheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, monitoringParams, this::maintenance, 1L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.jobHandle != null) {
            this.jobHandle.cancel();
            this.jobHandle = null;
        }
    }

    @Override
    public void clear() {
        this.bufferingIdGeneratorFactory.clear();
    }

    @Override
    public void maintenance() {
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(BUFFERED_ID_CONTROLLER));){
            this.bufferingIdGeneratorFactory.maintenance(cursorContext);
        }
    }

    @Override
    public void initialize(Supplier<IdController.ConditionSnapshot> conditionSnapshotSupplier) {
        this.bufferingIdGeneratorFactory.initialize(conditionSnapshotSupplier);
    }
}

