/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdRange;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;

public class EmptyIdGeneratorFactory
implements IdGeneratorFactory {
    public static IdGeneratorFactory EMPTY_ID_GENERATOR_FACTORY = new EmptyIdGeneratorFactory();

    private EmptyIdGeneratorFactory() {
    }

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        return EmptyIdGenerator.EMPTY_ID_GENERATOR;
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, DatabaseReadOnlyChecker readOnlyChecker, Config config, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        return EmptyIdGenerator.EMPTY_ID_GENERATOR;
    }

    @Override
    public IdGenerator get(IdType idType) {
        return EmptyIdGenerator.EMPTY_ID_GENERATOR;
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
    }

    @Override
    public void clearCache(CursorContext cursorContext) {
    }

    @Override
    public Collection<Path> listIdFiles() {
        return Collections.emptyList();
    }

    private static class EmptyIdGenerator
    implements IdGenerator {
        private static final EmptyIdGenerator EMPTY_ID_GENERATOR = new EmptyIdGenerator();
        private static final int EMPTY_ID = -1;

        private EmptyIdGenerator() {
        }

        @Override
        public IdRange nextIdBatch(int size, boolean forceConsecutiveAllocation, CursorContext cursorContext) {
            return new IdRange(ArrayUtils.EMPTY_LONG_ARRAY, -1L, -1);
        }

        @Override
        public void setHighId(long id) {
        }

        @Override
        public void markHighestWrittenAtHighId() {
        }

        @Override
        public long getHighestWritten() {
            return -1L;
        }

        @Override
        public long getHighId() {
            return -1L;
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return -1L;
        }

        @Override
        public IdGenerator.Marker marker(CursorContext cursorContext) {
            return NOOP_MARKER;
        }

        @Override
        public void close() {
        }

        @Override
        public long getNumberOfIdsInUse() {
            return -1L;
        }

        @Override
        public long getDefragCount() {
            return -1L;
        }

        @Override
        public void checkpoint(CursorContext cursorContext) {
        }

        @Override
        public void maintenance(boolean awaitOngoing, CursorContext cursorContext) {
        }

        @Override
        public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) throws IOException {
        }

        @Override
        public void clearCache(CursorContext cursorContext) {
        }

        @Override
        public long nextId(CursorContext cursorContext) {
            return -1L;
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
            return true;
        }
    }
}

