/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.internal.id.ChunkConsumer;
import org.neo4j.internal.id.DelayedBuffer;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private DelayedBuffer<IdController.ConditionSnapshot> buffer;

    BufferingIdGenerator(IdGenerator delegate) {
        super(delegate);
    }

    void initialize(Supplier<IdController.ConditionSnapshot> boundaries, Predicate<IdController.ConditionSnapshot> safeThreshold) {
        this.buffer = new DelayedBuffer<IdController.ConditionSnapshot>(boundaries, safeThreshold, 10000, new FreeIdChunkConsumer());
    }

    @Override
    public IdGenerator.Marker marker(PageCursorTracer cursorTracer) {
        final IdGenerator.Marker actual = super.marker(cursorTracer);
        return new IdGenerator.Marker(){

            @Override
            public void markUsed(long id) {
                actual.markUsed(id);
            }

            @Override
            public void markDeleted(long id) {
                actual.markDeleted(id);
                BufferingIdGenerator.this.buffer.offer(id);
            }

            @Override
            public void markFree(long id) {
                actual.markFree(id);
            }

            @Override
            public void close() {
                actual.close();
            }
        };
    }

    @Override
    public void maintenance(boolean awaitOngoing, PageCursorTracer cursorTracer) {
        this.buffer.maintenance(cursorTracer);
        super.maintenance(awaitOngoing, cursorTracer);
    }

    @Override
    public void clearCache(PageCursorTracer cursorTracer) {
        this.buffer.clear();
        super.clearCache(cursorTracer);
    }

    void clear() {
        this.buffer.clear();
    }

    @Override
    public void checkpoint(IOLimiter ioLimiter, PageCursorTracer cursorTracer) {
        this.buffer.maintenance(cursorTracer);
        super.checkpoint(ioLimiter, cursorTracer);
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
        super.close();
    }

    private class FreeIdChunkConsumer
    implements ChunkConsumer {
        private FreeIdChunkConsumer() {
        }

        @Override
        public void consume(long[] freedIds, PageCursorTracer cursorTracer) {
            try (IdGenerator.Marker reuseMarker = BufferingIdGenerator.super.marker(cursorTracer);){
                for (long id : freedIds) {
                    reuseMarker.markFree(id);
                }
            }
        }
    }
}

