/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.util.Preconditions;

class SpmcLongQueue
implements ConcurrentLongQueue {
    private final long idxMask;
    private final AtomicLongArray array;
    private final AtomicLong readSeq = new AtomicLong();
    private final AtomicLong writeSeq = new AtomicLong();

    SpmcLongQueue(int capacity) {
        Preconditions.requirePowerOfTwo((long)capacity);
        this.idxMask = capacity - 1;
        this.array = new AtomicLongArray(capacity);
    }

    @Override
    public boolean offer(long value) {
        int readIdx;
        long currentWriteSeq = this.writeSeq.get();
        long currentReadSeq = this.readSeq.get();
        int writeIdx = this.idx(currentWriteSeq);
        if (writeIdx == (readIdx = this.idx(currentReadSeq)) && currentWriteSeq != currentReadSeq) {
            return false;
        }
        this.array.set(writeIdx, value);
        this.writeSeq.incrementAndGet();
        return true;
    }

    @Override
    public long takeOrDefault(long defaultValue) {
        long value;
        long currentReadSeq;
        do {
            long currentWriteSeq;
            if ((currentReadSeq = this.readSeq.get()) == (currentWriteSeq = this.writeSeq.get())) {
                return defaultValue;
            }
            value = this.array.get(this.idx(currentReadSeq));
        } while (!this.readSeq.compareAndSet(currentReadSeq, currentReadSeq + 1L));
        return value;
    }

    @Override
    public int capacity() {
        return this.array.length();
    }

    @Override
    public int size() {
        return Math.toIntExact(Math.max(0L, this.writeSeq.get() - this.readSeq.get()));
    }

    @Override
    public void clear() {
        this.readSeq.set(this.writeSeq.get());
    }

    private int idx(long seq) {
        return Math.toIntExact(seq & this.idxMask);
    }
}

