/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.internal.id.indexed.FreeIdScanner;
import org.neo4j.internal.id.indexed.HeaderReader;
import org.neo4j.internal.id.indexed.HeaderWriter;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.internal.id.indexed.IdRangeMarker;
import org.neo4j.internal.id.indexed.IdRangeMerger;
import org.neo4j.internal.id.indexed.SpmcLongQueue;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.util.FeatureToggles;

public class IndexedIdGenerator
implements IdGenerator {
    public static final Monitor NO_MONITOR = new Monitor.Adapter();
    static final boolean STRICTLY_PRIORITIZE_FREELIST_DEFAULT = true;
    public static final String STRICTLY_PRIORITIZE_FREELIST_NAME = "strictlyPrioritizeFreelist";
    static final long NO_ID = -1L;
    static final int IDS_PER_ENTRY = 128;
    static final int SMALL_CACHE_CAPACITY = 256;
    static final int LARGE_CACHE_CAPACITY = 16384;
    private static final long STARTING_GENERATION = 1L;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final ConcurrentLongQueue cache;
    private final IdType idType;
    private final int idsPerEntry;
    private final int cacheOptimisticRefillThreshold;
    private final Lock commitAndReuseLock = new ReentrantLock();
    private final IdRangeLayout layout;
    private final FreeIdScanner scanner;
    private final AtomicLong highId = new AtomicLong();
    private final long maxId;
    private final AtomicBoolean atLeastOneIdOnFreelist = new AtomicBoolean();
    private final long generation;
    private final boolean needsRebuild;
    private final AtomicLong highestWrittenId = new AtomicLong();
    private final Path path;
    private final boolean readOnly;
    private volatile boolean started;
    private final IdRangeMerger defaultMerger;
    private final IdRangeMerger recoveryMerger;
    private final Monitor monitor;

    public IndexedIdGenerator(PageCache pageCache, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdType idType, boolean allowLargeIdCaches, LongSupplier initialHighId, long maxId, boolean readOnly, PageCursorTracer cursorTracer) {
        this(pageCache, path, recoveryCleanupWorkCollector, idType, allowLargeIdCaches, initialHighId, maxId, readOnly, cursorTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    public IndexedIdGenerator(PageCache pageCache, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdType idType, boolean allowLargeIdCaches, LongSupplier initialHighId, long maxId, boolean readOnly, PageCursorTracer cursorTracer, ImmutableSet<OpenOption> openOptions) {
        this(pageCache, path, recoveryCleanupWorkCollector, idType, allowLargeIdCaches, initialHighId, maxId, readOnly, cursorTracer, NO_MONITOR, openOptions);
    }

    public IndexedIdGenerator(PageCache pageCache, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdType idType, boolean allowLargeIdCaches, LongSupplier initialHighId, long maxId, boolean readOnly, PageCursorTracer cursorTracer, Monitor monitor, ImmutableSet<OpenOption> openOptions) {
        this.path = path;
        this.readOnly = readOnly;
        int cacheCapacity = idType.highActivity() && allowLargeIdCaches ? 16384 : 256;
        this.idType = idType;
        this.cache = new SpmcLongQueue(cacheCapacity);
        this.maxId = maxId;
        this.monitor = monitor;
        this.defaultMerger = new IdRangeMerger(false, monitor);
        this.recoveryMerger = new IdRangeMerger(true, monitor);
        Optional<HeaderReader> header = IndexedIdGenerator.readHeader(pageCache, path, cursorTracer);
        boolean bl = this.needsRebuild = header.isEmpty() || header.get().generation == 1L;
        if (!this.needsRebuild) {
            this.highId.set(header.get().highId);
            this.highestWrittenId.set(header.get().highestWrittenId);
            this.generation = header.get().generation + 1L;
            this.idsPerEntry = header.get().idsPerEntry;
            this.atLeastOneIdOnFreelist.set(true);
        } else {
            this.highId.set(initialHighId.getAsLong());
            this.highestWrittenId.set(this.highId.get() - 1L);
            this.generation = 2L;
            this.idsPerEntry = 128;
        }
        monitor.opened(this.highestWrittenId.get(), this.highId.get());
        this.layout = new IdRangeLayout(this.idsPerEntry);
        this.tree = this.instantiateTree(pageCache, path, recoveryCleanupWorkCollector, readOnly, openOptions);
        boolean strictlyPrioritizeFreelist = FeatureToggles.flag(IndexedIdGenerator.class, (String)STRICTLY_PRIORITIZE_FREELIST_NAME, (boolean)true);
        this.cacheOptimisticRefillThreshold = strictlyPrioritizeFreelist ? 0 : cacheCapacity / 4;
        this.scanner = readOnly ? null : new FreeIdScanner(this.idsPerEntry, this.tree, this.cache, this.atLeastOneIdOnFreelist, tracer -> this.lockAndInstantiateMarker(true, tracer), this.generation, strictlyPrioritizeFreelist, monitor);
    }

    private GBPTree<IdRangeKey, IdRange> instantiateTree(PageCache pageCache, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, ImmutableSet<OpenOption> openOptions) {
        try {
            HeaderWriter headerWriter = new HeaderWriter(this.highId::get, this.highestWrittenId::get, 1L, this.idsPerEntry);
            return new GBPTree(pageCache, path, (Layout)this.layout, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, (Consumer)headerWriter, recoveryCleanupWorkCollector, readOnly, PageCacheTracer.NULL, openOptions, "Indexed ID generator");
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Id generator file could not be found, most likely this database needs to be recovered, file:" + path, e);
        }
    }

    @Override
    public long nextId(PageCursorTracer cursorTracer) {
        long id;
        this.assertNotReadOnly();
        do {
            this.checkRefillCache(cursorTracer);
            id = this.cache.takeOrDefault(-1L);
            if (id == -1L) continue;
            this.monitor.allocatedFromReused(id);
            return id;
        } while (this.scanner.hasMoreFreeIds());
        do {
            id = this.highId.getAndIncrement();
            IdValidator.assertIdWithinMaxCapacity(this.idType, id, this.maxId);
        } while (IdValidator.isReservedId(id));
        this.monitor.allocatedFromHigh(id);
        return id;
    }

    @Override
    public org.neo4j.internal.id.IdRange nextIdBatch(int size, boolean forceConsecutiveAllocation, PageCursorTracer cursorTracer) {
        this.assertNotReadOnly();
        if (forceConsecutiveAllocation) {
            long startId;
            while (IdValidator.hasReservedIdInRange(startId = this.highId.getAndAdd(size), startId + (long)size)) {
            }
            return new org.neo4j.internal.id.IdRange(ArrayUtils.EMPTY_LONG_ARRAY, startId, size);
        }
        long prev = -1L;
        long startOfRange = -1L;
        int rangeLength = 0;
        MutableLongList other = null;
        for (int i = 0; i < size; ++i) {
            long id = this.nextId(cursorTracer);
            if (other != null) {
                other.add(id);
                continue;
            }
            if (i == 0) {
                prev = id;
                startOfRange = id;
                rangeLength = 1;
                continue;
            }
            if (id == prev + 1L) {
                prev = id;
                ++rangeLength;
                continue;
            }
            other = LongLists.mutable.empty();
            other.add(id);
        }
        return new org.neo4j.internal.id.IdRange(other != null ? other.toArray() : ArrayUtils.EMPTY_LONG_ARRAY, startOfRange, rangeLength);
    }

    @Override
    public IdGenerator.Marker marker(PageCursorTracer cursorTracer) {
        if (!this.started && this.needsRebuild) {
            return NOOP_MARKER;
        }
        return this.lockAndInstantiateMarker(true, cursorTracer);
    }

    IdRangeMarker lockAndInstantiateMarker(boolean bridgeIdGaps, PageCursorTracer cursorTracer) {
        this.assertNotReadOnly();
        this.commitAndReuseLock.lock();
        try {
            return new IdRangeMarker(this.idsPerEntry, (Layout<IdRangeKey, IdRange>)this.layout, (Writer<IdRangeKey, IdRange>)this.tree.writer(cursorTracer), this.commitAndReuseLock, this.started ? this.defaultMerger : this.recoveryMerger, this.started, this.atLeastOneIdOnFreelist, this.generation, this.highestWrittenId, bridgeIdGaps, this.monitor);
        }
        catch (Exception e) {
            this.commitAndReuseLock.unlock();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.scanner, this.tree, this.monitor});
    }

    @Override
    public long getHighId() {
        return this.highId.get();
    }

    @Override
    public void setHighId(long newHighId) {
        long expect;
        this.assertNotReadOnly();
        while (newHighId > (expect = this.highId.get()) && !this.highId.compareAndSet(expect, newHighId)) {
        }
    }

    @Override
    public void start(FreeIds freeIdsForRebuild, PageCursorTracer cursorTracer) throws IOException {
        if (this.needsRebuild) {
            this.assertNotReadOnly();
            try (IdRangeMarker idRangeMarker = this.lockAndInstantiateMarker(false, cursorTracer);){
                long highestId = freeIdsForRebuild.accept(id -> {
                    idRangeMarker.markDeleted(id);
                    idRangeMarker.markFree(id);
                });
                this.highId.set(highestId + 1L);
                this.highestWrittenId.set(highestId);
            }
            this.checkpoint(IOLimiter.UNLIMITED, cursorTracer);
            this.atLeastOneIdOnFreelist.set(true);
        }
        this.started = true;
        this.maintenance(cursorTracer);
    }

    @Override
    public void checkpoint(IOLimiter ioLimiter, PageCursorTracer cursorTracer) {
        this.tree.checkpoint(ioLimiter, (Consumer)new HeaderWriter(this.highId::get, this.highestWrittenId::get, this.generation, this.idsPerEntry), cursorTracer);
        this.monitor.checkpoint(this.highestWrittenId.get(), this.highId.get());
    }

    @Override
    public void maintenance(PageCursorTracer cursorTracer) {
        if (!this.readOnly && this.cache.size() < this.cache.capacity()) {
            this.scanner.tryLoadFreeIdsIntoCache(true, cursorTracer);
        }
    }

    private void checkRefillCache(PageCursorTracer cursorTracer) {
        if (!this.readOnly && this.cache.size() <= this.cacheOptimisticRefillThreshold) {
            this.scanner.tryLoadFreeIdsIntoCache(false, cursorTracer);
        }
    }

    @Override
    public void clearCache(PageCursorTracer cursorTracer) {
        if (!this.readOnly) {
            this.monitor.clearingCache();
            this.scanner.clearCache(cursorTracer);
            this.monitor.clearedCache();
        }
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.getHighId() - 1L;
    }

    @Override
    public long getNumberOfIdsInUse() {
        return this.getHighId();
    }

    @Override
    public long getDefragCount() {
        return this.cache.size();
    }

    @Override
    public void markHighestWrittenAtHighId() {
        this.assertNotReadOnly();
        this.highestWrittenId.set(this.highId.get() - 1L);
    }

    @Override
    public long getHighestWritten() {
        return this.highestWrittenId.get();
    }

    public Path path() {
        return this.path;
    }

    private static Optional<HeaderReader> readHeader(PageCache pageCache, Path path, PageCursorTracer cursorTracer) {
        try {
            HeaderReader headerReader = new HeaderReader();
            GBPTree.readHeader((PageCache)pageCache, (Path)path, (Header.Reader)headerReader, (PageCursorTracer)cursorTracer);
            return Optional.of(headerReader);
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void dump(PageCache pageCache, Path path, PageCacheTracer cacheTracer, boolean onlySummary) throws IOException {
        try (PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer("IndexDump");){
            HeaderReader header = IndexedIdGenerator.readHeader(pageCache, path, cursorTracer).orElseThrow(() -> new NoSuchFileException(path.toAbsolutePath().toString()));
            IdRangeLayout layout = new IdRangeLayout(header.idsPerEntry);
            try (GBPTree tree = new GBPTree(pageCache, path, (Layout)layout, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.immediate(), true, cacheTracer, Sets.immutable.empty(), "Indexed ID generator");){
                System.out.println(header);
                if (onlySummary) {
                    final MutableLong numDeletedNotFreed = new MutableLong();
                    final MutableLong numDeletedAndFreed = new MutableLong();
                    System.out.println("Calculating summary...");
                    tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<IdRangeKey, IdRange>(){

                        public void value(IdRange value) {
                            for (int i = 0; i < 128; ++i) {
                                IdRange.IdState state = value.getState(i);
                                if (state == IdRange.IdState.FREE) {
                                    numDeletedAndFreed.increment();
                                    continue;
                                }
                                if (state != IdRange.IdState.DELETED) continue;
                                numDeletedNotFreed.increment();
                            }
                        }
                    }, cursorTracer);
                    System.out.println();
                    System.out.println("Number of IDs deleted and available for reuse: " + numDeletedAndFreed);
                    System.out.println("Number of IDs deleted, but not yet available for reuse: " + numDeletedNotFreed);
                    System.out.printf("NOTE: A deleted ID not yet available for reuse is buffered until all transactions that were open%nat the time of its deletion have been closed, or the database is restarted", new Object[0]);
                } else {
                    tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<IdRangeKey, IdRange>(){
                        private IdRangeKey key;

                        public void key(IdRangeKey key, boolean isLeaf, long offloadId) {
                            this.key = key;
                        }

                        public void value(IdRange value) {
                            System.out.println(String.format("%s [%d]", value, this.key.getIdRangeIdx()));
                        }
                    }, cursorTracer);
                }
            }
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<IdRangeKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)), cursorTracer);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<IdRangeKey> visitor, PageCursorTracer cursorTracer) {
        try {
            return this.tree.consistencyCheck(visitor, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void assertNotReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can not write to id generator while in read only mode.");
        }
    }

    static interface ReservedMarker
    extends AutoCloseable {
        public void markReserved(long var1);

        public void markUnreserved(long var1);

        @Override
        public void close();
    }

    public static interface Monitor
    extends AutoCloseable {
        public void opened(long var1, long var3);

        @Override
        public void close();

        public void allocatedFromHigh(long var1);

        public void allocatedFromReused(long var1);

        public void cached(long var1);

        public void markedAsUsed(long var1);

        public void markedAsDeleted(long var1);

        public void markedAsFree(long var1);

        public void markedAsReserved(long var1);

        public void markedAsUnreserved(long var1);

        public void markedAsDeletedAndFree(long var1);

        public void markSessionDone();

        public void normalized(long var1);

        public void bridged(long var1);

        public void checkpoint(long var1, long var3);

        public void clearingCache();

        public void clearedCache();

        public static class Adapter
        implements Monitor {
            @Override
            public void opened(long highestWrittenId, long highId) {
            }

            @Override
            public void allocatedFromHigh(long allocatedId) {
            }

            @Override
            public void allocatedFromReused(long allocatedId) {
            }

            @Override
            public void cached(long cachedId) {
            }

            @Override
            public void markedAsUsed(long markedId) {
            }

            @Override
            public void markedAsDeleted(long markedId) {
            }

            @Override
            public void markedAsFree(long markedId) {
            }

            @Override
            public void markedAsReserved(long markedId) {
            }

            @Override
            public void markedAsUnreserved(long markedId) {
            }

            @Override
            public void markedAsDeletedAndFree(long markedId) {
            }

            @Override
            public void markSessionDone() {
            }

            @Override
            public void normalized(long idRange) {
            }

            @Override
            public void bridged(long bridgedId) {
            }

            @Override
            public void checkpoint(long highestWrittenId, long highId) {
            }

            @Override
            public void clearingCache() {
            }

            @Override
            public void clearedCache() {
            }

            @Override
            public void close() {
            }
        }
    }
}

