/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.LoggingIndexedIdGeneratorMonitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class DefaultIdGeneratorFactory
implements IdGeneratorFactory {
    private final EnumMap<IdType, IndexedIdGenerator> generators = new EnumMap(IdType.class);
    protected final FileSystemAbstraction fs;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    protected final boolean allowLargeIdCaches;

    public DefaultIdGeneratorFactory(FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this(fs, recoveryCleanupWorkCollector, false);
    }

    public DefaultIdGeneratorFactory(FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean allowLargeIdCaches) {
        this.fs = fs;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.allowLargeIdCaches = allowLargeIdCaches;
    }

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, boolean readOnly, PageCursorTracer cursorTracer, ImmutableSet<OpenOption> openOptions) {
        IndexedIdGenerator generator = this.instantiate(this.fs, pageCache, this.recoveryCleanupWorkCollector, filename, highIdScanner, maxId, idType, readOnly, cursorTracer, openOptions);
        this.generators.put(idType, generator);
        return generator;
    }

    protected IndexedIdGenerator instantiate(FileSystemAbstraction fs, PageCache pageCache, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Path fileName, LongSupplier highIdSupplier, long maxValue, IdType idType, boolean readOnly, PageCursorTracer cursorTracer, ImmutableSet<OpenOption> openOptions) {
        return new IndexedIdGenerator(pageCache, fileName, recoveryCleanupWorkCollector, idType, this.allowLargeIdCaches, highIdSupplier, maxValue, readOnly, cursorTracer, LoggingIndexedIdGeneratorMonitor.defaultIdMonitor(fs, fileName), openOptions);
    }

    @Override
    public IdGenerator get(IdType idType) {
        return this.generators.get((Object)idType);
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path fileName, IdType idType, long highId, boolean throwIfFileExists, long maxId, boolean readOnly, PageCursorTracer cursorTracer, ImmutableSet<OpenOption> openOptions) {
        this.fs.deleteFile(fileName);
        IndexedIdGenerator generator = new IndexedIdGenerator(pageCache, fileName, this.recoveryCleanupWorkCollector, idType, this.allowLargeIdCaches, () -> highId, maxId, readOnly, cursorTracer, LoggingIndexedIdGeneratorMonitor.defaultIdMonitor(this.fs, fileName), openOptions);
        generator.checkpoint(IOLimiter.UNLIMITED, cursorTracer);
        this.generators.put(idType, generator);
        return generator;
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        this.generators.values().forEach(visitor);
    }

    @Override
    public void clearCache(PageCursorTracer cursorTracer) {
        this.generators.values().forEach(generator -> generator.clearCache(cursorTracer));
    }

    @Override
    public Collection<Path> listIdFiles() {
        return this.generators.values().stream().map(IndexedIdGenerator::path).collect(Collectors.toList());
    }
}

