/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.ScanLock;

class FreeIdScanner
implements Closeable {
    private static final IdRangeKey LOW_KEY = new IdRangeKey(0L);
    private static final IdRangeKey HIGH_KEY = new IdRangeKey(Long.MAX_VALUE);
    private final int idsPerEntry;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final ConcurrentLongQueue cache;
    private final AtomicBoolean atLeastOneIdOnFreelist;
    private final Supplier<IndexedIdGenerator.ReservedMarker> markerSupplier;
    private final long generation;
    private final ScanLock lock;
    private final long[] pendingItemsToCache;
    private int pendingItemsToCacheCursor;
    private Long ongoingScanRangeIndex;

    FreeIdScanner(int idsPerEntry, GBPTree<IdRangeKey, IdRange> tree, ConcurrentLongQueue cache, AtomicBoolean atLeastOneIdOnFreelist, Supplier<IndexedIdGenerator.ReservedMarker> markerSupplier, long generation, boolean strictlyPrioritizeFreelistOverHighId) {
        this.idsPerEntry = idsPerEntry;
        this.tree = tree;
        this.cache = cache;
        this.atLeastOneIdOnFreelist = atLeastOneIdOnFreelist;
        this.markerSupplier = markerSupplier;
        this.pendingItemsToCache = new long[cache.capacity()];
        this.generation = generation;
        this.lock = strictlyPrioritizeFreelistOverHighId ? ScanLock.lockyAndPessimistic() : ScanLock.lockFreeAndOptimistic();
    }

    boolean tryLoadFreeIdsIntoCache() {
        if (this.ongoingScanRangeIndex == null && !this.atLeastOneIdOnFreelist.get()) {
            return false;
        }
        if (this.lock.tryLock()) {
            try {
                this.pendingItemsToCacheCursor = 0;
                int maxItemsToCache = this.cache.capacity() - this.cache.size();
                if (maxItemsToCache > 0 && this.findSomeIdsToCache(maxItemsToCache)) {
                    this.markIdsAsReserved();
                    this.placeIdsInCache();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        this.lock.lock();
        try {
            this.ongoingScanRangeIndex = null;
            try (IndexedIdGenerator.ReservedMarker marker = this.markerSupplier.get();){
                long id;
                do {
                    if ((id = this.cache.takeOrDefault(-1L)) == -1L) continue;
                    marker.markUnreserved(id);
                } while (id != -1L);
            }
            this.atLeastOneIdOnFreelist.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void placeIdsInCache() {
        for (int i = 0; i < this.pendingItemsToCacheCursor; ++i) {
            if (this.cache.offer(this.pendingItemsToCache[i])) continue;
            throw new IllegalStateException("This really should not happen, we knew the max available space there were for caching ids and now the cache claims to have less than that?");
        }
    }

    private void markIdsAsReserved() {
        try (IndexedIdGenerator.ReservedMarker marker = this.markerSupplier.get();){
            for (int i = 0; i < this.pendingItemsToCacheCursor; ++i) {
                marker.markReserved(this.pendingItemsToCache[i]);
            }
        }
    }

    private boolean findSomeIdsToCache(int maxItemsToCache) throws IOException {
        boolean somethingWasCached;
        boolean startedNow = this.ongoingScanRangeIndex == null;
        IdRangeKey from = this.ongoingScanRangeIndex == null ? LOW_KEY : new IdRangeKey(this.ongoingScanRangeIndex);
        boolean seekerExhausted = false;
        try (Seeker scanner = this.tree.seek((Object)from, (Object)HIGH_KEY);){
            while (this.pendingItemsToCacheCursor < maxItemsToCache) {
                if (!scanner.next()) {
                    seekerExhausted = true;
                    break;
                }
                this.queueIdsFromTreeItem((IdRangeKey)scanner.key(), (IdRange)scanner.value(), maxItemsToCache);
            }
            this.ongoingScanRangeIndex = seekerExhausted ? null : Long.valueOf(((IdRangeKey)scanner.key()).getIdRangeIdx());
        }
        boolean bl = somethingWasCached = this.pendingItemsToCacheCursor > 0;
        if (seekerExhausted && !somethingWasCached && startedNow) {
            this.atLeastOneIdOnFreelist.set(false);
        }
        return somethingWasCached;
    }

    private void queueIdsFromTreeItem(IdRangeKey key, IdRange range, int maxItemsToCache) {
        long baseId = key.getIdRangeIdx() * (long)this.idsPerEntry;
        boolean differentGeneration = this.generation != range.getGeneration();
        for (int i = 0; i < this.idsPerEntry && this.pendingItemsToCacheCursor < maxItemsToCache; ++i) {
            IdRange.IdState state = range.getState(i);
            if (state != IdRange.IdState.FREE && (!differentGeneration || state != IdRange.IdState.DELETED)) continue;
            this.pendingItemsToCache[this.pendingItemsToCacheCursor++] = baseId + (long)i;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

