/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.File;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.ReadOnlyHighIdGenerator;
import org.neo4j.io.pagecache.PageCache;

public class ScanOnOpenReadOnlyIdGeneratorFactory
implements IdGeneratorFactory {
    private final EnumMap<IdType, ReadOnlyHighIdGenerator> idGenerators = new EnumMap(IdType.class);

    @Override
    public IdGenerator open(PageCache pageCache, File filename, IdType idType, LongSupplier highIdScanner, long maxId, boolean readOnly, OpenOption ... openOptions) {
        long highId = highIdScanner.getAsLong();
        ReadOnlyHighIdGenerator idGenerator = new ReadOnlyHighIdGenerator(highId);
        this.idGenerators.put(idType, idGenerator);
        return idGenerator;
    }

    @Override
    public IdGenerator create(PageCache pageCache, File filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, boolean readOnly, OpenOption ... openOptions) {
        return this.open(pageCache, filename, idType, () -> highId, maxId, readOnly, new OpenOption[0]);
    }

    @Override
    public IdGenerator get(IdType idType) {
        ReadOnlyHighIdGenerator idGenerator = this.idGenerators.get((Object)idType);
        if (idGenerator == null) {
            throw new IllegalStateException("IdGenerator for " + idType + " not opened");
        }
        return idGenerator;
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        this.idGenerators.values().forEach(visitor);
    }

    @Override
    public void clearCache() {
        this.idGenerators.values().forEach(IdGenerator::clearCache);
    }

    @Override
    public Collection<File> listIdFiles() {
        return Collections.emptyList();
    }
}

