/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

abstract class ScanLock {
    ScanLock() {
    }

    abstract boolean tryLock();

    abstract void lock();

    abstract void unlock();

    static ScanLock lockFreeAndOptimistic() {
        return new ScanLock(){
            private final AtomicBoolean lockState = new AtomicBoolean();

            @Override
            boolean tryLock() {
                return this.lockState.compareAndSet(false, true);
            }

            @Override
            void lock() {
                while (!this.tryLock()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            void unlock() {
                boolean unlocked = this.lockState.compareAndSet(true, false);
                if (!unlocked) {
                    throw new IllegalStateException("Call to unlock was made on an unlocked instance");
                }
            }
        };
    }

    static ScanLock lockyAndPessimistic() {
        return new ScanLock(){
            private final ReentrantLock lock = new ReentrantLock();

            @Override
            boolean tryLock() {
                if (this.lock.tryLock()) {
                    return true;
                }
                this.lock.lock();
                this.lock.unlock();
                return false;
            }

            @Override
            void lock() {
                this.lock.lock();
            }

            @Override
            void unlock() {
                this.lock.unlock();
            }
        };
    }
}

