/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.range;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.range.PageIdRange;

public class ContinuousIdRange
implements PageIdRange {
    private final long rangeStart;
    private final int rangeSize;
    private final long idsPerPage;
    private int cursor = 0;
    private int marker;

    public ContinuousIdRange(long rangeStart, int rangeSize, long idsPerPage) {
        this.rangeStart = rangeStart;
        this.rangeSize = rangeSize;
        this.idsPerPage = idsPerPage;
    }

    @Override
    public long nextId() {
        return this.rangeStart + (long)this.cursor++;
    }

    @Override
    public long nextConsecutiveIdRange(int numberOfIds) {
        if (this.cursor + numberOfIds <= this.rangeSize) {
            long result = this.rangeStart + (long)this.cursor;
            this.cursor += numberOfIds;
            return result;
        }
        return -1L;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.rangeSize;
    }

    @Override
    public void unallocate(IdGenerator.TransactionalMarker marker) {
        if (this.hasNext()) {
            long firstIdToRelease = this.rangeStart + (long)this.cursor;
            int numberOfIds = this.rangeSize - this.cursor;
            marker.markUnallocated(firstIdToRelease, numberOfIds);
        }
    }

    @Override
    public void mark() {
        this.marker = this.cursor;
    }

    @Override
    public void resetToMark() {
        this.cursor = this.marker;
    }

    @Override
    public long pageId() {
        return this.rangeStart / this.idsPerPage;
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    public String toString() {
        return "ContinuousIdRange{rangeStart=" + this.rangeStart + ", rangeSize=" + this.rangeSize + ", idsPerPage=" + this.idsPerPage + ", cursor=" + this.cursor + ", marker=" + this.marker + "}";
    }
}

