/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.range.PageIdRange;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;

class ReadOnlyHighIdGenerator
implements IdGenerator {
    private final long highId;
    private final IdType idType;

    ReadOnlyHighIdGenerator(long highId, IdType idType) {
        this.highId = highId;
        this.idType = idType;
    }

    @Override
    public void setHighId(long id) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void markHighestWrittenAtHighId() {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public long getHighestWritten() {
        return this.highId;
    }

    @Override
    public long getHighId() {
        return this.highId;
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.highId - 1L;
    }

    @Override
    public long getUnusedIdCount() {
        return 0L;
    }

    @Override
    public PrimitiveLongResourceIterator notUsedIdsIterator() {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    @Override
    public PrimitiveLongResourceIterator notUsedIdsIterator(long fromIdInclusive, long toIdExclusive) {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    @Override
    public PrimitiveLongResourceIterator freeIdsIterator() {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    @Override
    public PrimitiveLongResourceIterator usedIdsIterator() {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    @Override
    public IdGenerator.TransactionalMarker transactionalMarker(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public IdGenerator.ContextualMarker contextualMarker(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void close() {
    }

    @Override
    public void checkpoint(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) {
    }

    @Override
    public void maintenance(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) {
    }

    @Override
    public void stop() {
    }

    @Override
    public long nextId(CursorContext ignored) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public long nextConsecutiveIdRange(int numberOfIds, boolean favorSamePage, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public PageIdRange nextPageRange(CursorContext cursorContext, int idsPerPage) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public PageIdRange nextEmptyPageRange(int idsPerPage) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void releasePageRange(PageIdRange range, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Should not be required");
    }

    @Override
    public void clearCache(boolean allocationEnabled, CursorContext cursorContext) {
    }

    @Override
    public boolean allocationEnabled() {
        return false;
    }

    @Override
    public IdType idType() {
        return this.idType;
    }

    @Override
    public boolean hasOnlySingleIds() {
        return true;
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
        return true;
    }
}

