/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

public final class IdUtils {
    private static final long MASK_USED = 256L;
    private static final int NUM_BITS_NUMBER_OF_IDS = 8;
    private static final long MASK_NUMBER_OF_IDS = 255L;
    private static final int SHIFT_ID = 9;
    static final long MAX_ID = 0x3FFFFFFFFFFFFFL;
    static final int MAX_NUMBER_OF_IDS = 256;

    private IdUtils() {
    }

    public static long combinedIdAndNumberOfIds(long id, int numberOfIds, boolean used) {
        int storedNumberOfIds = numberOfIds - 1;
        if ((id & 0x3FFFFFFFFFFFFFL) != id) {
            throw new IllegalArgumentException("ID " + id + " is too big");
        }
        if (((long)storedNumberOfIds & 0xFFL) != (long)storedNumberOfIds) {
            throw new IllegalArgumentException("Number of IDs " + numberOfIds + " is too big");
        }
        return id << 9 | (long)storedNumberOfIds & 0xFFL | (used ? 256L : 0L);
    }

    public static long idFromCombinedId(long combinedId) {
        return combinedId >>> 9;
    }

    public static int numberOfIdsFromCombinedId(long combinedId) {
        return (int)(combinedId & 0xFFL) + 1;
    }

    public static boolean usedFromCombinedId(long combined) {
        return (combined & 0x100L) != 0L;
    }
}

