/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.range;

import java.util.Arrays;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.range.PageIdRange;

public class ArrayBasedRange
implements PageIdRange {
    private final long[] ids;
    private final int idsPerPage;
    private int cursor = 0;
    private int marker;

    public ArrayBasedRange(long[] ids, int idsPerPage) {
        this.ids = ids;
        this.idsPerPage = idsPerPage;
    }

    @Override
    public long nextId() {
        return this.ids[this.cursor++];
    }

    @Override
    public long nextConsecutiveIdRange(int numberOfIds) {
        assert (numberOfIds > 0);
        if (this.cursor + numberOfIds > this.ids.length) {
            return -1L;
        }
        long prev = this.ids[this.cursor];
        for (int i = this.cursor + 1; i < this.cursor + numberOfIds; ++i) {
            if (this.ids[i] != prev + 1L) {
                return -1L;
            }
            prev = this.ids[i];
        }
        long result = this.ids[this.cursor];
        this.cursor += numberOfIds;
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.ids.length;
    }

    @Override
    public void unallocate(IdGenerator.TransactionalMarker marker) {
        while (this.hasNext()) {
            marker.markUnallocated(this.nextId());
        }
    }

    @Override
    public void mark() {
        this.marker = this.cursor;
    }

    @Override
    public void resetToMark() {
        this.cursor = this.marker;
    }

    @Override
    public long pageId() {
        return this.ids[0] / (long)this.idsPerPage;
    }

    public String toString() {
        return "ArrayBasedRange{ids=" + Arrays.toString(this.ids) + ", idsPerPage=" + this.idsPerPage + ", cursor=" + this.cursor + ", marker=" + this.marker + "}";
    }
}

