/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.id.AbstractBufferingIdGeneratorFactory;
import org.neo4j.internal.id.BufferedIds;
import org.neo4j.internal.id.BufferingIdGenerator;
import org.neo4j.internal.id.DiskBufferedIds;
import org.neo4j.internal.id.HeapBufferedIds;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class BufferingIdGeneratorFactory
extends AbstractBufferingIdGeneratorFactory {
    public static final String PAGED_ID_BUFFER_FILE_NAME = "id-buffer.tmp";
    public static final Predicate<String> PAGED_ID_BUFFER_FILE_NAME_FILTER = new Predicate<String>(){
        private final Pattern pattern = Pattern.compile(".*id-buffer.tmp.+\\d$");

        @Override
        public boolean test(String fileName) {
            return this.pattern.matcher(fileName).matches();
        }
    };
    private final Map<IdType, BufferingIdGenerator> overriddenIdGenerators = new ConcurrentHashMap<IdType, BufferingIdGenerator>();
    private FileSystemAbstraction fs;
    private Path bufferBasePath;
    private Config config;
    private Supplier<IdController.TransactionSnapshot> snapshotSupplier;
    private IdController.IdFreeCondition condition;
    private MemoryTracker memoryTracker;
    private BufferedIds bufferQueue;
    private final IdTypeMapping idTypeMapping = new IdTypeMapping();
    private final Lock bufferWriteLock = new ReentrantLock();
    private final Lock bufferReadLock = new ReentrantLock();

    public BufferingIdGeneratorFactory(IdGeneratorFactory delegate) {
        super(delegate);
    }

    @Override
    public void initialize(FileSystemAbstraction fs, Path bufferBasePath, Config config, Supplier<IdController.TransactionSnapshot> snapshotSupplier, IdController.TransactionIdVisibilityBoundary visibilityBoundary, IdController.IdFreeCondition condition, MemoryTracker memoryTracker) throws IOException {
        this.fs = fs;
        this.bufferBasePath = bufferBasePath;
        this.config = config;
        this.snapshotSupplier = snapshotSupplier;
        this.condition = condition;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public IdGenerator get(IdType idType) {
        IdGenerator generator = this.overriddenIdGenerators.get(idType);
        return generator != null ? generator : this.delegate.get(idType);
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        this.overriddenIdGenerators.values().forEach(visitor);
    }

    @Override
    public void clearCache(boolean allocationEnabled, CursorContext cursorContext) {
        this.bufferReadLock.lock();
        this.bufferWriteLock.lock();
        try {
            this.bufferQueue.clear();
            this.overriddenIdGenerators.values().forEach(generator -> generator.clearCache(allocationEnabled, cursorContext));
        }
        finally {
            this.bufferWriteLock.unlock();
            this.bufferReadLock.unlock();
        }
    }

    @Override
    protected IdGenerator wrapAndKeep(IdType idType, IdGenerator generator) {
        int id = this.idTypeMapping.map(idType);
        BufferingIdGenerator bufferingGenerator = new BufferingIdGenerator(this, generator, id, this.memoryTracker, () -> this.collectAndOffloadBufferedIds(false));
        this.overriddenIdGenerators.put(idType, bufferingGenerator);
        return bufferingGenerator;
    }

    @Override
    public void maintenance(CursorContext cursorContext) {
        this.collectAndOffloadBufferedIds(true);
        this.bufferReadLock.lock();
        try {
            this.bufferQueue.read(new IdFreer(cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.bufferReadLock.unlock();
        }
        this.overriddenIdGenerators.values().forEach(generator -> generator.maintenance(cursorContext));
    }

    private void collectAndOffloadBufferedIds(boolean blocking) {
        if (blocking) {
            this.bufferWriteLock.lock();
        } else if (!this.bufferWriteLock.tryLock()) {
            return;
        }
        try {
            ArrayList<IdBuffer> buffers = new ArrayList<IdBuffer>();
            this.overriddenIdGenerators.values().forEach(generator -> generator.collectBufferedIds(buffers));
            if (!buffers.isEmpty()) {
                this.bufferQueue.write(this.snapshotSupplier.get(), buffers);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.bufferWriteLock.unlock();
        }
    }

    public void init() throws Exception {
        this.bufferQueue = (Boolean)this.config.get(GraphDatabaseInternalSettings.buffered_ids_offload) != false ? new DiskBufferedIds(this.fs, this.bufferBasePath, this.memoryTracker, DiskBufferedIds.DEFAULT_SEGMENT_SIZE) : new HeapBufferedIds();
    }

    public void stop() throws Exception {
        this.maintenance(CursorContext.NULL_CONTEXT);
        this.overriddenIdGenerators.forEach((type, generator) -> generator.stop());
        this.overriddenIdGenerators.clear();
        super.stop();
    }

    public void shutdown() throws Exception {
        this.bufferReadLock.lock();
        this.bufferWriteLock.lock();
        try {
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.bufferQueue});
            this.overriddenIdGenerators.clear();
            this.idTypeMapping.clear();
        }
        finally {
            this.bufferWriteLock.unlock();
            this.bufferReadLock.unlock();
        }
    }

    public void release(IdType idType) {
        this.overriddenIdGenerators.remove(idType);
    }

    private static class IdTypeMapping {
        private final List<IdType> idTypes = new CopyOnWriteArrayList<IdType>();

        private IdTypeMapping() {
        }

        int map(IdType idType) {
            Preconditions.checkState((!this.idTypes.contains(idType) ? 1 : 0) != 0, (String)"IdType %s already added", (Object[])new Object[]{idType});
            this.idTypes.add(idType);
            return this.idTypes.size() - 1;
        }

        IdType get(int value) {
            return this.idTypes.get(value);
        }

        void clear() {
            this.idTypes.clear();
        }
    }

    private class IdFreer
    implements BufferedIds.BufferedIdVisitor {
        private final CursorContext cursorContext;
        private IdGenerator.ContextualMarker marker;

        IdFreer(CursorContext cursorContext) {
            this.cursorContext = cursorContext;
        }

        @Override
        public boolean startChunk(IdController.TransactionSnapshot snapshot) {
            return BufferingIdGeneratorFactory.this.condition.eligibleForFreeing(snapshot);
        }

        @Override
        public void startType(int idTypeOrdinal) {
            BufferingIdGenerator generator = BufferingIdGeneratorFactory.this.overriddenIdGenerators.get(BufferingIdGeneratorFactory.this.idTypeMapping.get(idTypeOrdinal));
            this.marker = generator != null ? generator.delegate.contextualMarker(this.cursorContext) : IdGenerator.NOOP_MARKER;
        }

        @Override
        public void id(long id) {
            this.marker.markFree(IdUtils.idFromCombinedId(id), IdUtils.numberOfIdsFromCombinedId(id));
        }

        @Override
        public void endType() {
            this.marker.close();
        }

        @Override
        public void endChunk() {
        }
    }

    record IdBuffer(int idTypeOrdinal, HeapTrackingLongArrayList ids) implements AutoCloseable
    {
        @Override
        public void close() {
            this.ids.close();
        }
    }
}

