/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.security;

import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class AuthorizationViolationException
extends GqlRuntimeException
implements Status.HasStatus {
    public static final String PERMISSION_DENIED = "Permission denied.";
    private final Status statusCode;

    @Deprecated
    public AuthorizationViolationException(String message, Status statusCode) {
        super(message);
        this.statusCode = statusCode;
    }

    public AuthorizationViolationException(ErrorGqlStatusObject gqlStatusObject, String message, Status statusCode) {
        super(gqlStatusObject, message);
        this.statusCode = statusCode;
    }

    @Deprecated
    public AuthorizationViolationException(String message) {
        super(message);
        this.statusCode = Status.Security.Forbidden;
    }

    private AuthorizationViolationException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
        this.statusCode = Status.Security.Forbidden;
    }

    public static AuthorizationViolationException authorizationViolation(String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new AuthorizationViolationException(gql, message);
    }

    public static AuthorizationViolationException permissionDeniedUnauthorized() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new AuthorizationViolationException(gql, PERMISSION_DENIED, (Status)Status.Security.Unauthorized);
    }

    public static AuthorizationViolationException permissionDeniedForbidden() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new AuthorizationViolationException(gql, PERMISSION_DENIED, (Status)Status.Security.Forbidden);
    }

    public static AuthorizationViolationException updatesWhenImpersonating() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new AuthorizationViolationException(gql, "Not allowed to run updating system commands when impersonating a user.");
    }

    public static AuthorizationViolationException revokingImmutablePrivileges() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new AuthorizationViolationException(gql, "Immutable privileges cannot be revoked.");
    }

    public static AuthorizationViolationException grantingImmutablePrivileges(String action) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new AuthorizationViolationException(gql, String.format("Permission cannot be granted for %s.", action));
    }

    public Status status() {
        return this.statusCode;
    }
}

