/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.kernel.api.exceptions.Status;

public class TransientTransactionFailureException
extends TransientFailureException {
    private final Status status;

    protected TransientTransactionFailureException(ErrorGqlStatusObject gqlStatusObject, Status status, String message) {
        super(gqlStatusObject, message);
        this.status = status;
    }

    public TransientTransactionFailureException(ErrorGqlStatusObject gqlStatusObject, Status status, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
        this.status = status;
    }

    public static TransientTransactionFailureException leaseExpired(String tokenRequest, int currentLeaseId, int requestLeaseId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N08).build();
        String errorMsg = String.format("The lease used for %s has expired: [current lease id:%d, token request lease id:%d]", tokenRequest, currentLeaseId, requestLeaseId);
        return new TransientTransactionFailureException(gql, (Status)Status.Transaction.LeaseExpired, errorMsg);
    }

    public static TransientTransactionFailureException procedureRegistryIsBusy() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N21).build();
        return new TransientTransactionFailureException(gql, (Status)Status.Procedure.ProcedureCallFailed, "The procedure registry is busy. You may retry this operation.");
    }

    public static TransientTransactionFailureException procedureRegistryWasModified() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N21).build();
        return new TransientTransactionFailureException(gql, (Status)Status.Procedure.ProcedureCallFailed, "The procedure registry was modified by another transaction. You may retry this operation.");
    }

    public static TransientTransactionFailureException internalError(String msgTitle, String message, Status status) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new TransientTransactionFailureException(gql, status, message);
    }

    public static TransientTransactionFailureException internalError(String msgTitle, String message, Status status, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new TransientTransactionFailureException(gql, status, message, cause);
    }

    public Status status() {
        return this.status;
    }
}

