/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.security;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class AuthorizationViolationException
extends GqlRuntimeException
implements Status.HasStatus {
    public static final String PERMISSION_DENIED = "Permission denied.";
    private final Status statusCode;

    @Deprecated
    public AuthorizationViolationException(String message, Status statusCode) {
        super(message);
        this.statusCode = statusCode;
    }

    public AuthorizationViolationException(ErrorGqlStatusObject gqlStatusObject, String message, Status statusCode) {
        super(gqlStatusObject, message);
        this.statusCode = statusCode;
    }

    @Deprecated
    public AuthorizationViolationException(String message) {
        super(message);
        this.statusCode = Status.Security.Forbidden;
    }

    private AuthorizationViolationException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
        this.statusCode = Status.Security.Forbidden;
    }

    public static AuthorizationViolationException authorizationViolation(String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthorizationViolationException(gql, message);
    }

    public static AuthorizationViolationException credentialsExpired(String oldMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFD).build()).build();
        return new AuthorizationViolationException(gql, oldMessage, (Status)Status.Security.CredentialsExpired);
    }

    public static AuthorizationViolationException impersonationDisallowed(String oldMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N83).build();
        return new AuthorizationViolationException(gql, oldMessage, (Status)Status.Security.CredentialsExpired);
    }

    public static AuthorizationViolationException permissionDeniedUnauthorized() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthorizationViolationException(gql, PERMISSION_DENIED, (Status)Status.Security.Unauthorized);
    }

    public static AuthorizationViolationException permissionDeniedForbidden() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthorizationViolationException(gql, PERMISSION_DENIED, (Status)Status.Security.Forbidden);
    }

    public static AuthorizationViolationException updatesWhenImpersonating() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthorizationViolationException(gql, "Not allowed to run updating system commands when impersonating a user.");
    }

    public static AuthorizationViolationException revokingImmutablePrivileges(String role) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthorizationViolationException(gql, "Immutable privileges cannot be revoked. Use `SHOW ROLE %s PRIVILEGES AS COMMANDS YIELD *` to inspect %s's privileges.".formatted(role, role));
    }

    public static AuthorizationViolationException grantingImmutablePrivileges() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthorizationViolationException(gql, "Immutable privileges cannot be granted. Try granting the privilege without the IMMUTABLE keyword.");
    }

    public static AuthorizationViolationException denyingImmutablePrivileges() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthorizationViolationException(gql, "Immutable privileges cannot be denied. Try denying the privilege without the IMMUTABLE keyword.");
    }

    public static AuthorizationViolationException droppingImmutableRoles() {
        return AuthorizationViolationException.authorizationViolation("Immutable roles cannot be dropped. Use `SHOW ROLES YIELD *` to see which roles are immutable.");
    }

    public static AuthorizationViolationException creatingImmutableRoles() {
        return AuthorizationViolationException.authorizationViolation("Immutable roles cannot be created. Try creating the role without the IMMUTABLE keyword.");
    }

    public static AuthorizationViolationException replacingImmutableRoles() {
        return AuthorizationViolationException.authorizationViolation("Immutable roles cannot be replaced. Use `SHOW ROLES YIELD *` to see which roles are immutable.");
    }

    public static AuthorizationViolationException renamingImmutableRoles() {
        return AuthorizationViolationException.authorizationViolation("Immutable roles cannot be renamed. Use `SHOW ROLES YIELD *` to see which roles are immutable.");
    }

    public static AuthorizationViolationException assigningMutablePrivilegesToImmutableRole() {
        return AuthorizationViolationException.authorizationViolation("Only immutable privileges can be assigned to an immutable role. Try `GRANT/DENY IMMUTABLE` instead.");
    }

    public static AuthorizationViolationException copyingRoleWithMutablePrivileges(String role) {
        return AuthorizationViolationException.authorizationViolation("'$role' cannot be copied to an immutable role because '$role' has one or more non-immutable privileges. Immutable roles can only contain immutable privileges. Use `SHOW ROLE $role PRIVILEGES AS COMMANDS YIELD *` to inspect $role's privileges.".replace("$role", role));
    }

    public static AuthorizationViolationException copyingRoleWithImmutablePrivileges(String role) {
        return AuthorizationViolationException.authorizationViolation("'$role' cannot be copied because it has one or more immutable privileges assigned to it and immutable privileges cannot be copied. Use `SHOW ROLE $role PRIVILEGES AS COMMANDS YIELD *` to inspect $role's privileges.".replace("$role", role));
    }

    public static String generateCredentialsExpiredMessage(String message) {
        return String.format("%s%n%nThe credentials you provided were valid, but must be changed before you can use this instance. If this is the first time you are using Neo4j, this is to ensure you are not using the default credentials in production. If you are not using default credentials, you are getting this message because an administrator requires a password change.%nTo change your password, issue an `ALTER CURRENT USER SET PASSWORD FROM 'current password' TO 'new password'` statement against the system database.", message);
    }

    public Status status() {
        return this.statusCode;
    }
}

