/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.graphcounts;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import org.json4s.DefaultFormats$;
import org.json4s.FileInput;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonInput;
import org.json4s.Serializer;
import org.json4s.StringInput;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.neo4j.cypher.graphcounts.ApocMeta;
import org.neo4j.cypher.graphcounts.ApocMetaStats;
import org.neo4j.cypher.graphcounts.ConstraintTypeSerializer$;
import org.neo4j.cypher.graphcounts.Data;
import org.neo4j.cypher.graphcounts.DbStatsRetrieveGraphCountsJSON;
import org.neo4j.cypher.graphcounts.EndpointTypeSerializer$;
import org.neo4j.cypher.graphcounts.GraphCountData;
import org.neo4j.cypher.graphcounts.IndexProviderSerializer$;
import org.neo4j.cypher.graphcounts.IndexTypeSerializer$;
import org.neo4j.cypher.graphcounts.Result;
import org.neo4j.cypher.graphcounts.Row;
import org.neo4j.cypher.graphcounts.RowSerializer$;
import org.neo4j.cypher.graphcounts.SchemaValueTypes$Serializer$;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.NumberLiteral;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.parser.AstParserFactory$;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.Neo4jCypherExceptionFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ManifestFactory$;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class GraphCountsJson$ {
    public static final GraphCountsJson$ MODULE$ = new GraphCountsJson$();
    private static final Formats allFormatsExceptRowSerializer = DefaultFormats$.MODULE$.$plus((Serializer)IndexTypeSerializer$.MODULE$).$plus((Serializer)IndexProviderSerializer$.MODULE$).$plus((Serializer)ConstraintTypeSerializer$.MODULE$).$plus((Serializer)SchemaValueTypes$Serializer$.MODULE$).$plus((Serializer)EndpointTypeSerializer$.MODULE$);
    private static final Formats allFormats = MODULE$.allFormatsExceptRowSerializer().$plus((Serializer)RowSerializer$.MODULE$);
    private static final Regex CsvContent = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\\s*section,data\n         |\\\"\\\"\\\"GRAPH COUNTS\\\"\\\"\\\",\"(.*)\""))));

    public Formats allFormatsExceptRowSerializer() {
        return allFormatsExceptRowSerializer;
    }

    public Formats allFormats() {
        return allFormats;
    }

    public GraphCountData parseAsGraphCountData(File file) {
        Formats formats = this.allFormats();
        return (GraphCountData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new FileInput(file), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(formats, ManifestFactory$.MODULE$.classType(GraphCountData.class));
    }

    public DbStatsRetrieveGraphCountsJSON parseAsGraphCountsJson(File file) {
        Formats formats = this.allFormats();
        return (DbStatsRetrieveGraphCountsJSON)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new FileInput(file), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(formats, ManifestFactory$.MODULE$.classType(DbStatsRetrieveGraphCountsJSON.class));
    }

    public GraphCountData parseAsGraphCountDataFromString(String str) {
        Formats formats = this.allFormats();
        return (GraphCountData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(str), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(formats, ManifestFactory$.MODULE$.classType(GraphCountData.class));
    }

    public GraphCountData parseAsGraphCountRowsFromFile(File file) {
        return this.parseAsGraphCountRowsFromString(this.readFile(file));
    }

    public GraphCountData parseAsGraphCountRowsFromString(String str) {
        Formats formats = this.allFormatsExceptRowSerializer();
        JsonAST.JValue value = JsonMethods$.MODULE$.parse((JsonInput)new StringInput(str), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Seq rows = (Seq)package$.MODULE$.jvalue2extractable(value).extract(formats, ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(Row.class), (Seq)Nil$.MODULE$));
        return ((Row)rows.head()).data();
    }

    public DbStatsRetrieveGraphCountsJSON parseAsGraphCountsJsonFromString(String str) {
        Formats formats = this.allFormats();
        return (DbStatsRetrieveGraphCountsJSON)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(str), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(formats, ManifestFactory$.MODULE$.classType(DbStatsRetrieveGraphCountsJSON.class));
    }

    public GraphCountData parseAsGraphCountDataFromCypherMap(File file) {
        return this.parseAsGraphCountDataFromCypherMapString(this.readFile(file));
    }

    public String mapLiteralToJson(Expression cypherLiteral2) {
        Expression expression = cypherLiteral2;
        if (expression instanceof MapExpression) {
            MapExpression mapExpression = (MapExpression)expression;
            Seq items = mapExpression.items();
            return ((IterableOnceOps)items.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    PropertyKeyName propertyKeyName = (PropertyKeyName)tuple2._1();
                    Expression value = (Expression)tuple2._2();
                    if (propertyKeyName != null) {
                        String prop = propertyKeyName.name();
                        return "\"" + prop + "\":" + MODULE$.mapLiteralToJson(value);
                    }
                }
                throw new MatchError((Object)tuple2);
            })).mkString("{", ",", "}");
        }
        if (expression instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)expression;
            Seq expressions = listLiteral.expressions();
            return ((IterableOnceOps)expressions.map((Function1 & Serializable)cypherLiteral -> MODULE$.mapLiteralToJson((Expression)cypherLiteral))).mkString("[", ",", "]");
        }
        if (expression instanceof NumberLiteral) {
            NumberLiteral numberLiteral = (NumberLiteral)expression;
            return numberLiteral.asCanonicalStringVal();
        }
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            String stringValue = stringLiteral.value();
            return "\"" + stringValue + "\"";
        }
        throw new IllegalArgumentException("Cannot convert " + cypherLiteral2 + " to json.");
    }

    public GraphCountData parseAsGraphCountDataFromCypherMapString(String mapString) {
        Expression mapExpression = AstParserFactory$.MODULE$.apply(CypherVersion.Default).apply(mapString, (CypherExceptionFactory)new Neo4jCypherExceptionFactory(mapString, (Option)None$.MODULE$), (Option)None$.MODULE$, (Seq)Nil$.MODULE$).expression();
        String json = this.mapLiteralToJson(mapExpression);
        return this.parseAsGraphCountDataFromString(json);
    }

    public GraphCountData parseAsGraphCountsCsv(File file) {
        return this.parseAsGraphCountsCsvString(this.readFile(file));
    }

    private String readFile(File file) {
        String fileContent = Files.readString(file.toPath());
        return fileContent.replace("\ufeff", "");
    }

    private Regex CsvContent() {
        return CsvContent;
    }

    public GraphCountData parseAsGraphCountsCsvString(String csvContent) {
        Option option;
        String string = csvContent;
        if (string == null || (option = this.CsvContent().unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(1) != 0) {
            throw new IllegalArgumentException("Unexpected format for csv file:\n" + csvContent.substring(0, 30) + "...");
        }
        String content = (String)((LinearSeqOps)option.get()).apply(0);
        String content2 = content;
        String unescaped = content2.replaceAll("\"\"", "\"");
        return this.parseAsGraphCountDataFromCypherMapString(unescaped);
    }

    public GraphCountData getGraphCounts(File file) {
        String content = this.readFile(file);
        return (GraphCountData)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            DbStatsRetrieveGraphCountsJSON graphCounts = MODULE$.parseAsGraphCountsJsonFromString(content);
            return ((Data)((Result)graphCounts.results().head()).data().head()).row().data();
        }).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.parseAsGraphCountRowsFromString(content))).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.parseAsGraphCountDataFromString(content))).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.parseAsGraphCountDataFromCypherMapString(content))).getOrElse((Function0 & Serializable)() -> MODULE$.parseAsGraphCountsCsvString(content));
    }

    public ApocMetaStats parseMetaStats(File file) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue json = JsonMethods$.MODULE$.parse((JsonInput)new FileInput(file), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        return ((ApocMeta)((IterableOps)package$.MODULE$.jvalue2extractable(json).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(ApocMeta.class), (Seq)Nil$.MODULE$))).head()).stats();
    }

    private GraphCountsJson$() {
    }
}

