/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Comparator;
import java.util.function.BiFunction;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.internal.helpers.MathUtil;

public class PathInterestFactory {
    public static final Comparator<Comparable> STANDARD_COMPARATOR = Comparable::compareTo;
    private static final PathInterest<? extends Comparable> SINGLE = new PathInterest<Comparable>(){

        @Override
        public Comparator<Comparable> comparator() {
            return STANDARD_COMPARATOR;
        }

        @Override
        public boolean canBeRuledOut(int numberOfVisits, Comparable pathPriority, Comparable oldPriority) {
            return numberOfVisits > 0 || pathPriority.compareTo(oldPriority) >= 0;
        }

        @Override
        public boolean stillInteresting(int numberOfVisits) {
            return numberOfVisits <= 1;
        }

        @Override
        public boolean stopAfterLowestCost() {
            return true;
        }
    };
    private static final PathInterest<? extends Comparable> ALL_SHORTEST = new PathInterest.PriorityBasedPathInterest<Comparable>(){
        private BiFunction<Comparable, Comparable, Boolean> interestFunction;

        @Override
        public BiFunction<Comparable, Comparable, Boolean> interestFunction() {
            if (this.interestFunction == null) {
                this.interestFunction = (newValue, oldValue) -> newValue.compareTo(oldValue) <= 0;
            }
            return this.interestFunction;
        }

        @Override
        public Comparator<Comparable> comparator() {
            return STANDARD_COMPARATOR;
        }
    };
    private static final PathInterest<? extends Comparable> ALL = new PathInterest<Comparable>(){

        @Override
        public Comparator<Comparable> comparator() {
            return STANDARD_COMPARATOR;
        }

        @Override
        public boolean canBeRuledOut(int numberOfVisits, Comparable pathPriority, Comparable oldPriority) {
            return false;
        }

        @Override
        public boolean stillInteresting(int numberOfVisits) {
            return true;
        }

        @Override
        public boolean stopAfterLowestCost() {
            return false;
        }
    };

    private PathInterestFactory() {
    }

    public static PathInterest<? extends Comparable> single() {
        return SINGLE;
    }

    public static PathInterest<? extends Comparable> allShortest() {
        return ALL_SHORTEST;
    }

    public static PathInterest<? extends Comparable> all() {
        return ALL;
    }

    public static <P extends Comparable<? super P>> PathInterest<P> numberOfShortest(final int numberOfWantedPaths) {
        if (numberOfWantedPaths < 1) {
            throw new IllegalArgumentException("Can not create PathInterest with interested in less than 1 path.");
        }
        return new PathInterest.VisitCountBasedPathInterest<P>(){
            private Comparator<P> comparator = Comparable::compareTo;

            @Override
            int numberOfWantedPaths() {
                return numberOfWantedPaths;
            }

            @Override
            public Comparator<P> comparator() {
                return this.comparator;
            }
        };
    }

    public static PathInterest<Double> allShortest(double epsilon) {
        return new PriorityBasedTolerancePathInterest(epsilon);
    }

    public static PathInterest<Double> all(double epsilon) {
        return new AllTolerancePathInterest(epsilon);
    }

    public static PathInterest<Double> numberOfShortest(double epsilon, int numberOfWantedPaths) {
        return new VisitCountBasedTolerancePathInterest(epsilon, numberOfWantedPaths);
    }

    public static PathInterest<Double> single(double epsilon) {
        return new SingleTolerancePathInterest(epsilon);
    }

    private static class PriorityBasedTolerancePathInterest
    extends PathInterest.PriorityBasedPathInterest<Double> {
        private final BiFunction<Double, Double, Boolean> interestFunction = (newValue, oldValue) -> MathUtil.compare((double)newValue, (double)oldValue, (double)epsilon) <= 0;
        private final Comparator<Double> comparator;

        PriorityBasedTolerancePathInterest(double epsilon) {
            this.comparator = new MathUtil.CommonToleranceComparator(epsilon);
        }

        @Override
        public BiFunction<Double, Double, Boolean> interestFunction() {
            return this.interestFunction;
        }

        @Override
        public Comparator<Double> comparator() {
            return this.comparator;
        }
    }

    private static class AllTolerancePathInterest
    implements PathInterest<Double> {
        private final Comparator<Double> comparator;

        AllTolerancePathInterest(double epsilon) {
            this.comparator = new MathUtil.CommonToleranceComparator(epsilon);
        }

        @Override
        public Comparator<Double> comparator() {
            return this.comparator;
        }

        @Override
        public boolean canBeRuledOut(int numberOfVisits, Double pathPriority, Double oldPriority) {
            return false;
        }

        @Override
        public boolean stillInteresting(int numberOfVisits) {
            return true;
        }

        @Override
        public boolean stopAfterLowestCost() {
            return false;
        }
    }

    private static class VisitCountBasedTolerancePathInterest
    extends PathInterest.VisitCountBasedPathInterest<Double> {
        private final int numberOfWantedPaths;
        private final Comparator<Double> comparator;

        VisitCountBasedTolerancePathInterest(double epsilon, int numberOfWantedPaths) {
            this.numberOfWantedPaths = numberOfWantedPaths;
            this.comparator = new MathUtil.CommonToleranceComparator(epsilon);
        }

        @Override
        int numberOfWantedPaths() {
            return this.numberOfWantedPaths;
        }

        @Override
        public Comparator<Double> comparator() {
            return this.comparator;
        }
    }

    private static class SingleTolerancePathInterest
    implements PathInterest<Double> {
        private final double epsilon;
        private final Comparator<Double> comparator;

        SingleTolerancePathInterest(double epsilon) {
            this.epsilon = epsilon;
            this.comparator = new MathUtil.CommonToleranceComparator(epsilon);
        }

        @Override
        public Comparator<Double> comparator() {
            return this.comparator;
        }

        @Override
        public boolean canBeRuledOut(int numberOfVisits, Double pathPriority, Double oldPriority) {
            return numberOfVisits > 0 || MathUtil.compare((double)pathPriority, (double)oldPriority, (double)this.epsilon) >= 0;
        }

        @Override
        public boolean stillInteresting(int numberOfVisits) {
            return numberOfVisits <= 1;
        }

        @Override
        public boolean stopAfterLowestCost() {
            return true;
        }
    }
}

