/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.shortestpath;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.neo4j.graphalgo.impl.shortestpath.DijkstraPriorityQueue;
import org.neo4j.graphdb.Node;

public class DijkstraPriorityQueueImpl<CostType>
implements DijkstraPriorityQueue<CostType> {
    Comparator<CostType> costComparator;
    PriorityQueue<pathObject> queue;

    public DijkstraPriorityQueueImpl(Comparator<CostType> costComparator) {
        this.costComparator = costComparator;
        this.queue = new PriorityQueue(11, (o1, o2) -> costComparator.compare(o1.getCost(), o2.getCost()));
    }

    @Override
    public void insertValue(Node node, CostType value) {
        this.queue.add(new pathObject(node, value));
    }

    @Override
    public void decreaseValue(Node node, CostType newValue) {
        pathObject po = new pathObject(node, newValue);
        this.queue.add(po);
    }

    @Override
    public Node extractMin() {
        pathObject po = this.queue.poll();
        if (po == null) {
            return null;
        }
        return po.getNode();
    }

    @Override
    public Node peek() {
        pathObject po = this.queue.peek();
        if (po == null) {
            return null;
        }
        return po.getNode();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    protected class pathObject {
        private Node node;
        private CostType cost;

        public pathObject(Node node, CostType cost) {
            this.node = node;
            this.cost = cost;
        }

        public CostType getCost() {
            return this.cost;
        }

        public Node getNode() {
            return this.node;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            pathObject other = (pathObject)obj;
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }

        public int hashCode() {
            int result = this.node != null ? this.node.hashCode() : 0;
            result = 31 * result + (this.cost != null ? this.cost.hashCode() : 0);
            return result;
        }
    }
}

