/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.NestingResourceIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.monitoring.Monitors;

public class ShortestPath
implements PathFinder<Path> {
    public final int NULL = -1;
    private final int maxDepth;
    private final int maxResultCount;
    private final PathExpander expander;
    private Metadata lastMetadata;
    private ShortestPathPredicate predicate;
    private DataMonitor dataMonitor;

    public ShortestPath(int maxDepth, PathExpander expander) {
        this(maxDepth, expander, Integer.MAX_VALUE);
    }

    public ShortestPath(int maxDepth, PathExpander expander, ShortestPathPredicate predicate) {
        this(maxDepth, expander);
        this.predicate = predicate;
    }

    public ShortestPath(int maxDepth, PathExpander expander, int maxResultCount) {
        this.maxDepth = maxDepth;
        this.expander = expander;
        this.maxResultCount = maxResultCount;
    }

    @Override
    public Iterable<Path> findAllPaths(Node start, Node end) {
        return this.internalPaths(start, end, false);
    }

    @Override
    public Path findSinglePath(Node start, Node end) {
        Iterator<Path> paths = this.internalPaths(start, end, true).iterator();
        return paths.hasNext() ? paths.next() : null;
    }

    private void resolveMonitor(Node node) {
        GraphDatabaseService service;
        if (this.dataMonitor == null && (service = node.getGraphDatabase()) instanceof GraphDatabaseFacade) {
            Monitors monitors = (Monitors)((GraphDatabaseFacade)service).getDependencyResolver().resolveDependency(Monitors.class);
            this.dataMonitor = (DataMonitor)monitors.newMonitor(DataMonitor.class, new String[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private Iterable<Path> internalPaths(Node start, Node end, boolean stopAsap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastMetadata;
    }

    private void goOneStep(DirectionData directionData, DirectionData otherSide, Hits hits, DirectionData startSide, boolean stopAsap) {
        if (!directionData.hasNext()) {
            otherSide.finishCurrentLayerThenStop = true;
            return;
        }
        Node nextNode = (Node)directionData.next();
        LevelData otherSideHit = (LevelData)otherSide.visitedNodes.get(nextNode);
        if (otherSideHit != null) {
            int depth = directionData.currentDepth + otherSideHit.depth;
            if (directionData.sharedFrozenDepth.intValue() == -1) {
                directionData.sharedFrozenDepth.setValue(depth);
            }
            if (depth <= directionData.sharedFrozenDepth.intValue()) {
                directionData.haveFoundSomething = true;
                if (depth < directionData.sharedFrozenDepth.intValue()) {
                    directionData.sharedFrozenDepth.setValue(depth);
                    otherSide.stop = true;
                }
                DirectionData startSideData = directionData == startSide ? directionData : otherSide;
                DirectionData endSideData = directionData == startSide ? otherSide : directionData;
                Hit hit = new Hit(startSideData, endSideData, nextNode);
                Node start = startSide.startNode;
                Node end = startSide == directionData ? otherSide.startNode : directionData.startNode;
                this.monitorData(startSide, otherSide == startSide ? directionData : otherSide, nextNode);
                if (!stopAsap || this.filterPaths(ShortestPath.hitToPaths(hit, start, end, stopAsap)).size() > 0) {
                    if (hits.add(hit, depth) >= this.maxResultCount) {
                        directionData.stop = true;
                        otherSide.stop = true;
                        this.lastMetadata.paths++;
                    } else if (stopAsap) {
                        if (otherSide.stop) {
                            return;
                        }
                        directionData.stop = true;
                    }
                } else {
                    directionData.haveFoundSomething = false;
                    directionData.sharedFrozenDepth.setValue(-1);
                    otherSide.stop = false;
                }
            }
        }
    }

    private void monitorData(DirectionData directionData, DirectionData otherSide, Node connectingNode) {
        this.resolveMonitor(directionData.startNode);
        if (this.dataMonitor != null) {
            this.dataMonitor.monitorData(directionData.visitedNodes, directionData.nextNodes, otherSide.visitedNodes, otherSide.nextNodes, connectingNode);
        }
    }

    private Collection<Path> filterPaths(Collection<Path> paths) {
        if (this.predicate == null) {
            return paths;
        }
        ArrayList<Path> filteredPaths = new ArrayList<Path>();
        for (Path path : paths) {
            if (!this.predicate.test(path)) continue;
            filteredPaths.add(path);
        }
        return filteredPaths;
    }

    protected Node filterNextLevelNodes(Node nextNode) {
        return nextNode;
    }

    private static Collection<Path> hitsToPaths(Collection<Hit> depthHits, Node start, Node end, boolean stopAsap, int maxResultCount) {
        LinkedHashMap<String, Path> paths = new LinkedHashMap<String, Path>();
        block0: for (Hit hit : depthHits) {
            for (Path path : ShortestPath.hitToPaths(hit, start, end, stopAsap)) {
                paths.put(path.toString(), path);
                if (paths.size() < maxResultCount) continue;
                continue block0;
            }
        }
        return paths.values();
    }

    private static Collection<Path> hitToPaths(Hit hit, Node start, Node end, boolean stopAsap) {
        ArrayList<Path> paths = new ArrayList<Path>();
        Iterable<LinkedList<Relationship>> startPaths = ShortestPath.getPaths(hit.connectingNode, hit.start, stopAsap);
        Iterable<LinkedList<Relationship>> endPaths = ShortestPath.getPaths(hit.connectingNode, hit.end, stopAsap);
        for (LinkedList<Relationship> startPath : startPaths) {
            PathImpl.Builder startBuilder = ShortestPath.toBuilder(start, startPath);
            for (LinkedList<Relationship> endPath : endPaths) {
                PathImpl.Builder endBuilder = ShortestPath.toBuilder(end, endPath);
                Path path = startBuilder.build(endBuilder);
                paths.add(path);
            }
        }
        return paths;
    }

    private static Iterable<LinkedList<Relationship>> getPaths(Node connectingNode, DirectionData data, boolean stopAsap) {
        LevelData levelData = (LevelData)data.visitedNodes.get(connectingNode);
        if (levelData.depth == 0) {
            ArrayList<LinkedList<Relationship>> result = new ArrayList<LinkedList<Relationship>>();
            result.add(new LinkedList());
            return result;
        }
        ArrayList<PathData> set = new ArrayList<PathData>();
        GraphDatabaseService graphDb = data.startNode.getGraphDatabase();
        for (long rel : levelData.relsToHere) {
            set.add(new PathData(connectingNode, new LinkedList<Relationship>(Arrays.asList(graphDb.getRelationshipById(rel)))));
            if (stopAsap) break;
        }
        for (int i = 0; i < levelData.depth - 1; ++i) {
            ArrayList<PathData> nextSet = new ArrayList<PathData>();
            block2: for (PathData entry : set) {
                Node otherNode = ((Relationship)entry.rels.getFirst()).getOtherNode(entry.node);
                LevelData otherLevelData = (LevelData)data.visitedNodes.get(otherNode);
                int counter = 0;
                for (long rel : otherLevelData.relsToHere) {
                    LinkedList rels = ++counter == otherLevelData.relsToHere.length ? entry.rels : new LinkedList(entry.rels);
                    rels.addFirst(graphDb.getRelationshipById(rel));
                    nextSet.add(new PathData(otherNode, rels));
                    if (stopAsap) continue block2;
                }
            }
            set = nextSet;
        }
        return new IterableWrapper<LinkedList<Relationship>, PathData>(set){

            protected LinkedList<Relationship> underlyingObjectToObject(PathData object) {
                return object.rels;
            }
        };
    }

    private static PathImpl.Builder toBuilder(Node startNode, LinkedList<Relationship> rels) {
        PathImpl.Builder builder = new PathImpl.Builder(startNode);
        for (Relationship rel : rels) {
            builder = builder.push(rel);
        }
        return builder;
    }

    private static class Metadata
    implements TraversalMetadata {
        private int rels;
        private int paths;

        private Metadata() {
        }

        public int getNumberOfPathsReturned() {
            return this.paths;
        }

        public int getNumberOfRelationshipsTraversed() {
            return this.rels;
        }
    }

    private static class PathData {
        private final LinkedList<Relationship> rels;
        private final Node node;

        PathData(Node node, LinkedList<Relationship> rels) {
            this.rels = rels;
            this.node = node;
        }
    }

    private static class Hits {
        private final PrimitiveIntObjectMap<Collection<Hit>> hits = Primitive.intObjectMap();
        private int lowestDepth;
        private int totalHitCount;

        private Hits() {
        }

        int add(Hit hit, int atDepth) {
            Collection depthHits = (Collection)this.hits.computeIfAbsent(atDepth, k -> new HashSet());
            if (depthHits.add(hit)) {
                ++this.totalHitCount;
            }
            if (this.lowestDepth == 0 || atDepth < this.lowestDepth) {
                this.lowestDepth = atDepth;
            }
            return this.totalHitCount;
        }

        Collection<Hit> least() {
            return (Collection)this.hits.get(this.lowestDepth);
        }
    }

    public static class LevelData {
        private long[] relsToHere;
        public final int depth;

        LevelData(Relationship relToHere, int depth) {
            if (relToHere != null) {
                this.addRel(relToHere);
            }
            this.depth = depth;
        }

        void addRel(Relationship rel) {
            long[] newRels = null;
            if (this.relsToHere == null) {
                newRels = new long[1];
            } else {
                newRels = new long[this.relsToHere.length + 1];
                System.arraycopy(this.relsToHere, 0, newRels, 0, this.relsToHere.length);
            }
            newRels[newRels.length - 1] = rel.getId();
            this.relsToHere = newRels;
        }
    }

    private static class DirectionDataPath
    implements Path {
        private final Node startNode;
        private Node endNode;
        private int length;

        DirectionDataPath(Node startNode) {
            this.startNode = startNode;
            this.endNode = startNode;
            this.length = 0;
        }

        void setEndNode(Node endNode) {
            this.endNode = endNode;
        }

        void setLength(int length) {
            this.length = length;
        }

        public Node startNode() {
            return this.startNode;
        }

        public Node endNode() {
            return this.endNode;
        }

        public Relationship lastRelationship() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> relationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> reverseRelationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> nodes() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> reverseNodes() {
            throw new UnsupportedOperationException();
        }

        public int length() {
            return this.length;
        }

        public Iterator<PropertyContainer> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    private class DirectionData
    extends PrefetchingResourceIterator<Node> {
        private boolean finishCurrentLayerThenStop;
        private final Node startNode;
        private int currentDepth;
        private ResourceIterator<Relationship> nextRelationships;
        private final Collection<Node> nextNodes = new ArrayList<Node>();
        private final Map<Node, LevelData> visitedNodes = new HashMap<Node, LevelData>();
        private final Collection<Long> sharedVisitedRels;
        private final DirectionDataPath lastPath;
        private final MutableInt sharedFrozenDepth;
        private final MutableBoolean sharedStop;
        private final MutableInt sharedCurrentDepth;
        private boolean haveFoundSomething;
        private boolean stop;
        private final PathExpander expander;

        DirectionData(Node startNode, Collection<Long> sharedVisitedRels, MutableInt sharedFrozenDepth, MutableBoolean sharedStop, MutableInt sharedCurrentDepth, PathExpander expander) {
            this.startNode = startNode;
            this.visitedNodes.put(startNode, new LevelData(null, 0));
            this.nextNodes.add(startNode);
            this.sharedFrozenDepth = sharedFrozenDepth;
            this.sharedStop = sharedStop;
            this.sharedCurrentDepth = sharedCurrentDepth;
            this.expander = expander;
            this.sharedVisitedRels = sharedVisitedRels;
            this.lastPath = new DirectionDataPath(startNode);
            if (sharedCurrentDepth.intValue() < ShortestPath.this.maxDepth) {
                this.prepareNextLevel();
            } else {
                this.nextRelationships = Iterators.emptyResourceIterator();
            }
        }

        private void prepareNextLevel() {
            ArrayList<Node> nodesToIterate = new ArrayList<Node>(this.nextNodes);
            this.nextNodes.clear();
            this.lastPath.setLength(this.currentDepth);
            this.closeRelationshipsIterator();
            this.nextRelationships = new NestingResourceIterator<Relationship, Node>(nodesToIterate.iterator()){

                protected ResourceIterator<Relationship> createNestedIterator(Node node) {
                    DirectionData.this.lastPath.setEndNode(node);
                    return Iterators.asResourceIterator(DirectionData.this.expander.expand((Path)DirectionData.this.lastPath, BranchState.NO_STATE).iterator());
                }
            };
            ++this.currentDepth;
            this.sharedCurrentDepth.increment();
        }

        private void closeRelationshipsIterator() {
            if (this.nextRelationships != null) {
                this.nextRelationships.close();
            }
        }

        public void close() {
            this.closeRelationshipsIterator();
        }

        protected Node fetchNextOrNull() {
            Relationship nextRel;
            while ((nextRel = this.fetchNextRelOrNull()) != null) {
                Node result = nextRel.getOtherNode(this.lastPath.endNode());
                if (ShortestPath.this.filterNextLevelNodes(result) == null) continue;
                ShortestPath.this.lastMetadata.rels++;
                LevelData levelData = this.visitedNodes.get(result);
                if (levelData == null) {
                    levelData = new LevelData(nextRel, this.currentDepth);
                    this.visitedNodes.put(result, levelData);
                    this.nextNodes.add(result);
                    return result;
                }
                if (this.currentDepth != levelData.depth) continue;
                levelData.addRel(nextRel);
            }
            return null;
        }

        private boolean canGoDeeper() {
            return this.sharedFrozenDepth.intValue() == -1 && this.sharedCurrentDepth.intValue() < ShortestPath.this.maxDepth && !this.finishCurrentLayerThenStop;
        }

        private Relationship fetchNextRelOrNull() {
            boolean hasComeTooFarEmptyHanded;
            if (this.stop || this.sharedStop.booleanValue()) {
                return null;
            }
            boolean bl = hasComeTooFarEmptyHanded = this.sharedFrozenDepth.intValue() != -1 && this.sharedCurrentDepth.intValue() > this.sharedFrozenDepth.intValue() && !this.haveFoundSomething;
            if (hasComeTooFarEmptyHanded) {
                return null;
            }
            if (!this.nextRelationships.hasNext() && this.canGoDeeper()) {
                this.prepareNextLevel();
            }
            return this.nextRelationships.hasNext() ? (Relationship)this.nextRelationships.next() : null;
        }
    }

    public static interface DataMonitor {
        public void monitorData(Map<Node, LevelData> var1, Collection<Node> var2, Map<Node, LevelData> var3, Collection<Node> var4, Node var5);
    }

    private static class Hit {
        private final DirectionData start;
        private final DirectionData end;
        private final Node connectingNode;

        Hit(DirectionData start, DirectionData end, Node connectingNode) {
            this.start = start;
            this.end = end;
            this.connectingNode = connectingNode;
        }

        public int hashCode() {
            return this.connectingNode.hashCode();
        }

        public boolean equals(Object obj) {
            Hit o = (Hit)obj;
            return this.connectingNode.equals(o.connectingNode);
        }
    }

    public static interface ShortestPathPredicate {
        public boolean test(Path var1);
    }
}

