/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import org.neo4j.graphalgo.EvaluationContext;
import org.neo4j.graphalgo.impl.path.TraversalPathFinder;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;

public class AllPaths
extends TraversalPathFinder {
    private final PathExpander expander;
    private final EvaluationContext context;
    private final int maxDepth;

    public AllPaths(EvaluationContext context, int maxDepth, PathExpander expander) {
        this.context = context;
        this.maxDepth = maxDepth;
        this.expander = expander;
    }

    protected Uniqueness uniqueness() {
        return Uniqueness.RELATIONSHIP_PATH;
    }

    @Override
    protected Traverser instantiateTraverser(Node start, Node end) {
        Transaction transaction = this.context.transaction();
        TraversalDescription base = transaction.traversalDescription().depthFirst().uniqueness((UniquenessFactory)this.uniqueness());
        return transaction.bidirectionalTraversalDescription().startSide(base.expand(this.expander).evaluator(Evaluators.toDepth((int)(this.maxDepth / 2)))).endSide(base.expand(this.expander.reverse()).evaluator(Evaluators.toDepth((int)(this.maxDepth - this.maxDepth / 2)))).traverse(start, end);
    }
}

