/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Iterator;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.WeightedPathImpl;
import org.neo4j.graphdb.Path;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class WeightedPathIterator
extends PrefetchingIterator<WeightedPath> {
    private final Iterator<Path> paths;
    private final CostEvaluator<Double> costEvaluator;
    private Double foundWeight;
    private final boolean stopAfterLowestWeight;

    public WeightedPathIterator(Iterator<Path> paths, CostEvaluator<Double> costEvaluator, boolean stopAfterLowestWeight) {
        this.paths = paths;
        this.costEvaluator = costEvaluator;
        this.stopAfterLowestWeight = stopAfterLowestWeight;
    }

    protected WeightedPath fetchNextOrNull() {
        if (!this.paths.hasNext()) {
            return null;
        }
        WeightedPathImpl path = new WeightedPathImpl(this.costEvaluator, this.paths.next());
        if (this.stopAfterLowestWeight && this.foundWeight != null && path.weight() > this.foundWeight) {
            return null;
        }
        this.foundWeight = path.weight();
        return path;
    }
}

