/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.Comparator;
import java.util.Set;
import org.neo4j.graphalgo.impl.centrality.ShortestPathBasedCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphdb.Node;

public class Eccentricity<ShortestPathCostType>
extends ShortestPathBasedCentrality<ShortestPathCostType, ShortestPathCostType> {
    Comparator<ShortestPathCostType> distanceComparator;

    public Eccentricity(SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath, ShortestPathCostType zeroValue, Set<Node> nodeSet, Comparator<ShortestPathCostType> distanceComparator) {
        super(singleSourceShortestPath, null, zeroValue, nodeSet);
        this.distanceComparator = distanceComparator;
    }

    @Override
    public ShortestPathCostType getCentrality(Node node) {
        Object centrality = this.centralities.get(node);
        if (centrality == null) {
            return null;
        }
        if (centrality.equals(this.zeroValue)) {
            this.singleSourceShortestPath.reset();
            this.singleSourceShortestPath.setStartNode(node);
            this.processShortestPaths(node, this.singleSourceShortestPath);
        }
        return (ShortestPathCostType)this.centralities.get(node);
    }

    @Override
    public void processShortestPaths(Node node, SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath) {
        Object maximumDistance = null;
        for (Node targetNode : this.nodeSet) {
            ShortestPathCostType targetDistance = singleSourceShortestPath.getCost(targetNode);
            if (maximumDistance != null && this.distanceComparator.compare(maximumDistance, targetDistance) >= 0) continue;
            maximumDistance = targetDistance;
        }
        if (maximumDistance != null) {
            this.setCentralityForNode(node, maximumDistance);
        }
    }
}

